<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Time_Entry_CodeObjectType StructType
 * @subpackage Structs
 */
class Time_Entry_CodeObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Time_Entry_CodeObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta informations extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Time_Entry_CodeObjectType
     * @uses Time_Entry_CodeObjectType::setID()
     * @uses Time_Entry_CodeObjectType::setDescriptor()
     * @param \StructType\Time_Entry_CodeObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Time_Entry_CodeObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Entry_CodeObjectIDType[] $iD
     * @return \StructType\Time_Entry_CodeObjectType
     */
    public function setID(array $iD = array())
    {
        foreach ($iD as $time_Entry_CodeObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$time_Entry_CodeObjectTypeIDItem instanceof \StructType\Time_Entry_CodeObjectIDType) {
                throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Time_Entry_CodeObjectIDType, "%s" given', is_object($time_Entry_CodeObjectTypeIDItem) ? get_class($time_Entry_CodeObjectTypeIDItem) : gettype($time_Entry_CodeObjectTypeIDItem)), __LINE__);
            }
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Entry_CodeObjectIDType $item
     * @return \StructType\Time_Entry_CodeObjectType
     */
    public function addToID(\StructType\Time_Entry_CodeObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Time_Entry_CodeObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Time_Entry_CodeObjectIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Time_Entry_CodeObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Time_Entry_CodeObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
