<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Time_Clock_Event_DataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Data related to the time clock event(s) to be processed.
 * @subpackage Structs
 */
class Time_Clock_Event_DataType extends AbstractStructBase
{
    /**
     * The Time_Clock_Event_ID
     * Meta informations extracted from the WSDL
     * - documentation: Reference ID to identify the Time Clock Event
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Time_Clock_Event_ID;
    /**
     * The Delete_Time_Clock_Event
     * Meta informations extracted from the WSDL
     * - documentation: Flag to indicate whether the Time Clock Event should be deleted
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete_Time_Clock_Event;
    /**
     * The Employee_ID
     * Meta informations extracted from the WSDL
     * - documentation: Employee associated with the time clock event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Employee_ID;
    /**
     * The Position_ID
     * Meta informations extracted from the WSDL
     * - documentation: Position associated with the time clock event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Position_ID;
    /**
     * The Time_Clock_Event_Date_Time
     * Meta informations extracted from the WSDL
     * - documentation: Date and time of the Time Clock Event. If you do not include a UTC offset, Workday assumes a 0 offset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Time_Clock_Event_Date_Time;
    /**
     * The Time_Entry_Code
     * Meta informations extracted from the WSDL
     * - documentation: Time Entry Code specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Time_Entry_Code;
    /**
     * The Project_ID
     * Meta informations extracted from the WSDL
     * - documentation: Project ID specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_ID;
    /**
     * The Task_ID
     * Meta informations extracted from the WSDL
     * - documentation: Project Task ID specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Task_ID;
    /**
     * The Clock_Event_Type_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Punch Type: In, Break, Meal, or Out.
     * - minOccurs: 0
     * @var \StructType\Time_Punch_TypeObjectType
     */
    public $Clock_Event_Type_Reference;
    /**
     * The Override_Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Override Rate specified by worker. | Override Rate used while reporting time. | Override Rate for the Ad Hoc Schedule Event.
     * - fractionDigits: 6
     * - minInclusive: 0
     * - totalDigits: 10
     * @var float
     */
    public $Override_Rate;
    /**
     * The Business_Unit
     * Meta informations extracted from the WSDL
     * - documentation: Business Unit specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Unit;
    /**
     * The Cost_Center
     * Meta informations extracted from the WSDL
     * - documentation: Cost Center specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cost_Center;
    /**
     * The Custom_Organization_01
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 01 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_01;
    /**
     * The Custom_Organization_02
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 02 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_02;
    /**
     * The Custom_Organization_03
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 03 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_03;
    /**
     * The Custom_Organization_04
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 04 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_04;
    /**
     * The Custom_Organization_05
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 05 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_05;
    /**
     * The Custom_Organization_06
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 06 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_06;
    /**
     * The Custom_Organization_07
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 07 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_07;
    /**
     * The Custom_Organization_08
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 08 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_08;
    /**
     * The Custom_Organization_09
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 09 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_09;
    /**
     * The Custom_Organization_10
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 10 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Organization_10;
    /**
     * The Custom_Worktag_01
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 01 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_01;
    /**
     * The Custom_Worktag_02
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 02 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_02;
    /**
     * The Custom_Worktag_03
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 03 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_03;
    /**
     * The Custom_Worktag_04
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 04 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_04;
    /**
     * The Custom_Worktag_05
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 05 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_05;
    /**
     * The Custom_Worktag_06
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 06 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_06;
    /**
     * The Custom_Worktag_07
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 07 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_07;
    /**
     * The Custom_Worktag_08
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 08 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_08;
    /**
     * The Custom_Worktag_09
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 09 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_09;
    /**
     * The Custom_Worktag_10
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 10 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_10;
    /**
     * The Custom_Worktag_11
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 11 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_11;
    /**
     * The Custom_Worktag_12
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 12 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_12;
    /**
     * The Custom_Worktag_13
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 13 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_13;
    /**
     * The Custom_Worktag_14
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 14 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_14;
    /**
     * The Custom_Worktag_15
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 15 specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom_Worktag_15;
    /**
     * The Fund
     * Meta informations extracted from the WSDL
     * - documentation: Fund specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fund;
    /**
     * The Gift
     * Meta informations extracted from the WSDL
     * - documentation: Gift specified by worker
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gift;
    /**
     * The Grant
     * Meta informations extracted from the WSDL
     * - documentation: Grant specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Grant;
    /**
     * The Job_Profile
     * Meta informations extracted from the WSDL
     * - documentation: Job Profile specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Profile;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - documentation: Location specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location;
    /**
     * The Program
     * Meta informations extracted from the WSDL
     * - documentation: Program specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Program;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - documentation: Region specified by worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Comment added to time clock event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Time_Clock_Event_DataType
     * @uses Time_Clock_Event_DataType::setTime_Clock_Event_ID()
     * @uses Time_Clock_Event_DataType::setDelete_Time_Clock_Event()
     * @uses Time_Clock_Event_DataType::setEmployee_ID()
     * @uses Time_Clock_Event_DataType::setPosition_ID()
     * @uses Time_Clock_Event_DataType::setTime_Clock_Event_Date_Time()
     * @uses Time_Clock_Event_DataType::setTime_Entry_Code()
     * @uses Time_Clock_Event_DataType::setProject_ID()
     * @uses Time_Clock_Event_DataType::setTask_ID()
     * @uses Time_Clock_Event_DataType::setClock_Event_Type_Reference()
     * @uses Time_Clock_Event_DataType::setOverride_Rate()
     * @uses Time_Clock_Event_DataType::setBusiness_Unit()
     * @uses Time_Clock_Event_DataType::setCost_Center()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_01()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_02()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_03()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_04()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_05()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_06()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_07()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_08()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_09()
     * @uses Time_Clock_Event_DataType::setCustom_Organization_10()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_01()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_02()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_03()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_04()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_05()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_06()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_07()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_08()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_09()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_10()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_11()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_12()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_13()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_14()
     * @uses Time_Clock_Event_DataType::setCustom_Worktag_15()
     * @uses Time_Clock_Event_DataType::setFund()
     * @uses Time_Clock_Event_DataType::setGift()
     * @uses Time_Clock_Event_DataType::setGrant()
     * @uses Time_Clock_Event_DataType::setJob_Profile()
     * @uses Time_Clock_Event_DataType::setLocation()
     * @uses Time_Clock_Event_DataType::setProgram()
     * @uses Time_Clock_Event_DataType::setRegion()
     * @uses Time_Clock_Event_DataType::setComment()
     * @param string $time_Clock_Event_ID
     * @param bool $delete_Time_Clock_Event
     * @param string $employee_ID
     * @param string $position_ID
     * @param string $time_Clock_Event_Date_Time
     * @param string $time_Entry_Code
     * @param string $project_ID
     * @param string $task_ID
     * @param \StructType\Time_Punch_TypeObjectType $clock_Event_Type_Reference
     * @param float $override_Rate
     * @param string $business_Unit
     * @param string $cost_Center
     * @param string $custom_Organization_01
     * @param string $custom_Organization_02
     * @param string $custom_Organization_03
     * @param string $custom_Organization_04
     * @param string $custom_Organization_05
     * @param string $custom_Organization_06
     * @param string $custom_Organization_07
     * @param string $custom_Organization_08
     * @param string $custom_Organization_09
     * @param string $custom_Organization_10
     * @param string $custom_Worktag_01
     * @param string $custom_Worktag_02
     * @param string $custom_Worktag_03
     * @param string $custom_Worktag_04
     * @param string $custom_Worktag_05
     * @param string $custom_Worktag_06
     * @param string $custom_Worktag_07
     * @param string $custom_Worktag_08
     * @param string $custom_Worktag_09
     * @param string $custom_Worktag_10
     * @param string $custom_Worktag_11
     * @param string $custom_Worktag_12
     * @param string $custom_Worktag_13
     * @param string $custom_Worktag_14
     * @param string $custom_Worktag_15
     * @param string $fund
     * @param string $gift
     * @param string $grant
     * @param string $job_Profile
     * @param string $location
     * @param string $program
     * @param string $region
     * @param string $comment
     */
    public function __construct($time_Clock_Event_ID = null, $delete_Time_Clock_Event = null, $employee_ID = null, $position_ID = null, $time_Clock_Event_Date_Time = null, $time_Entry_Code = null, $project_ID = null, $task_ID = null, \StructType\Time_Punch_TypeObjectType $clock_Event_Type_Reference = null, $override_Rate = null, $business_Unit = null, $cost_Center = null, $custom_Organization_01 = null, $custom_Organization_02 = null, $custom_Organization_03 = null, $custom_Organization_04 = null, $custom_Organization_05 = null, $custom_Organization_06 = null, $custom_Organization_07 = null, $custom_Organization_08 = null, $custom_Organization_09 = null, $custom_Organization_10 = null, $custom_Worktag_01 = null, $custom_Worktag_02 = null, $custom_Worktag_03 = null, $custom_Worktag_04 = null, $custom_Worktag_05 = null, $custom_Worktag_06 = null, $custom_Worktag_07 = null, $custom_Worktag_08 = null, $custom_Worktag_09 = null, $custom_Worktag_10 = null, $custom_Worktag_11 = null, $custom_Worktag_12 = null, $custom_Worktag_13 = null, $custom_Worktag_14 = null, $custom_Worktag_15 = null, $fund = null, $gift = null, $grant = null, $job_Profile = null, $location = null, $program = null, $region = null, $comment = null)
    {
        $this
            ->setTime_Clock_Event_ID($time_Clock_Event_ID)
            ->setDelete_Time_Clock_Event($delete_Time_Clock_Event)
            ->setEmployee_ID($employee_ID)
            ->setPosition_ID($position_ID)
            ->setTime_Clock_Event_Date_Time($time_Clock_Event_Date_Time)
            ->setTime_Entry_Code($time_Entry_Code)
            ->setProject_ID($project_ID)
            ->setTask_ID($task_ID)
            ->setClock_Event_Type_Reference($clock_Event_Type_Reference)
            ->setOverride_Rate($override_Rate)
            ->setBusiness_Unit($business_Unit)
            ->setCost_Center($cost_Center)
            ->setCustom_Organization_01($custom_Organization_01)
            ->setCustom_Organization_02($custom_Organization_02)
            ->setCustom_Organization_03($custom_Organization_03)
            ->setCustom_Organization_04($custom_Organization_04)
            ->setCustom_Organization_05($custom_Organization_05)
            ->setCustom_Organization_06($custom_Organization_06)
            ->setCustom_Organization_07($custom_Organization_07)
            ->setCustom_Organization_08($custom_Organization_08)
            ->setCustom_Organization_09($custom_Organization_09)
            ->setCustom_Organization_10($custom_Organization_10)
            ->setCustom_Worktag_01($custom_Worktag_01)
            ->setCustom_Worktag_02($custom_Worktag_02)
            ->setCustom_Worktag_03($custom_Worktag_03)
            ->setCustom_Worktag_04($custom_Worktag_04)
            ->setCustom_Worktag_05($custom_Worktag_05)
            ->setCustom_Worktag_06($custom_Worktag_06)
            ->setCustom_Worktag_07($custom_Worktag_07)
            ->setCustom_Worktag_08($custom_Worktag_08)
            ->setCustom_Worktag_09($custom_Worktag_09)
            ->setCustom_Worktag_10($custom_Worktag_10)
            ->setCustom_Worktag_11($custom_Worktag_11)
            ->setCustom_Worktag_12($custom_Worktag_12)
            ->setCustom_Worktag_13($custom_Worktag_13)
            ->setCustom_Worktag_14($custom_Worktag_14)
            ->setCustom_Worktag_15($custom_Worktag_15)
            ->setFund($fund)
            ->setGift($gift)
            ->setGrant($grant)
            ->setJob_Profile($job_Profile)
            ->setLocation($location)
            ->setProgram($program)
            ->setRegion($region)
            ->setComment($comment);
    }
    /**
     * Get Time_Clock_Event_ID value
     * @return string|null
     */
    public function getTime_Clock_Event_ID()
    {
        return $this->Time_Clock_Event_ID;
    }
    /**
     * Set Time_Clock_Event_ID value
     * @param string $time_Clock_Event_ID
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setTime_Clock_Event_ID($time_Clock_Event_ID = null)
    {
        // validation for constraint: string
        if (!is_null($time_Clock_Event_ID) && !is_string($time_Clock_Event_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_Clock_Event_ID)), __LINE__);
        }
        $this->Time_Clock_Event_ID = $time_Clock_Event_ID;
        return $this;
    }
    /**
     * Get Delete_Time_Clock_Event value
     * @return bool|null
     */
    public function getDelete_Time_Clock_Event()
    {
        return $this->Delete_Time_Clock_Event;
    }
    /**
     * Set Delete_Time_Clock_Event value
     * @param bool $delete_Time_Clock_Event
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setDelete_Time_Clock_Event($delete_Time_Clock_Event = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete_Time_Clock_Event) && !is_bool($delete_Time_Clock_Event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($delete_Time_Clock_Event)), __LINE__);
        }
        $this->Delete_Time_Clock_Event = $delete_Time_Clock_Event;
        return $this;
    }
    /**
     * Get Employee_ID value
     * @return string|null
     */
    public function getEmployee_ID()
    {
        return $this->Employee_ID;
    }
    /**
     * Set Employee_ID value
     * @param string $employee_ID
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setEmployee_ID($employee_ID = null)
    {
        // validation for constraint: string
        if (!is_null($employee_ID) && !is_string($employee_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($employee_ID)), __LINE__);
        }
        $this->Employee_ID = $employee_ID;
        return $this;
    }
    /**
     * Get Position_ID value
     * @return string|null
     */
    public function getPosition_ID()
    {
        return $this->Position_ID;
    }
    /**
     * Set Position_ID value
     * @param string $position_ID
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setPosition_ID($position_ID = null)
    {
        // validation for constraint: string
        if (!is_null($position_ID) && !is_string($position_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position_ID)), __LINE__);
        }
        $this->Position_ID = $position_ID;
        return $this;
    }
    /**
     * Get Time_Clock_Event_Date_Time value
     * @return string|null
     */
    public function getTime_Clock_Event_Date_Time()
    {
        return $this->Time_Clock_Event_Date_Time;
    }
    /**
     * Set Time_Clock_Event_Date_Time value
     * @param string $time_Clock_Event_Date_Time
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setTime_Clock_Event_Date_Time($time_Clock_Event_Date_Time = null)
    {
        // validation for constraint: string
        if (!is_null($time_Clock_Event_Date_Time) && !is_string($time_Clock_Event_Date_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_Clock_Event_Date_Time)), __LINE__);
        }
        $this->Time_Clock_Event_Date_Time = $time_Clock_Event_Date_Time;
        return $this;
    }
    /**
     * Get Time_Entry_Code value
     * @return string|null
     */
    public function getTime_Entry_Code()
    {
        return $this->Time_Entry_Code;
    }
    /**
     * Set Time_Entry_Code value
     * @param string $time_Entry_Code
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setTime_Entry_Code($time_Entry_Code = null)
    {
        // validation for constraint: string
        if (!is_null($time_Entry_Code) && !is_string($time_Entry_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_Entry_Code)), __LINE__);
        }
        $this->Time_Entry_Code = $time_Entry_Code;
        return $this;
    }
    /**
     * Get Project_ID value
     * @return string|null
     */
    public function getProject_ID()
    {
        return $this->Project_ID;
    }
    /**
     * Set Project_ID value
     * @param string $project_ID
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setProject_ID($project_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_ID) && !is_string($project_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($project_ID)), __LINE__);
        }
        $this->Project_ID = $project_ID;
        return $this;
    }
    /**
     * Get Task_ID value
     * @return string|null
     */
    public function getTask_ID()
    {
        return $this->Task_ID;
    }
    /**
     * Set Task_ID value
     * @param string $task_ID
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setTask_ID($task_ID = null)
    {
        // validation for constraint: string
        if (!is_null($task_ID) && !is_string($task_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($task_ID)), __LINE__);
        }
        $this->Task_ID = $task_ID;
        return $this;
    }
    /**
     * Get Clock_Event_Type_Reference value
     * @return \StructType\Time_Punch_TypeObjectType|null
     */
    public function getClock_Event_Type_Reference()
    {
        return $this->Clock_Event_Type_Reference;
    }
    /**
     * Set Clock_Event_Type_Reference value
     * @param \StructType\Time_Punch_TypeObjectType $clock_Event_Type_Reference
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setClock_Event_Type_Reference(\StructType\Time_Punch_TypeObjectType $clock_Event_Type_Reference = null)
    {
        $this->Clock_Event_Type_Reference = $clock_Event_Type_Reference;
        return $this;
    }
    /**
     * Get Override_Rate value
     * @return float|null
     */
    public function getOverride_Rate()
    {
        return $this->Override_Rate;
    }
    /**
     * Set Override_Rate value
     * @param float $override_Rate
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setOverride_Rate($override_Rate = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($override_Rate) && strlen(substr($override_Rate, strpos($override_Rate, '.') + 1)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 fraction digits, "%d" given', strlen(substr($override_Rate, strpos($override_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($override_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $override_Rate), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($override_Rate) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $override_Rate)) !== 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 10 digits, "%d" given', strlen(substr($override_Rate, strpos($override_Rate, '.')))), __LINE__);
        }
        $this->Override_Rate = $override_Rate;
        return $this;
    }
    /**
     * Get Business_Unit value
     * @return string|null
     */
    public function getBusiness_Unit()
    {
        return $this->Business_Unit;
    }
    /**
     * Set Business_Unit value
     * @param string $business_Unit
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setBusiness_Unit($business_Unit = null)
    {
        // validation for constraint: string
        if (!is_null($business_Unit) && !is_string($business_Unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($business_Unit)), __LINE__);
        }
        $this->Business_Unit = $business_Unit;
        return $this;
    }
    /**
     * Get Cost_Center value
     * @return string|null
     */
    public function getCost_Center()
    {
        return $this->Cost_Center;
    }
    /**
     * Set Cost_Center value
     * @param string $cost_Center
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCost_Center($cost_Center = null)
    {
        // validation for constraint: string
        if (!is_null($cost_Center) && !is_string($cost_Center)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cost_Center)), __LINE__);
        }
        $this->Cost_Center = $cost_Center;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_01()
    {
        return $this->Custom_Organization_01;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_01($custom_Organization_01 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_01) && !is_string($custom_Organization_01)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_01)), __LINE__);
        }
        $this->Custom_Organization_01 = $custom_Organization_01;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_02()
    {
        return $this->Custom_Organization_02;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_02($custom_Organization_02 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_02) && !is_string($custom_Organization_02)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_02)), __LINE__);
        }
        $this->Custom_Organization_02 = $custom_Organization_02;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_03()
    {
        return $this->Custom_Organization_03;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_03($custom_Organization_03 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_03) && !is_string($custom_Organization_03)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_03)), __LINE__);
        }
        $this->Custom_Organization_03 = $custom_Organization_03;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_04()
    {
        return $this->Custom_Organization_04;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_04($custom_Organization_04 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_04) && !is_string($custom_Organization_04)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_04)), __LINE__);
        }
        $this->Custom_Organization_04 = $custom_Organization_04;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_05()
    {
        return $this->Custom_Organization_05;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_05($custom_Organization_05 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_05) && !is_string($custom_Organization_05)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_05)), __LINE__);
        }
        $this->Custom_Organization_05 = $custom_Organization_05;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_06()
    {
        return $this->Custom_Organization_06;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_06($custom_Organization_06 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_06) && !is_string($custom_Organization_06)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_06)), __LINE__);
        }
        $this->Custom_Organization_06 = $custom_Organization_06;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_07()
    {
        return $this->Custom_Organization_07;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_07($custom_Organization_07 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_07) && !is_string($custom_Organization_07)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_07)), __LINE__);
        }
        $this->Custom_Organization_07 = $custom_Organization_07;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_08()
    {
        return $this->Custom_Organization_08;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_08($custom_Organization_08 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_08) && !is_string($custom_Organization_08)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_08)), __LINE__);
        }
        $this->Custom_Organization_08 = $custom_Organization_08;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_09()
    {
        return $this->Custom_Organization_09;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_09($custom_Organization_09 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_09) && !is_string($custom_Organization_09)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_09)), __LINE__);
        }
        $this->Custom_Organization_09 = $custom_Organization_09;
        return $this;
    }
    /**
     * Get custom_Organization value
     * @return custom_Organization
     */
    public function getCustom_Organization_10()
    {
        return $this->Custom_Organization_10;
    }
    /**
     * Set custom_Organization value
     * @param custom_Organization $custom_Organization
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Organization_10($custom_Organization_10 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Organization_10) && !is_string($custom_Organization_10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Organization_10)), __LINE__);
        }
        $this->Custom_Organization_10 = $custom_Organization_10;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_01()
    {
        return $this->Custom_Worktag_01;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_01($custom_Worktag_01 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_01) && !is_string($custom_Worktag_01)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_01)), __LINE__);
        }
        $this->Custom_Worktag_01 = $custom_Worktag_01;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_02()
    {
        return $this->Custom_Worktag_02;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_02($custom_Worktag_02 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_02) && !is_string($custom_Worktag_02)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_02)), __LINE__);
        }
        $this->Custom_Worktag_02 = $custom_Worktag_02;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_03()
    {
        return $this->Custom_Worktag_03;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_03($custom_Worktag_03 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_03) && !is_string($custom_Worktag_03)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_03)), __LINE__);
        }
        $this->Custom_Worktag_03 = $custom_Worktag_03;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_04()
    {
        return $this->Custom_Worktag_04;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_04($custom_Worktag_04 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_04) && !is_string($custom_Worktag_04)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_04)), __LINE__);
        }
        $this->Custom_Worktag_04 = $custom_Worktag_04;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_05()
    {
        return $this->Custom_Worktag_05;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_05($custom_Worktag_05 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_05) && !is_string($custom_Worktag_05)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_05)), __LINE__);
        }
        $this->Custom_Worktag_05 = $custom_Worktag_05;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_06()
    {
        return $this->Custom_Worktag_06;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_06($custom_Worktag_06 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_06) && !is_string($custom_Worktag_06)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_06)), __LINE__);
        }
        $this->Custom_Worktag_06 = $custom_Worktag_06;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_07()
    {
        return $this->Custom_Worktag_07;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_07($custom_Worktag_07 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_07) && !is_string($custom_Worktag_07)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_07)), __LINE__);
        }
        $this->Custom_Worktag_07 = $custom_Worktag_07;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_08()
    {
        return $this->Custom_Worktag_08;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_08($custom_Worktag_08 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_08) && !is_string($custom_Worktag_08)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_08)), __LINE__);
        }
        $this->Custom_Worktag_08 = $custom_Worktag_08;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_09()
    {
        return $this->Custom_Worktag_09;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_09($custom_Worktag_09 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_09) && !is_string($custom_Worktag_09)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_09)), __LINE__);
        }
        $this->Custom_Worktag_09 = $custom_Worktag_09;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_10()
    {
        return $this->Custom_Worktag_10;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_10($custom_Worktag_10 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_10) && !is_string($custom_Worktag_10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_10)), __LINE__);
        }
        $this->Custom_Worktag_10 = $custom_Worktag_10;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_11()
    {
        return $this->Custom_Worktag_11;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_11($custom_Worktag_11 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_11) && !is_string($custom_Worktag_11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_11)), __LINE__);
        }
        $this->Custom_Worktag_11 = $custom_Worktag_11;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_12()
    {
        return $this->Custom_Worktag_12;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_12($custom_Worktag_12 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_12) && !is_string($custom_Worktag_12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_12)), __LINE__);
        }
        $this->Custom_Worktag_12 = $custom_Worktag_12;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_13()
    {
        return $this->Custom_Worktag_13;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_13($custom_Worktag_13 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_13) && !is_string($custom_Worktag_13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_13)), __LINE__);
        }
        $this->Custom_Worktag_13 = $custom_Worktag_13;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_14()
    {
        return $this->Custom_Worktag_14;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_14($custom_Worktag_14 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_14) && !is_string($custom_Worktag_14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_14)), __LINE__);
        }
        $this->Custom_Worktag_14 = $custom_Worktag_14;
        return $this;
    }
    /**
     * Get custom_Worktag value
     * @return custom_Worktag
     */
    public function getCustom_Worktag_15()
    {
        return $this->Custom_Worktag_15;
    }
    /**
     * Set custom_Worktag value
     * @param custom_Worktag $custom_Worktag
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setCustom_Worktag_15($custom_Worktag_15 = null)
    {
        // validation for constraint: string
        if (!is_null($custom_Worktag_15) && !is_string($custom_Worktag_15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom_Worktag_15)), __LINE__);
        }
        $this->Custom_Worktag_15 = $custom_Worktag_15;
        return $this;
    }
    /**
     * Get Fund value
     * @return string|null
     */
    public function getFund()
    {
        return $this->Fund;
    }
    /**
     * Set Fund value
     * @param string $fund
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setFund($fund = null)
    {
        // validation for constraint: string
        if (!is_null($fund) && !is_string($fund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fund)), __LINE__);
        }
        $this->Fund = $fund;
        return $this;
    }
    /**
     * Get Gift value
     * @return string|null
     */
    public function getGift()
    {
        return $this->Gift;
    }
    /**
     * Set Gift value
     * @param string $gift
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setGift($gift = null)
    {
        // validation for constraint: string
        if (!is_null($gift) && !is_string($gift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift)), __LINE__);
        }
        $this->Gift = $gift;
        return $this;
    }
    /**
     * Get Grant value
     * @return string|null
     */
    public function getGrant()
    {
        return $this->Grant;
    }
    /**
     * Set Grant value
     * @param string $grant
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setGrant($grant = null)
    {
        // validation for constraint: string
        if (!is_null($grant) && !is_string($grant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grant)), __LINE__);
        }
        $this->Grant = $grant;
        return $this;
    }
    /**
     * Get Job_Profile value
     * @return string|null
     */
    public function getJob_Profile()
    {
        return $this->Job_Profile;
    }
    /**
     * Set Job_Profile value
     * @param string $job_Profile
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setJob_Profile($job_Profile = null)
    {
        // validation for constraint: string
        if (!is_null($job_Profile) && !is_string($job_Profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($job_Profile)), __LINE__);
        }
        $this->Job_Profile = $job_Profile;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Program value
     * @return string|null
     */
    public function getProgram()
    {
        return $this->Program;
    }
    /**
     * Set Program value
     * @param string $program
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setProgram($program = null)
    {
        // validation for constraint: string
        if (!is_null($program) && !is_string($program)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($program)), __LINE__);
        }
        $this->Program = $program;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Time_Clock_Event_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Time_Clock_Event_DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
