<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstanceObjectType StructType
 * @subpackage Structs
 */
class InstanceObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Instance_IDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for InstanceObjectType
     * @uses InstanceObjectType::setID()
     * @uses InstanceObjectType::setDescriptor()
     * @param \StructType\Instance_IDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Instance_IDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Instance_IDType[] $iD
     * @return \StructType\InstanceObjectType
     */
    public function setID(array $iD = array())
    {
        foreach ($iD as $instanceObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$instanceObjectTypeIDItem instanceof \StructType\Instance_IDType) {
                throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Instance_IDType, "%s" given', is_object($instanceObjectTypeIDItem) ? get_class($instanceObjectTypeIDItem) : gettype($instanceObjectTypeIDItem)), __LINE__);
            }
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Instance_IDType $item
     * @return \StructType\InstanceObjectType
     */
    public function addToID(\StructType\Instance_IDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Instance_IDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Instance_IDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\InstanceObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InstanceObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
