<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Custom_Worktag_07ObjectType StructType
 * @subpackage Structs
 */
class Custom_Worktag_07ObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_07ObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta informations extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Custom_Worktag_07ObjectType
     * @uses Custom_Worktag_07ObjectType::setID()
     * @uses Custom_Worktag_07ObjectType::setDescriptor()
     * @param \StructType\Custom_Worktag_07ObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Custom_Worktag_07ObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Worktag_07ObjectIDType[] $iD
     * @return \StructType\Custom_Worktag_07ObjectType
     */
    public function setID(array $iD = array())
    {
        foreach ($iD as $custom_Worktag_07ObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$custom_Worktag_07ObjectTypeIDItem instanceof \StructType\Custom_Worktag_07ObjectIDType) {
                throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Custom_Worktag_07ObjectIDType, "%s" given', is_object($custom_Worktag_07ObjectTypeIDItem) ? get_class($custom_Worktag_07ObjectTypeIDItem) : gettype($custom_Worktag_07ObjectTypeIDItem)), __LINE__);
            }
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Worktag_07ObjectIDType $item
     * @return \StructType\Custom_Worktag_07ObjectType
     */
    public function addToID(\StructType\Custom_Worktag_07ObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom_Worktag_07ObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of \StructType\Custom_Worktag_07ObjectIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Custom_Worktag_07ObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Custom_Worktag_07ObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
