<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Calculated_Time_Block_Request_ReferencesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Time Block Request References
 * @subpackage Structs
 */
class Calculated_Time_Block_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Worker_Time_Block_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Workday ID(s) for associated calculated time blocks
     * - maxOccurs: unbounded
     * @var \StructType\Worker_Time_BlockObjectType[]
     */
    public $Worker_Time_Block_Reference;
    /**
     * Constructor method for Calculated_Time_Block_Request_ReferencesType
     * @uses Calculated_Time_Block_Request_ReferencesType::setWorker_Time_Block_Reference()
     * @param \StructType\Worker_Time_BlockObjectType[] $worker_Time_Block_Reference
     */
    public function __construct(array $worker_Time_Block_Reference = array())
    {
        $this
            ->setWorker_Time_Block_Reference($worker_Time_Block_Reference);
    }
    /**
     * Get Worker_Time_Block_Reference value
     * @return \StructType\Worker_Time_BlockObjectType[]|null
     */
    public function getWorker_Time_Block_Reference()
    {
        return $this->Worker_Time_Block_Reference;
    }
    /**
     * Set Worker_Time_Block_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Time_BlockObjectType[] $worker_Time_Block_Reference
     * @return \StructType\Calculated_Time_Block_Request_ReferencesType
     */
    public function setWorker_Time_Block_Reference(array $worker_Time_Block_Reference = array())
    {
        foreach ($worker_Time_Block_Reference as $calculated_Time_Block_Request_ReferencesTypeWorker_Time_Block_ReferenceItem) {
            // validation for constraint: itemType
            if (!$calculated_Time_Block_Request_ReferencesTypeWorker_Time_Block_ReferenceItem instanceof \StructType\Worker_Time_BlockObjectType) {
                throw new \InvalidArgumentException(sprintf('The Worker_Time_Block_Reference property can only contain items of \StructType\Worker_Time_BlockObjectType, "%s" given', is_object($calculated_Time_Block_Request_ReferencesTypeWorker_Time_Block_ReferenceItem) ? get_class($calculated_Time_Block_Request_ReferencesTypeWorker_Time_Block_ReferenceItem) : gettype($calculated_Time_Block_Request_ReferencesTypeWorker_Time_Block_ReferenceItem)), __LINE__);
            }
        }
        $this->Worker_Time_Block_Reference = $worker_Time_Block_Reference;
        return $this;
    }
    /**
     * Add item to Worker_Time_Block_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Time_BlockObjectType $item
     * @return \StructType\Calculated_Time_Block_Request_ReferencesType
     */
    public function addToWorker_Time_Block_Reference(\StructType\Worker_Time_BlockObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worker_Time_BlockObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Time_Block_Reference property can only contain items of \StructType\Worker_Time_BlockObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Worker_Time_Block_Reference[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Calculated_Time_Block_Request_ReferencesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
