<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Calculated_Time_Block_Request_CriteriaType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Time Block Request Criteria | The End Date must be on or after the Start Date.
 * @subpackage Structs
 */
class Calculated_Time_Block_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Start_Date
     * Meta informations extracted from the WSDL
     * - documentation: Start Date of date range over which calculated time blocks will be retrieved
     * - maxOccurs: 1
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta informations extracted from the WSDL
     * - documentation: End Date of date range over which calculated time blocks will be retrieved
     * - maxOccurs: 1
     * @var string
     */
    public $End_Date;
    /**
     * The Worker_Reference
     * Meta informations extracted from the WSDL
     * - documentation: The worker associated with the calculated time blocks.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Worker_Reference;
    /**
     * The Supervisory_Organization_Reference
     * Meta informations extracted from the WSDL
     * - documentation: The supervisory organizations associated with the calculated time blocks.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType[]
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Calculation_Tag_Reference
     * Meta informations extracted from the WSDL
     * - documentation: The calculation tag associated with the calculated time blocks.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Time_Calculation_TagObjectType[]
     */
    public $Calculation_Tag_Reference;
    /**
     * The Status_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Worker Time Block Status
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Time_Tracking_Set_Up_OptionObjectType[]
     */
    public $Status_Reference;
    /**
     * Constructor method for Calculated_Time_Block_Request_CriteriaType
     * @uses Calculated_Time_Block_Request_CriteriaType::setStart_Date()
     * @uses Calculated_Time_Block_Request_CriteriaType::setEnd_Date()
     * @uses Calculated_Time_Block_Request_CriteriaType::setWorker_Reference()
     * @uses Calculated_Time_Block_Request_CriteriaType::setSupervisory_Organization_Reference()
     * @uses Calculated_Time_Block_Request_CriteriaType::setCalculation_Tag_Reference()
     * @uses Calculated_Time_Block_Request_CriteriaType::setStatus_Reference()
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @param \StructType\Supervisory_OrganizationObjectType[] $supervisory_Organization_Reference
     * @param \StructType\Time_Calculation_TagObjectType[] $calculation_Tag_Reference
     * @param \StructType\Time_Tracking_Set_Up_OptionObjectType[] $status_Reference
     */
    public function __construct($start_Date = null, $end_Date = null, array $worker_Reference = array(), array $supervisory_Organization_Reference = array(), array $calculation_Tag_Reference = array(), array $status_Reference = array())
    {
        $this
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setWorker_Reference($worker_Reference)
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setCalculation_Tag_Reference($calculation_Tag_Reference)
            ->setStatus_Reference($status_Reference);
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function setWorker_Reference(array $worker_Reference = array())
    {
        foreach ($worker_Reference as $calculated_Time_Block_Request_CriteriaTypeWorker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$calculated_Time_Block_Request_CriteriaTypeWorker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                throw new \InvalidArgumentException(sprintf('The Worker_Reference property can only contain items of \StructType\WorkerObjectType, "%s" given', is_object($calculated_Time_Block_Request_CriteriaTypeWorker_ReferenceItem) ? get_class($calculated_Time_Block_Request_CriteriaTypeWorker_ReferenceItem) : gettype($calculated_Time_Block_Request_CriteriaTypeWorker_ReferenceItem)), __LINE__);
            }
        }
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Add item to Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function addToWorker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Reference property can only contain items of \StructType\WorkerObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType[]|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType[] $supervisory_Organization_Reference
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function setSupervisory_Organization_Reference(array $supervisory_Organization_Reference = array())
    {
        foreach ($supervisory_Organization_Reference as $calculated_Time_Block_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$calculated_Time_Block_Request_CriteriaTypeSupervisory_Organization_ReferenceItem instanceof \StructType\Supervisory_OrganizationObjectType) {
                throw new \InvalidArgumentException(sprintf('The Supervisory_Organization_Reference property can only contain items of \StructType\Supervisory_OrganizationObjectType, "%s" given', is_object($calculated_Time_Block_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) ? get_class($calculated_Time_Block_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) : gettype($calculated_Time_Block_Request_CriteriaTypeSupervisory_Organization_ReferenceItem)), __LINE__);
            }
        }
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Add item to Supervisory_Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType $item
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function addToSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supervisory_OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supervisory_Organization_Reference property can only contain items of \StructType\Supervisory_OrganizationObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Supervisory_Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Calculation_Tag_Reference value
     * @return \StructType\Time_Calculation_TagObjectType[]|null
     */
    public function getCalculation_Tag_Reference()
    {
        return $this->Calculation_Tag_Reference;
    }
    /**
     * Set Calculation_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Calculation_TagObjectType[] $calculation_Tag_Reference
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function setCalculation_Tag_Reference(array $calculation_Tag_Reference = array())
    {
        foreach ($calculation_Tag_Reference as $calculated_Time_Block_Request_CriteriaTypeCalculation_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$calculated_Time_Block_Request_CriteriaTypeCalculation_Tag_ReferenceItem instanceof \StructType\Time_Calculation_TagObjectType) {
                throw new \InvalidArgumentException(sprintf('The Calculation_Tag_Reference property can only contain items of \StructType\Time_Calculation_TagObjectType, "%s" given', is_object($calculated_Time_Block_Request_CriteriaTypeCalculation_Tag_ReferenceItem) ? get_class($calculated_Time_Block_Request_CriteriaTypeCalculation_Tag_ReferenceItem) : gettype($calculated_Time_Block_Request_CriteriaTypeCalculation_Tag_ReferenceItem)), __LINE__);
            }
        }
        $this->Calculation_Tag_Reference = $calculation_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Calculation_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Calculation_TagObjectType $item
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function addToCalculation_Tag_Reference(\StructType\Time_Calculation_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Time_Calculation_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Calculation_Tag_Reference property can only contain items of \StructType\Time_Calculation_TagObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Calculation_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Time_Tracking_Set_Up_OptionObjectType[]|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * Set Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Tracking_Set_Up_OptionObjectType[] $status_Reference
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function setStatus_Reference(array $status_Reference = array())
    {
        foreach ($status_Reference as $calculated_Time_Block_Request_CriteriaTypeStatus_ReferenceItem) {
            // validation for constraint: itemType
            if (!$calculated_Time_Block_Request_CriteriaTypeStatus_ReferenceItem instanceof \StructType\Time_Tracking_Set_Up_OptionObjectType) {
                throw new \InvalidArgumentException(sprintf('The Status_Reference property can only contain items of \StructType\Time_Tracking_Set_Up_OptionObjectType, "%s" given', is_object($calculated_Time_Block_Request_CriteriaTypeStatus_ReferenceItem) ? get_class($calculated_Time_Block_Request_CriteriaTypeStatus_ReferenceItem) : gettype($calculated_Time_Block_Request_CriteriaTypeStatus_ReferenceItem)), __LINE__);
            }
        }
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Add item to Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Tracking_Set_Up_OptionObjectType $item
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public function addToStatus_Reference(\StructType\Time_Tracking_Set_Up_OptionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Time_Tracking_Set_Up_OptionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Status_Reference property can only contain items of \StructType\Time_Tracking_Set_Up_OptionObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Status_Reference[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
