<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Work_Schedule_ResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response element from importing a work schedule calendar assignment.
 * @subpackage Structs
 */
class Assign_Work_Schedule_ResponseType extends AbstractStructBase
{
    /**
     * The Work_Schedule_Assignment_Event_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Assigned work schedule calendar event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Work_Schedule_Assignment_Event_Reference;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Assign_Work_Schedule_ResponseType
     * @uses Assign_Work_Schedule_ResponseType::setWork_Schedule_Assignment_Event_Reference()
     * @uses Assign_Work_Schedule_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType[] $work_Schedule_Assignment_Event_Reference
     * @param string $version
     */
    public function __construct(array $work_Schedule_Assignment_Event_Reference = array(), $version = null)
    {
        $this
            ->setWork_Schedule_Assignment_Event_Reference($work_Schedule_Assignment_Event_Reference)
            ->setVersion($version);
    }
    /**
     * Get Work_Schedule_Assignment_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getWork_Schedule_Assignment_Event_Reference()
    {
        return $this->Work_Schedule_Assignment_Event_Reference;
    }
    /**
     * Set Work_Schedule_Assignment_Event_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $work_Schedule_Assignment_Event_Reference
     * @return \StructType\Assign_Work_Schedule_ResponseType
     */
    public function setWork_Schedule_Assignment_Event_Reference(array $work_Schedule_Assignment_Event_Reference = array())
    {
        foreach ($work_Schedule_Assignment_Event_Reference as $assign_Work_Schedule_ResponseTypeWork_Schedule_Assignment_Event_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Work_Schedule_ResponseTypeWork_Schedule_Assignment_Event_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                throw new \InvalidArgumentException(sprintf('The Work_Schedule_Assignment_Event_Reference property can only contain items of \StructType\Unique_IdentifierObjectType, "%s" given', is_object($assign_Work_Schedule_ResponseTypeWork_Schedule_Assignment_Event_ReferenceItem) ? get_class($assign_Work_Schedule_ResponseTypeWork_Schedule_Assignment_Event_ReferenceItem) : gettype($assign_Work_Schedule_ResponseTypeWork_Schedule_Assignment_Event_ReferenceItem)), __LINE__);
            }
        }
        $this->Work_Schedule_Assignment_Event_Reference = $work_Schedule_Assignment_Event_Reference;
        return $this;
    }
    /**
     * Add item to Work_Schedule_Assignment_Event_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Assign_Work_Schedule_ResponseType
     */
    public function addToWork_Schedule_Assignment_Event_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Work_Schedule_Assignment_Event_Reference property can only contain items of \StructType\Unique_IdentifierObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Work_Schedule_Assignment_Event_Reference[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Assign_Work_Schedule_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Assign_Work_Schedule_ResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
