<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ad_Hoc_Schedule_Event_Meal_DataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Data related to the meal(s) to be processed.
 * @subpackage Structs
 */
class Ad_Hoc_Schedule_Event_Meal_DataType extends AbstractStructBase
{
    /**
     * The Meal_ID
     * Meta informations extracted from the WSDL
     * - documentation: Reference ID for the meal instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Meal_ID;
    /**
     * The Meal_In
     * Meta informations extracted from the WSDL
     * - documentation: Start time of the meal. If you do not include a UTC offset, Workday assumes a 0 offset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Meal_In;
    /**
     * The Meal_Out
     * Meta informations extracted from the WSDL
     * - documentation: Start time of the meal. If you do not include a UTC offset, Workday assumes a 0 offset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Meal_Out;
    /**
     * Constructor method for Ad_Hoc_Schedule_Event_Meal_DataType
     * @uses Ad_Hoc_Schedule_Event_Meal_DataType::setMeal_ID()
     * @uses Ad_Hoc_Schedule_Event_Meal_DataType::setMeal_In()
     * @uses Ad_Hoc_Schedule_Event_Meal_DataType::setMeal_Out()
     * @param string $meal_ID
     * @param string $meal_In
     * @param string $meal_Out
     */
    public function __construct($meal_ID = null, $meal_In = null, $meal_Out = null)
    {
        $this
            ->setMeal_ID($meal_ID)
            ->setMeal_In($meal_In)
            ->setMeal_Out($meal_Out);
    }
    /**
     * Get Meal_ID value
     * @return string|null
     */
    public function getMeal_ID()
    {
        return $this->Meal_ID;
    }
    /**
     * Set Meal_ID value
     * @param string $meal_ID
     * @return \StructType\Ad_Hoc_Schedule_Event_Meal_DataType
     */
    public function setMeal_ID($meal_ID = null)
    {
        // validation for constraint: string
        if (!is_null($meal_ID) && !is_string($meal_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meal_ID)), __LINE__);
        }
        $this->Meal_ID = $meal_ID;
        return $this;
    }
    /**
     * Get Meal_In value
     * @return string|null
     */
    public function getMeal_In()
    {
        return $this->Meal_In;
    }
    /**
     * Set Meal_In value
     * @param string $meal_In
     * @return \StructType\Ad_Hoc_Schedule_Event_Meal_DataType
     */
    public function setMeal_In($meal_In = null)
    {
        // validation for constraint: string
        if (!is_null($meal_In) && !is_string($meal_In)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meal_In)), __LINE__);
        }
        $this->Meal_In = $meal_In;
        return $this;
    }
    /**
     * Get Meal_Out value
     * @return string|null
     */
    public function getMeal_Out()
    {
        return $this->Meal_Out;
    }
    /**
     * Set Meal_Out value
     * @param string $meal_Out
     * @return \StructType\Ad_Hoc_Schedule_Event_Meal_DataType
     */
    public function setMeal_Out($meal_Out = null)
    {
        // validation for constraint: string
        if (!is_null($meal_Out) && !is_string($meal_Out)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meal_Out)), __LINE__);
        }
        $this->Meal_Out = $meal_Out;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ad_Hoc_Schedule_Event_Meal_DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
