<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response_ResultsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: The "Response_Results" element contains summary information about the data that has been returned from your request including "Total_Results", "Total_Pages", and the current "Page" returned.
 * @subpackage Structs
 */
class Response_ResultsType extends AbstractStructBase
{
    /**
     * The Total_Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: The total number of results that have been returned from your request.
     * - fractionDigits: 0
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Total_Results;
    /**
     * The Total_Pages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: The total number of pages that exist for your request. A page of data in WWS contains a maximum of 100 entries. So, if you have exactly 1,000 employees returned in a request, then you will have 10 pages of data that will need to be
     * retrieved to build your complete dataset.Each page contains a maximum of 100 entries.
     * - fractionDigits: 0
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Total_Pages;
    /**
     * The Page_Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Number of Results in current page.
     * - fractionDigits: 0
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Page_Results;
    /**
     * The Page
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Indicates the page of data to return in the response, and defaults to the first page (Page = 1). For responses that contain more than one page of data, use this parameter to retrieve the additional pages of data. For example, set
     * Page = 2 to retrieve the second page of data.Note: If you set the page parameter, you must also specify the "As_Of_Entry_Date" to ensure that the result set remains the same between your requests. | The page of data that has been returned for the
     * given request.
     * - fractionDigits: 0
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Page;
    /**
     * Constructor method for Response_ResultsType
     * @uses Response_ResultsType::setTotal_Results()
     * @uses Response_ResultsType::setTotal_Pages()
     * @uses Response_ResultsType::setPage_Results()
     * @uses Response_ResultsType::setPage()
     * @param float $total_Results
     * @param float $total_Pages
     * @param float $page_Results
     * @param float $page
     */
    public function __construct($total_Results = null, $total_Pages = null, $page_Results = null, $page = null)
    {
        $this
            ->setTotal_Results($total_Results)
            ->setTotal_Pages($total_Pages)
            ->setPage_Results($page_Results)
            ->setPage($page);
    }
    /**
     * Get Total_Results value
     * @return float|null
     */
    public function getTotal_Results()
    {
        return $this->Total_Results;
    }
    /**
     * Set Total_Results value
     * @param float $total_Results
     * @return \StructType\Response_ResultsType
     */
    public function setTotal_Results($total_Results = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($total_Results) && strlen(substr($total_Results, strpos($total_Results, '.') + 1)) !== 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 0 fraction digits, "%d" given', strlen(substr($total_Results, strpos($total_Results, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($total_Results < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $total_Results), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($total_Results) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $total_Results)) !== 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 12 digits, "%d" given', strlen(substr($total_Results, strpos($total_Results, '.')))), __LINE__);
        }
        $this->Total_Results = $total_Results;
        return $this;
    }
    /**
     * Get Total_Pages value
     * @return float|null
     */
    public function getTotal_Pages()
    {
        return $this->Total_Pages;
    }
    /**
     * Set Total_Pages value
     * @param float $total_Pages
     * @return \StructType\Response_ResultsType
     */
    public function setTotal_Pages($total_Pages = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($total_Pages) && strlen(substr($total_Pages, strpos($total_Pages, '.') + 1)) !== 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 0 fraction digits, "%d" given', strlen(substr($total_Pages, strpos($total_Pages, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($total_Pages < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $total_Pages), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($total_Pages) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $total_Pages)) !== 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 12 digits, "%d" given', strlen(substr($total_Pages, strpos($total_Pages, '.')))), __LINE__);
        }
        $this->Total_Pages = $total_Pages;
        return $this;
    }
    /**
     * Get Page_Results value
     * @return float|null
     */
    public function getPage_Results()
    {
        return $this->Page_Results;
    }
    /**
     * Set Page_Results value
     * @param float $page_Results
     * @return \StructType\Response_ResultsType
     */
    public function setPage_Results($page_Results = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($page_Results) && strlen(substr($page_Results, strpos($page_Results, '.') + 1)) !== 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 0 fraction digits, "%d" given', strlen(substr($page_Results, strpos($page_Results, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($page_Results < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $page_Results), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($page_Results) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $page_Results)) !== 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 12 digits, "%d" given', strlen(substr($page_Results, strpos($page_Results, '.')))), __LINE__);
        }
        $this->Page_Results = $page_Results;
        return $this;
    }
    /**
     * Get Page value
     * @return float|null
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param float $page
     * @return \StructType\Response_ResultsType
     */
    public function setPage($page = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($page) && strlen(substr($page, strpos($page, '.') + 1)) !== 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 0 fraction digits, "%d" given', strlen(substr($page, strpos($page, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($page < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $page), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($page) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $page)) !== 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 12 digits, "%d" given', strlen(substr($page, strpos($page, '.')))), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Response_ResultsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
