<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reported_Time_Block_DataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Data related to the worker time block(s) to be processed.
 * @subpackage Structs
 */
class Reported_Time_Block_DataType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Employee reference associated with the time block.
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Time_Entry_Code_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Time Entry Code used to report time.
     * - minOccurs: 0
     * @var \StructType\Time_Entry_CodeObjectType
     */
    public $Time_Entry_Code_Reference;
    /**
     * The Project_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Project used to report time.
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Project_Task_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Task used to report time.
     * - minOccurs: 0
     * @var \StructType\Project_Plan_TaskObjectType
     */
    public $Project_Task_Reference;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - documentation: Date of hourly time reported.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Quantity (units) reported
     * - fractionDigits: 6
     * - totalDigits: 10
     * @var float
     */
    public $Quantity;
    /**
     * The In_Date_Time
     * Meta informations extracted from the WSDL
     * - documentation: In event Date and Time
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $In_Date_Time;
    /**
     * The Out_Date_Time
     * Meta informations extracted from the WSDL
     * - documentation: Out event Date and Time
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Out_Date_Time;
    /**
     * The Out_Reason_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Out Type (Break, Meal Or Out).
     * - minOccurs: 0
     * @var \StructType\Time_Punch_TypeObjectType
     */
    public $Out_Reason_Reference;
    /**
     * The Position_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Position used to report time
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Position_ElementObjectType[]
     */
    public $Position_Reference;
    /**
     * The Do_Not_Bill
     * Meta informations extracted from the WSDL
     * - documentation: Enter true or false for billable projects. Enter true for non-billable projects. If the time entry is not for a project, enter false or remove the Do Not Bill XML tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Do_Not_Bill;
    /**
     * The Override_Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Override Rate specified by worker. | Override Rate used while reporting time. | Override Rate for the Ad Hoc Schedule Event.
     * - fractionDigits: 6
     * - minInclusive: 0
     * - totalDigits: 10
     * @var float
     */
    public $Override_Rate;
    /**
     * The Business_Unit_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Business Unit used to report time.
     * - minOccurs: 0
     * @var \StructType\Business_UnitObjectType
     */
    public $Business_Unit_Reference;
    /**
     * The Cost_Center_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Cost Center used to report time.
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Cost_Center_Reference;
    /**
     * The Custom_Organization_01_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 01 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_01_Reference;
    /**
     * The Custom_Organization_02_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 02 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_02_Reference;
    /**
     * The Custom_Organization_03_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 03 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_03_Reference;
    /**
     * The Custom_Organization_04_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 04 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_04_Reference;
    /**
     * The Custom_Organization_05_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 05 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_05_Reference;
    /**
     * The Custom_Organization_06_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 06 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_06_Reference;
    /**
     * The Custom_Organization_07_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 07 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_07_Reference;
    /**
     * The Custom_Organization_08_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 08 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_08_Reference;
    /**
     * The Custom_Organization_09_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 09 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_09_Reference;
    /**
     * The Custom_Organization_10_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 10 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_10_Reference;
    /**
     * The Custom_Worktag_01_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 01 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_01ObjectType
     */
    public $Custom_Worktag_01_Reference;
    /**
     * The Custom_Worktag_02_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 02 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_02ObjectType
     */
    public $Custom_Worktag_02_Reference;
    /**
     * The Custom_Worktag_03_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 03 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_03ObjectType
     */
    public $Custom_Worktag_03_Reference;
    /**
     * The Custom_Worktag_04_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 04 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_04ObjectType
     */
    public $Custom_Worktag_04_Reference;
    /**
     * The Custom_Worktag_05_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 05 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_05ObjectType
     */
    public $Custom_Worktag_05_Reference;
    /**
     * The Custom_Worktag_06_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 06 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_06ObjectType
     */
    public $Custom_Worktag_06_Reference;
    /**
     * The Custom_Worktag_07_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 07 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_07ObjectType
     */
    public $Custom_Worktag_07_Reference;
    /**
     * The Custom_Worktag_08_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 08 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_08ObjectType
     */
    public $Custom_Worktag_08_Reference;
    /**
     * The Custom_Worktag_09_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 09 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_09ObjectType
     */
    public $Custom_Worktag_09_Reference;
    /**
     * The Custom_Worktag_10_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 10 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_10ObjectType
     */
    public $Custom_Worktag_10_Reference;
    /**
     * The Custom_Worktag_11_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 11 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_11ObjectType
     */
    public $Custom_Worktag_11_Reference;
    /**
     * The Custom_Worktag_12_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 12 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_12ObjectType
     */
    public $Custom_Worktag_12_Reference;
    /**
     * The Custom_Worktag_13_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 13 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_13ObjectType
     */
    public $Custom_Worktag_13_Reference;
    /**
     * The Custom_Worktag_14_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 14 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_14ObjectType
     */
    public $Custom_Worktag_14_Reference;
    /**
     * The Custom_Worktag_15_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 15 used to report time.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_15ObjectType
     */
    public $Custom_Worktag_15_Reference;
    /**
     * The Fund_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Fund used to report time.
     * - minOccurs: 0
     * @var \StructType\FundObjectType
     */
    public $Fund_Reference;
    /**
     * The Gift_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Gift associated with the Reported Time
     * - minOccurs: 0
     * @var \StructType\GiftObjectType
     */
    public $Gift_Reference;
    /**
     * The Grant_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Grant used to report time.
     * - minOccurs: 0
     * @var \StructType\GrantObjectType
     */
    public $Grant_Reference;
    /**
     * The Job_Profile_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Job Profile used to report time.
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType
     */
    public $Job_Profile_Reference;
    /**
     * The Location_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Location used to report time.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Program_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Program used to report time.
     * - minOccurs: 0
     * @var \StructType\ProgramObjectType
     */
    public $Program_Reference;
    /**
     * The Region_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Region used to report time.
     * - minOccurs: 0
     * @var \StructType\RegionObjectType
     */
    public $Region_Reference;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Comment on Reported Time Block.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Reported_Time_Block_DataType
     * @uses Reported_Time_Block_DataType::setWorker_Reference()
     * @uses Reported_Time_Block_DataType::setTime_Entry_Code_Reference()
     * @uses Reported_Time_Block_DataType::setProject_Reference()
     * @uses Reported_Time_Block_DataType::setProject_Task_Reference()
     * @uses Reported_Time_Block_DataType::setDate()
     * @uses Reported_Time_Block_DataType::setQuantity()
     * @uses Reported_Time_Block_DataType::setIn_Date_Time()
     * @uses Reported_Time_Block_DataType::setOut_Date_Time()
     * @uses Reported_Time_Block_DataType::setOut_Reason_Reference()
     * @uses Reported_Time_Block_DataType::setPosition_Reference()
     * @uses Reported_Time_Block_DataType::setDo_Not_Bill()
     * @uses Reported_Time_Block_DataType::setOverride_Rate()
     * @uses Reported_Time_Block_DataType::setBusiness_Unit_Reference()
     * @uses Reported_Time_Block_DataType::setCost_Center_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_01_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_02_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_03_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_04_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_05_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_06_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_07_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_08_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_09_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Organization_10_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_01_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_02_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_03_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_04_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_05_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_06_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_07_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_08_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_09_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_10_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_11_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_12_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_13_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_14_Reference()
     * @uses Reported_Time_Block_DataType::setCustom_Worktag_15_Reference()
     * @uses Reported_Time_Block_DataType::setFund_Reference()
     * @uses Reported_Time_Block_DataType::setGift_Reference()
     * @uses Reported_Time_Block_DataType::setGrant_Reference()
     * @uses Reported_Time_Block_DataType::setJob_Profile_Reference()
     * @uses Reported_Time_Block_DataType::setLocation_Reference()
     * @uses Reported_Time_Block_DataType::setProgram_Reference()
     * @uses Reported_Time_Block_DataType::setRegion_Reference()
     * @uses Reported_Time_Block_DataType::setComment()
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\Time_Entry_CodeObjectType $time_Entry_Code_Reference
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Project_Plan_TaskObjectType $project_Task_Reference
     * @param string $date
     * @param float $quantity
     * @param string $in_Date_Time
     * @param string $out_Date_Time
     * @param \StructType\Time_Punch_TypeObjectType $out_Reason_Reference
     * @param \StructType\Position_ElementObjectType[] $position_Reference
     * @param bool $do_Not_Bill
     * @param float $override_Rate
     * @param \StructType\Business_UnitObjectType $business_Unit_Reference
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference
     * @param \StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference
     * @param \StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference
     * @param \StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference
     * @param \StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference
     * @param \StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference
     * @param \StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference
     * @param \StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference
     * @param \StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference
     * @param \StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference
     * @param \StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference
     * @param \StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference
     * @param \StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference
     * @param \StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference
     * @param \StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference
     * @param \StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference
     * @param \StructType\FundObjectType $fund_Reference
     * @param \StructType\GiftObjectType $gift_Reference
     * @param \StructType\GrantObjectType $grant_Reference
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @param \StructType\LocationObjectType $location_Reference
     * @param \StructType\ProgramObjectType $program_Reference
     * @param \StructType\RegionObjectType $region_Reference
     * @param string $comment
     */
    public function __construct(\StructType\WorkerObjectType $worker_Reference = null, \StructType\Time_Entry_CodeObjectType $time_Entry_Code_Reference = null, \StructType\ProjectObjectType $project_Reference = null, \StructType\Project_Plan_TaskObjectType $project_Task_Reference = null, $date = null, $quantity = null, $in_Date_Time = null, $out_Date_Time = null, \StructType\Time_Punch_TypeObjectType $out_Reason_Reference = null, array $position_Reference = array(), $do_Not_Bill = null, $override_Rate = null, \StructType\Business_UnitObjectType $business_Unit_Reference = null, \StructType\Cost_CenterObjectType $cost_Center_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference = null, \StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference = null, \StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference = null, \StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference = null, \StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference = null, \StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference = null, \StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference = null, \StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference = null, \StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference = null, \StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference = null, \StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference = null, \StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference = null, \StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference = null, \StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference = null, \StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference = null, \StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference = null, \StructType\FundObjectType $fund_Reference = null, \StructType\GiftObjectType $gift_Reference = null, \StructType\GrantObjectType $grant_Reference = null, \StructType\Job_ProfileObjectType $job_Profile_Reference = null, \StructType\LocationObjectType $location_Reference = null, \StructType\ProgramObjectType $program_Reference = null, \StructType\RegionObjectType $region_Reference = null, $comment = null)
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setTime_Entry_Code_Reference($time_Entry_Code_Reference)
            ->setProject_Reference($project_Reference)
            ->setProject_Task_Reference($project_Task_Reference)
            ->setDate($date)
            ->setQuantity($quantity)
            ->setIn_Date_Time($in_Date_Time)
            ->setOut_Date_Time($out_Date_Time)
            ->setOut_Reason_Reference($out_Reason_Reference)
            ->setPosition_Reference($position_Reference)
            ->setDo_Not_Bill($do_Not_Bill)
            ->setOverride_Rate($override_Rate)
            ->setBusiness_Unit_Reference($business_Unit_Reference)
            ->setCost_Center_Reference($cost_Center_Reference)
            ->setCustom_Organization_01_Reference($custom_Organization_01_Reference)
            ->setCustom_Organization_02_Reference($custom_Organization_02_Reference)
            ->setCustom_Organization_03_Reference($custom_Organization_03_Reference)
            ->setCustom_Organization_04_Reference($custom_Organization_04_Reference)
            ->setCustom_Organization_05_Reference($custom_Organization_05_Reference)
            ->setCustom_Organization_06_Reference($custom_Organization_06_Reference)
            ->setCustom_Organization_07_Reference($custom_Organization_07_Reference)
            ->setCustom_Organization_08_Reference($custom_Organization_08_Reference)
            ->setCustom_Organization_09_Reference($custom_Organization_09_Reference)
            ->setCustom_Organization_10_Reference($custom_Organization_10_Reference)
            ->setCustom_Worktag_01_Reference($custom_Worktag_01_Reference)
            ->setCustom_Worktag_02_Reference($custom_Worktag_02_Reference)
            ->setCustom_Worktag_03_Reference($custom_Worktag_03_Reference)
            ->setCustom_Worktag_04_Reference($custom_Worktag_04_Reference)
            ->setCustom_Worktag_05_Reference($custom_Worktag_05_Reference)
            ->setCustom_Worktag_06_Reference($custom_Worktag_06_Reference)
            ->setCustom_Worktag_07_Reference($custom_Worktag_07_Reference)
            ->setCustom_Worktag_08_Reference($custom_Worktag_08_Reference)
            ->setCustom_Worktag_09_Reference($custom_Worktag_09_Reference)
            ->setCustom_Worktag_10_Reference($custom_Worktag_10_Reference)
            ->setCustom_Worktag_11_Reference($custom_Worktag_11_Reference)
            ->setCustom_Worktag_12_Reference($custom_Worktag_12_Reference)
            ->setCustom_Worktag_13_Reference($custom_Worktag_13_Reference)
            ->setCustom_Worktag_14_Reference($custom_Worktag_14_Reference)
            ->setCustom_Worktag_15_Reference($custom_Worktag_15_Reference)
            ->setFund_Reference($fund_Reference)
            ->setGift_Reference($gift_Reference)
            ->setGrant_Reference($grant_Reference)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setLocation_Reference($location_Reference)
            ->setProgram_Reference($program_Reference)
            ->setRegion_Reference($region_Reference)
            ->setComment($comment);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Time_Entry_Code_Reference value
     * @return \StructType\Time_Entry_CodeObjectType|null
     */
    public function getTime_Entry_Code_Reference()
    {
        return $this->Time_Entry_Code_Reference;
    }
    /**
     * Set Time_Entry_Code_Reference value
     * @param \StructType\Time_Entry_CodeObjectType $time_Entry_Code_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setTime_Entry_Code_Reference(\StructType\Time_Entry_CodeObjectType $time_Entry_Code_Reference = null)
    {
        $this->Time_Entry_Code_Reference = $time_Entry_Code_Reference;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Project_Task_Reference value
     * @return \StructType\Project_Plan_TaskObjectType|null
     */
    public function getProject_Task_Reference()
    {
        return $this->Project_Task_Reference;
    }
    /**
     * Set Project_Task_Reference value
     * @param \StructType\Project_Plan_TaskObjectType $project_Task_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setProject_Task_Reference(\StructType\Project_Plan_TaskObjectType $project_Task_Reference = null)
    {
        $this->Project_Task_Reference = $project_Task_Reference;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($quantity) && strlen(substr($quantity, strpos($quantity, '.') + 1)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 fraction digits, "%d" given', strlen(substr($quantity, strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($quantity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $quantity)) !== 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 10 digits, "%d" given', strlen(substr($quantity, strpos($quantity, '.')))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get In_Date_Time value
     * @return string|null
     */
    public function getIn_Date_Time()
    {
        return $this->In_Date_Time;
    }
    /**
     * Set In_Date_Time value
     * @param string $in_Date_Time
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setIn_Date_Time($in_Date_Time = null)
    {
        // validation for constraint: string
        if (!is_null($in_Date_Time) && !is_string($in_Date_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($in_Date_Time)), __LINE__);
        }
        $this->In_Date_Time = $in_Date_Time;
        return $this;
    }
    /**
     * Get Out_Date_Time value
     * @return string|null
     */
    public function getOut_Date_Time()
    {
        return $this->Out_Date_Time;
    }
    /**
     * Set Out_Date_Time value
     * @param string $out_Date_Time
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setOut_Date_Time($out_Date_Time = null)
    {
        // validation for constraint: string
        if (!is_null($out_Date_Time) && !is_string($out_Date_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($out_Date_Time)), __LINE__);
        }
        $this->Out_Date_Time = $out_Date_Time;
        return $this;
    }
    /**
     * Get Out_Reason_Reference value
     * @return \StructType\Time_Punch_TypeObjectType|null
     */
    public function getOut_Reason_Reference()
    {
        return $this->Out_Reason_Reference;
    }
    /**
     * Set Out_Reason_Reference value
     * @param \StructType\Time_Punch_TypeObjectType $out_Reason_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setOut_Reason_Reference(\StructType\Time_Punch_TypeObjectType $out_Reason_Reference = null)
    {
        $this->Out_Reason_Reference = $out_Reason_Reference;
        return $this;
    }
    /**
     * Get Position_Reference value
     * @return \StructType\Position_ElementObjectType[]|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * Set Position_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_ElementObjectType[] $position_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setPosition_Reference(array $position_Reference = array())
    {
        foreach ($position_Reference as $reported_Time_Block_DataTypePosition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$reported_Time_Block_DataTypePosition_ReferenceItem instanceof \StructType\Position_ElementObjectType) {
                throw new \InvalidArgumentException(sprintf('The Position_Reference property can only contain items of \StructType\Position_ElementObjectType, "%s" given', is_object($reported_Time_Block_DataTypePosition_ReferenceItem) ? get_class($reported_Time_Block_DataTypePosition_ReferenceItem) : gettype($reported_Time_Block_DataTypePosition_ReferenceItem)), __LINE__);
            }
        }
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Add item to Position_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_ElementObjectType $item
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function addToPosition_Reference(\StructType\Position_ElementObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position_ElementObjectType) {
            throw new \InvalidArgumentException(sprintf('The Position_Reference property can only contain items of \StructType\Position_ElementObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Position_Reference[] = $item;
        return $this;
    }
    /**
     * Get Do_Not_Bill value
     * @return bool|null
     */
    public function getDo_Not_Bill()
    {
        return $this->Do_Not_Bill;
    }
    /**
     * Set Do_Not_Bill value
     * @param bool $do_Not_Bill
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setDo_Not_Bill($do_Not_Bill = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_Not_Bill) && !is_bool($do_Not_Bill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($do_Not_Bill)), __LINE__);
        }
        $this->Do_Not_Bill = $do_Not_Bill;
        return $this;
    }
    /**
     * Get Override_Rate value
     * @return float|null
     */
    public function getOverride_Rate()
    {
        return $this->Override_Rate;
    }
    /**
     * Set Override_Rate value
     * @param float $override_Rate
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setOverride_Rate($override_Rate = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($override_Rate) && strlen(substr($override_Rate, strpos($override_Rate, '.') + 1)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 fraction digits, "%d" given', strlen(substr($override_Rate, strpos($override_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($override_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $override_Rate), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($override_Rate) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $override_Rate)) !== 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 10 digits, "%d" given', strlen(substr($override_Rate, strpos($override_Rate, '.')))), __LINE__);
        }
        $this->Override_Rate = $override_Rate;
        return $this;
    }
    /**
     * Get Business_Unit_Reference value
     * @return \StructType\Business_UnitObjectType|null
     */
    public function getBusiness_Unit_Reference()
    {
        return $this->Business_Unit_Reference;
    }
    /**
     * Set Business_Unit_Reference value
     * @param \StructType\Business_UnitObjectType $business_Unit_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setBusiness_Unit_Reference(\StructType\Business_UnitObjectType $business_Unit_Reference = null)
    {
        $this->Business_Unit_Reference = $business_Unit_Reference;
        return $this;
    }
    /**
     * Get Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCost_Center_Reference()
    {
        return $this->Cost_Center_Reference;
    }
    /**
     * Set Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCost_Center_Reference(\StructType\Cost_CenterObjectType $cost_Center_Reference = null)
    {
        $this->Cost_Center_Reference = $cost_Center_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_01_Reference()
    {
        return $this->Custom_Organization_01_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_01_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference = null)
    {
        $this->Custom_Organization_01_Reference = $custom_Organization_01_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_02_Reference()
    {
        return $this->Custom_Organization_02_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_02_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference = null)
    {
        $this->Custom_Organization_02_Reference = $custom_Organization_02_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_03_Reference()
    {
        return $this->Custom_Organization_03_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_03_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference = null)
    {
        $this->Custom_Organization_03_Reference = $custom_Organization_03_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_04_Reference()
    {
        return $this->Custom_Organization_04_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_04_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference = null)
    {
        $this->Custom_Organization_04_Reference = $custom_Organization_04_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_05_Reference()
    {
        return $this->Custom_Organization_05_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_05_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference = null)
    {
        $this->Custom_Organization_05_Reference = $custom_Organization_05_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_06_Reference()
    {
        return $this->Custom_Organization_06_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_06_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference = null)
    {
        $this->Custom_Organization_06_Reference = $custom_Organization_06_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_07_Reference()
    {
        return $this->Custom_Organization_07_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_07_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference = null)
    {
        $this->Custom_Organization_07_Reference = $custom_Organization_07_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_08_Reference()
    {
        return $this->Custom_Organization_08_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_08_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference = null)
    {
        $this->Custom_Organization_08_Reference = $custom_Organization_08_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_09_Reference()
    {
        return $this->Custom_Organization_09_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_09_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference = null)
    {
        $this->Custom_Organization_09_Reference = $custom_Organization_09_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_10_Reference()
    {
        return $this->Custom_Organization_10_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Organization_10_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference = null)
    {
        $this->Custom_Organization_10_Reference = $custom_Organization_10_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_01_Reference()
    {
        return $this->Custom_Worktag_01_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_01_Reference(\StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference = null)
    {
        $this->Custom_Worktag_01_Reference = $custom_Worktag_01_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_02_Reference()
    {
        return $this->Custom_Worktag_02_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_02_Reference(\StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference = null)
    {
        $this->Custom_Worktag_02_Reference = $custom_Worktag_02_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_03_Reference()
    {
        return $this->Custom_Worktag_03_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_03_Reference(\StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference = null)
    {
        $this->Custom_Worktag_03_Reference = $custom_Worktag_03_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_04_Reference()
    {
        return $this->Custom_Worktag_04_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_04_Reference(\StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference = null)
    {
        $this->Custom_Worktag_04_Reference = $custom_Worktag_04_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_05_Reference()
    {
        return $this->Custom_Worktag_05_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_05_Reference(\StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference = null)
    {
        $this->Custom_Worktag_05_Reference = $custom_Worktag_05_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_06_Reference()
    {
        return $this->Custom_Worktag_06_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_06_Reference(\StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference = null)
    {
        $this->Custom_Worktag_06_Reference = $custom_Worktag_06_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_07_Reference()
    {
        return $this->Custom_Worktag_07_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_07_Reference(\StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference = null)
    {
        $this->Custom_Worktag_07_Reference = $custom_Worktag_07_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_08_Reference()
    {
        return $this->Custom_Worktag_08_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_08_Reference(\StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference = null)
    {
        $this->Custom_Worktag_08_Reference = $custom_Worktag_08_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_09_Reference()
    {
        return $this->Custom_Worktag_09_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_09_Reference(\StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference = null)
    {
        $this->Custom_Worktag_09_Reference = $custom_Worktag_09_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_10_Reference()
    {
        return $this->Custom_Worktag_10_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_10_Reference(\StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference = null)
    {
        $this->Custom_Worktag_10_Reference = $custom_Worktag_10_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_11_Reference()
    {
        return $this->Custom_Worktag_11_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_11_Reference(\StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference = null)
    {
        $this->Custom_Worktag_11_Reference = $custom_Worktag_11_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_12_Reference()
    {
        return $this->Custom_Worktag_12_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_12_Reference(\StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference = null)
    {
        $this->Custom_Worktag_12_Reference = $custom_Worktag_12_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_13_Reference()
    {
        return $this->Custom_Worktag_13_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_13_Reference(\StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference = null)
    {
        $this->Custom_Worktag_13_Reference = $custom_Worktag_13_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_14_Reference()
    {
        return $this->Custom_Worktag_14_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_14_Reference(\StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference = null)
    {
        $this->Custom_Worktag_14_Reference = $custom_Worktag_14_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_15_Reference()
    {
        return $this->Custom_Worktag_15_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setCustom_Worktag_15_Reference(\StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference = null)
    {
        $this->Custom_Worktag_15_Reference = $custom_Worktag_15_Reference;
        return $this;
    }
    /**
     * Get Fund_Reference value
     * @return \StructType\FundObjectType|null
     */
    public function getFund_Reference()
    {
        return $this->Fund_Reference;
    }
    /**
     * Set Fund_Reference value
     * @param \StructType\FundObjectType $fund_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setFund_Reference(\StructType\FundObjectType $fund_Reference = null)
    {
        $this->Fund_Reference = $fund_Reference;
        return $this;
    }
    /**
     * Get Gift_Reference value
     * @return \StructType\GiftObjectType|null
     */
    public function getGift_Reference()
    {
        return $this->Gift_Reference;
    }
    /**
     * Set Gift_Reference value
     * @param \StructType\GiftObjectType $gift_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setGift_Reference(\StructType\GiftObjectType $gift_Reference = null)
    {
        $this->Gift_Reference = $gift_Reference;
        return $this;
    }
    /**
     * Get Grant_Reference value
     * @return \StructType\GrantObjectType|null
     */
    public function getGrant_Reference()
    {
        return $this->Grant_Reference;
    }
    /**
     * Set Grant_Reference value
     * @param \StructType\GrantObjectType $grant_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setGrant_Reference(\StructType\GrantObjectType $grant_Reference = null)
    {
        $this->Grant_Reference = $grant_Reference;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * Set Job_Profile_Reference value
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setJob_Profile_Reference(\StructType\Job_ProfileObjectType $job_Profile_Reference = null)
    {
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Program_Reference value
     * @return \StructType\ProgramObjectType|null
     */
    public function getProgram_Reference()
    {
        return $this->Program_Reference;
    }
    /**
     * Set Program_Reference value
     * @param \StructType\ProgramObjectType $program_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setProgram_Reference(\StructType\ProgramObjectType $program_Reference = null)
    {
        $this->Program_Reference = $program_Reference;
        return $this;
    }
    /**
     * Get Region_Reference value
     * @return \StructType\RegionObjectType|null
     */
    public function getRegion_Reference()
    {
        return $this->Region_Reference;
    }
    /**
     * Set Region_Reference value
     * @param \StructType\RegionObjectType $region_Reference
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setRegion_Reference(\StructType\RegionObjectType $region_Reference = null)
    {
        $this->Region_Reference = $region_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Reported_Time_Block_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Reported_Time_Block_DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
