<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Time_Clock_Events_RequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Load instances of External Time Clock Events.
 * @subpackage Structs
 */
class Put_Time_Clock_Events_RequestType extends AbstractStructBase
{
    /**
     * The Time_Clock_Event_Data
     * Meta informations extracted from the WSDL
     * - documentation: Data related to the time clock event(s) to be processed.
     * - maxOccurs: unbounded
     * @var \StructType\Time_Clock_Event_DataType[]
     */
    public $Time_Clock_Event_Data;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Time_Clock_Events_RequestType
     * @uses Put_Time_Clock_Events_RequestType::setTime_Clock_Event_Data()
     * @uses Put_Time_Clock_Events_RequestType::setVersion()
     * @param \StructType\Time_Clock_Event_DataType[] $time_Clock_Event_Data
     * @param string $version
     */
    public function __construct(array $time_Clock_Event_Data = array(), $version = null)
    {
        $this
            ->setTime_Clock_Event_Data($time_Clock_Event_Data)
            ->setVersion($version);
    }
    /**
     * Get Time_Clock_Event_Data value
     * @return \StructType\Time_Clock_Event_DataType[]|null
     */
    public function getTime_Clock_Event_Data()
    {
        return $this->Time_Clock_Event_Data;
    }
    /**
     * Set Time_Clock_Event_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Clock_Event_DataType[] $time_Clock_Event_Data
     * @return \StructType\Put_Time_Clock_Events_RequestType
     */
    public function setTime_Clock_Event_Data(array $time_Clock_Event_Data = array())
    {
        foreach ($time_Clock_Event_Data as $put_Time_Clock_Events_RequestTypeTime_Clock_Event_DataItem) {
            // validation for constraint: itemType
            if (!$put_Time_Clock_Events_RequestTypeTime_Clock_Event_DataItem instanceof \StructType\Time_Clock_Event_DataType) {
                throw new \InvalidArgumentException(sprintf('The Time_Clock_Event_Data property can only contain items of \StructType\Time_Clock_Event_DataType, "%s" given', is_object($put_Time_Clock_Events_RequestTypeTime_Clock_Event_DataItem) ? get_class($put_Time_Clock_Events_RequestTypeTime_Clock_Event_DataItem) : gettype($put_Time_Clock_Events_RequestTypeTime_Clock_Event_DataItem)), __LINE__);
            }
        }
        $this->Time_Clock_Event_Data = $time_Clock_Event_Data;
        return $this;
    }
    /**
     * Add item to Time_Clock_Event_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Clock_Event_DataType $item
     * @return \StructType\Put_Time_Clock_Events_RequestType
     */
    public function addToTime_Clock_Event_Data(\StructType\Time_Clock_Event_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Time_Clock_Event_DataType) {
            throw new \InvalidArgumentException(sprintf('The Time_Clock_Event_Data property can only contain items of \StructType\Time_Clock_Event_DataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Time_Clock_Event_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Time_Clock_Events_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Put_Time_Clock_Events_RequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
