<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Calculated_Time_Blocks_ResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Get Calculated Time Block Response
 * @subpackage Structs
 */
class Get_Calculated_Time_Blocks_ResponseType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Calculated_Time_Block_Request_ReferencesType
     */
    public $Request_References;
    /**
     * The Request_Criteria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Calculated_Time_Block_Request_CriteriaType
     */
    public $Request_Criteria;
    /**
     * The Response_Filter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Response_Filter;
    /**
     * The Response_Group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Calculated_Time_Block_Response_GroupType
     */
    public $Response_Group;
    /**
     * The Response_Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Response_ResultsType[]
     */
    public $Response_Results;
    /**
     * The Response_Data
     * Meta informations extracted from the WSDL
     * - documentation: Calculated Time Block Response Data
     * - minOccurs: 0
     * @var \StructType\Calculated_Time_Block_Response_DataType
     */
    public $Response_Data;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Calculated_Time_Blocks_ResponseType
     * @uses Get_Calculated_Time_Blocks_ResponseType::setRequest_References()
     * @uses Get_Calculated_Time_Blocks_ResponseType::setRequest_Criteria()
     * @uses Get_Calculated_Time_Blocks_ResponseType::setResponse_Filter()
     * @uses Get_Calculated_Time_Blocks_ResponseType::setResponse_Group()
     * @uses Get_Calculated_Time_Blocks_ResponseType::setResponse_Results()
     * @uses Get_Calculated_Time_Blocks_ResponseType::setResponse_Data()
     * @uses Get_Calculated_Time_Blocks_ResponseType::setVersion()
     * @param \StructType\Calculated_Time_Block_Request_ReferencesType $request_References
     * @param \StructType\Calculated_Time_Block_Request_CriteriaType $request_Criteria
     * @param \StructType\Response_FilterType $response_Filter
     * @param \StructType\Calculated_Time_Block_Response_GroupType $response_Group
     * @param \StructType\Response_ResultsType[] $response_Results
     * @param \StructType\Calculated_Time_Block_Response_DataType $response_Data
     * @param string $version
     */
    public function __construct(\StructType\Calculated_Time_Block_Request_ReferencesType $request_References = null, \StructType\Calculated_Time_Block_Request_CriteriaType $request_Criteria = null, \StructType\Response_FilterType $response_Filter = null, \StructType\Calculated_Time_Block_Response_GroupType $response_Group = null, array $response_Results = array(), \StructType\Calculated_Time_Block_Response_DataType $response_Data = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setRequest_Criteria($request_Criteria)
            ->setResponse_Filter($response_Filter)
            ->setResponse_Group($response_Group)
            ->setResponse_Results($response_Results)
            ->setResponse_Data($response_Data)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Calculated_Time_Block_Request_ReferencesType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Calculated_Time_Block_Request_ReferencesType $request_References
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public function setRequest_References(\StructType\Calculated_Time_Block_Request_ReferencesType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Request_Criteria value
     * @return \StructType\Calculated_Time_Block_Request_CriteriaType|null
     */
    public function getRequest_Criteria()
    {
        return $this->Request_Criteria;
    }
    /**
     * Set Request_Criteria value
     * @param \StructType\Calculated_Time_Block_Request_CriteriaType $request_Criteria
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public function setRequest_Criteria(\StructType\Calculated_Time_Block_Request_CriteriaType $request_Criteria = null)
    {
        $this->Request_Criteria = $request_Criteria;
        return $this;
    }
    /**
     * Get Response_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getResponse_Filter()
    {
        return $this->Response_Filter;
    }
    /**
     * Set Response_Filter value
     * @param \StructType\Response_FilterType $response_Filter
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public function setResponse_Filter(\StructType\Response_FilterType $response_Filter = null)
    {
        $this->Response_Filter = $response_Filter;
        return $this;
    }
    /**
     * Get Response_Group value
     * @return \StructType\Calculated_Time_Block_Response_GroupType|null
     */
    public function getResponse_Group()
    {
        return $this->Response_Group;
    }
    /**
     * Set Response_Group value
     * @param \StructType\Calculated_Time_Block_Response_GroupType $response_Group
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public function setResponse_Group(\StructType\Calculated_Time_Block_Response_GroupType $response_Group = null)
    {
        $this->Response_Group = $response_Group;
        return $this;
    }
    /**
     * Get Response_Results value
     * @return \StructType\Response_ResultsType[]|null
     */
    public function getResponse_Results()
    {
        return $this->Response_Results;
    }
    /**
     * Set Response_Results value
     * @throws \InvalidArgumentException
     * @param \StructType\Response_ResultsType[] $response_Results
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public function setResponse_Results(array $response_Results = array())
    {
        foreach ($response_Results as $get_Calculated_Time_Blocks_ResponseTypeResponse_ResultsItem) {
            // validation for constraint: itemType
            if (!$get_Calculated_Time_Blocks_ResponseTypeResponse_ResultsItem instanceof \StructType\Response_ResultsType) {
                throw new \InvalidArgumentException(sprintf('The Response_Results property can only contain items of \StructType\Response_ResultsType, "%s" given', is_object($get_Calculated_Time_Blocks_ResponseTypeResponse_ResultsItem) ? get_class($get_Calculated_Time_Blocks_ResponseTypeResponse_ResultsItem) : gettype($get_Calculated_Time_Blocks_ResponseTypeResponse_ResultsItem)), __LINE__);
            }
        }
        $this->Response_Results = $response_Results;
        return $this;
    }
    /**
     * Add item to Response_Results value
     * @throws \InvalidArgumentException
     * @param \StructType\Response_ResultsType $item
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public function addToResponse_Results(\StructType\Response_ResultsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Response_ResultsType) {
            throw new \InvalidArgumentException(sprintf('The Response_Results property can only contain items of \StructType\Response_ResultsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Response_Results[] = $item;
        return $this;
    }
    /**
     * Get Response_Data value
     * @return \StructType\Calculated_Time_Block_Response_DataType|null
     */
    public function getResponse_Data()
    {
        return $this->Response_Data;
    }
    /**
     * Set Response_Data value
     * @param \StructType\Calculated_Time_Block_Response_DataType $response_Data
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public function setResponse_Data(\StructType\Calculated_Time_Block_Response_DataType $response_Data = null)
    {
        $this->Response_Data = $response_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Get_Calculated_Time_Blocks_ResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
