<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Calculated_Time_Block_DataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Calculated Time Block Response Data
 * @subpackage Structs
 */
class Calculated_Time_Block_DataType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Worker for the calculated time block
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Calculated_Date
     * Meta informations extracted from the WSDL
     * - documentation: Calculated Date for the calculated time block.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Calculated_Date;
    /**
     * The Shift_Date
     * Meta informations extracted from the WSDL
     * - documentation: Shift Date for the calculated time block.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shift_Date;
    /**
     * The In_Time
     * Meta informations extracted from the WSDL
     * - documentation: Calculated In Time (if applicable) for the calculated time block
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $In_Time;
    /**
     * The Out_Time
     * Meta informations extracted from the WSDL
     * - documentation: Calculated Out Time (if applicable) for the calculated time block
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Out_Time;
    /**
     * The Calculated_Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Calculated Quantity for the calculated time block
     * - fractionDigits: 6
     * - totalDigits: 18
     * @var float
     */
    public $Calculated_Quantity;
    /**
     * The Status_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Status for the calculated time block
     * - minOccurs: 0
     * @var \StructType\Time_Tracking_Set_Up_OptionObjectType
     */
    public $Status_Reference;
    /**
     * The Is_Deleted
     * Meta informations extracted from the WSDL
     * - documentation: Is Deleted flag for the calculated time block
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Deleted;
    /**
     * The Calculation_Tag_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Calculation Tags for the calculated time block
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Time_Calculation_TagObjectType[]
     */
    public $Calculation_Tag_Reference;
    /**
     * The Last_Updated
     * Meta informations extracted from the WSDL
     * - documentation: Last Updated
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated;
    /**
     * The Business_Unit_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Business Unit
     * - minOccurs: 0
     * @var \StructType\Business_UnitObjectType
     */
    public $Business_Unit_Reference;
    /**
     * The Cost_Center_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Cost Center
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Cost_Center_Reference;
    /**
     * The Fund_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Fund
     * - minOccurs: 0
     * @var \StructType\FundObjectType
     */
    public $Fund_Reference;
    /**
     * The Gift_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Gift
     * - minOccurs: 0
     * @var \StructType\GiftObjectType
     */
    public $Gift_Reference;
    /**
     * The Grant_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Grant
     * - minOccurs: 0
     * @var \StructType\GrantObjectType
     */
    public $Grant_Reference;
    /**
     * The Job_Profile_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Job Profile
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType
     */
    public $Job_Profile_Reference;
    /**
     * The Location_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Location
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Program_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Program
     * - minOccurs: 0
     * @var \StructType\ProgramObjectType
     */
    public $Program_Reference;
    /**
     * The Region_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Region
     * - minOccurs: 0
     * @var \StructType\RegionObjectType
     */
    public $Region_Reference;
    /**
     * The Custom_Worktag_01_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 01
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_01ObjectType
     */
    public $Custom_Worktag_01_Reference;
    /**
     * The Custom_Worktag_02_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 02
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_02ObjectType
     */
    public $Custom_Worktag_02_Reference;
    /**
     * The Custom_Worktag_03_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 03
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_03ObjectType
     */
    public $Custom_Worktag_03_Reference;
    /**
     * The Custom_Worktag_04_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 04
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_04ObjectType
     */
    public $Custom_Worktag_04_Reference;
    /**
     * The Custom_Worktag_05_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 05
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_05ObjectType
     */
    public $Custom_Worktag_05_Reference;
    /**
     * The Custom_Worktag_06_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 06
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_06ObjectType
     */
    public $Custom_Worktag_06_Reference;
    /**
     * The Custom_Worktag_07_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 07
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_07ObjectType
     */
    public $Custom_Worktag_07_Reference;
    /**
     * The Custom_Worktag_08_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 08
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_08ObjectType
     */
    public $Custom_Worktag_08_Reference;
    /**
     * The Custom_Worktag_09_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 09
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_09ObjectType
     */
    public $Custom_Worktag_09_Reference;
    /**
     * The Custom_Worktag_10_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 10
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_10ObjectType
     */
    public $Custom_Worktag_10_Reference;
    /**
     * The Custom_Worktag_11_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 11
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_11ObjectType
     */
    public $Custom_Worktag_11_Reference;
    /**
     * The Custom_Worktag_12_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 12
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_12ObjectType
     */
    public $Custom_Worktag_12_Reference;
    /**
     * The Custom_Worktag_13_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 13
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_13ObjectType
     */
    public $Custom_Worktag_13_Reference;
    /**
     * The Custom_Worktag_14_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 14
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_14ObjectType
     */
    public $Custom_Worktag_14_Reference;
    /**
     * The Custom_Worktag_15_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Worktag 15
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_15ObjectType
     */
    public $Custom_Worktag_15_Reference;
    /**
     * The Custom_Organization_01_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 01
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_01_Reference;
    /**
     * The Custom_Organization_02_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 02
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_02_Reference;
    /**
     * The Custom_Organization_03_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 03
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_03_Reference;
    /**
     * The Custom_Organization_04_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 04
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_04_Reference;
    /**
     * The Custom_Organization_05_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 05
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_05_Reference;
    /**
     * The Custom_Organization_06_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 06
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_06_Reference;
    /**
     * The Custom_Organization_07_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 07
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_07_Reference;
    /**
     * The Custom_Organization_08_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 08
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_08_Reference;
    /**
     * The Custom_Organization_09_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 09
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_09_Reference;
    /**
     * The Custom_Organization_10_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Custom Organization 10
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_10_Reference;
    /**
     * Constructor method for Calculated_Time_Block_DataType
     * @uses Calculated_Time_Block_DataType::setWorker_Reference()
     * @uses Calculated_Time_Block_DataType::setCalculated_Date()
     * @uses Calculated_Time_Block_DataType::setShift_Date()
     * @uses Calculated_Time_Block_DataType::setIn_Time()
     * @uses Calculated_Time_Block_DataType::setOut_Time()
     * @uses Calculated_Time_Block_DataType::setCalculated_Quantity()
     * @uses Calculated_Time_Block_DataType::setStatus_Reference()
     * @uses Calculated_Time_Block_DataType::setIs_Deleted()
     * @uses Calculated_Time_Block_DataType::setCalculation_Tag_Reference()
     * @uses Calculated_Time_Block_DataType::setLast_Updated()
     * @uses Calculated_Time_Block_DataType::setBusiness_Unit_Reference()
     * @uses Calculated_Time_Block_DataType::setCost_Center_Reference()
     * @uses Calculated_Time_Block_DataType::setFund_Reference()
     * @uses Calculated_Time_Block_DataType::setGift_Reference()
     * @uses Calculated_Time_Block_DataType::setGrant_Reference()
     * @uses Calculated_Time_Block_DataType::setJob_Profile_Reference()
     * @uses Calculated_Time_Block_DataType::setLocation_Reference()
     * @uses Calculated_Time_Block_DataType::setProgram_Reference()
     * @uses Calculated_Time_Block_DataType::setRegion_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_01_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_02_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_03_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_04_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_05_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_06_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_07_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_08_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_09_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_10_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_11_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_12_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_13_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_14_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Worktag_15_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_01_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_02_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_03_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_04_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_05_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_06_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_07_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_08_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_09_Reference()
     * @uses Calculated_Time_Block_DataType::setCustom_Organization_10_Reference()
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param string $calculated_Date
     * @param string $shift_Date
     * @param string $in_Time
     * @param string $out_Time
     * @param float $calculated_Quantity
     * @param \StructType\Time_Tracking_Set_Up_OptionObjectType $status_Reference
     * @param bool $is_Deleted
     * @param \StructType\Time_Calculation_TagObjectType[] $calculation_Tag_Reference
     * @param string $last_Updated
     * @param \StructType\Business_UnitObjectType $business_Unit_Reference
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @param \StructType\FundObjectType $fund_Reference
     * @param \StructType\GiftObjectType $gift_Reference
     * @param \StructType\GrantObjectType $grant_Reference
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @param \StructType\LocationObjectType $location_Reference
     * @param \StructType\ProgramObjectType $program_Reference
     * @param \StructType\RegionObjectType $region_Reference
     * @param \StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference
     * @param \StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference
     * @param \StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference
     * @param \StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference
     * @param \StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference
     * @param \StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference
     * @param \StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference
     * @param \StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference
     * @param \StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference
     * @param \StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference
     * @param \StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference
     * @param \StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference
     * @param \StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference
     * @param \StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference
     * @param \StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference
     */
    public function __construct(\StructType\WorkerObjectType $worker_Reference = null, $calculated_Date = null, $shift_Date = null, $in_Time = null, $out_Time = null, $calculated_Quantity = null, \StructType\Time_Tracking_Set_Up_OptionObjectType $status_Reference = null, $is_Deleted = null, array $calculation_Tag_Reference = array(), $last_Updated = null, \StructType\Business_UnitObjectType $business_Unit_Reference = null, \StructType\Cost_CenterObjectType $cost_Center_Reference = null, \StructType\FundObjectType $fund_Reference = null, \StructType\GiftObjectType $gift_Reference = null, \StructType\GrantObjectType $grant_Reference = null, \StructType\Job_ProfileObjectType $job_Profile_Reference = null, \StructType\LocationObjectType $location_Reference = null, \StructType\ProgramObjectType $program_Reference = null, \StructType\RegionObjectType $region_Reference = null, \StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference = null, \StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference = null, \StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference = null, \StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference = null, \StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference = null, \StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference = null, \StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference = null, \StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference = null, \StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference = null, \StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference = null, \StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference = null, \StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference = null, \StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference = null, \StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference = null, \StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference = null)
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setCalculated_Date($calculated_Date)
            ->setShift_Date($shift_Date)
            ->setIn_Time($in_Time)
            ->setOut_Time($out_Time)
            ->setCalculated_Quantity($calculated_Quantity)
            ->setStatus_Reference($status_Reference)
            ->setIs_Deleted($is_Deleted)
            ->setCalculation_Tag_Reference($calculation_Tag_Reference)
            ->setLast_Updated($last_Updated)
            ->setBusiness_Unit_Reference($business_Unit_Reference)
            ->setCost_Center_Reference($cost_Center_Reference)
            ->setFund_Reference($fund_Reference)
            ->setGift_Reference($gift_Reference)
            ->setGrant_Reference($grant_Reference)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setLocation_Reference($location_Reference)
            ->setProgram_Reference($program_Reference)
            ->setRegion_Reference($region_Reference)
            ->setCustom_Worktag_01_Reference($custom_Worktag_01_Reference)
            ->setCustom_Worktag_02_Reference($custom_Worktag_02_Reference)
            ->setCustom_Worktag_03_Reference($custom_Worktag_03_Reference)
            ->setCustom_Worktag_04_Reference($custom_Worktag_04_Reference)
            ->setCustom_Worktag_05_Reference($custom_Worktag_05_Reference)
            ->setCustom_Worktag_06_Reference($custom_Worktag_06_Reference)
            ->setCustom_Worktag_07_Reference($custom_Worktag_07_Reference)
            ->setCustom_Worktag_08_Reference($custom_Worktag_08_Reference)
            ->setCustom_Worktag_09_Reference($custom_Worktag_09_Reference)
            ->setCustom_Worktag_10_Reference($custom_Worktag_10_Reference)
            ->setCustom_Worktag_11_Reference($custom_Worktag_11_Reference)
            ->setCustom_Worktag_12_Reference($custom_Worktag_12_Reference)
            ->setCustom_Worktag_13_Reference($custom_Worktag_13_Reference)
            ->setCustom_Worktag_14_Reference($custom_Worktag_14_Reference)
            ->setCustom_Worktag_15_Reference($custom_Worktag_15_Reference)
            ->setCustom_Organization_01_Reference($custom_Organization_01_Reference)
            ->setCustom_Organization_02_Reference($custom_Organization_02_Reference)
            ->setCustom_Organization_03_Reference($custom_Organization_03_Reference)
            ->setCustom_Organization_04_Reference($custom_Organization_04_Reference)
            ->setCustom_Organization_05_Reference($custom_Organization_05_Reference)
            ->setCustom_Organization_06_Reference($custom_Organization_06_Reference)
            ->setCustom_Organization_07_Reference($custom_Organization_07_Reference)
            ->setCustom_Organization_08_Reference($custom_Organization_08_Reference)
            ->setCustom_Organization_09_Reference($custom_Organization_09_Reference)
            ->setCustom_Organization_10_Reference($custom_Organization_10_Reference);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Calculated_Date value
     * @return string|null
     */
    public function getCalculated_Date()
    {
        return $this->Calculated_Date;
    }
    /**
     * Set Calculated_Date value
     * @param string $calculated_Date
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCalculated_Date($calculated_Date = null)
    {
        // validation for constraint: string
        if (!is_null($calculated_Date) && !is_string($calculated_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calculated_Date)), __LINE__);
        }
        $this->Calculated_Date = $calculated_Date;
        return $this;
    }
    /**
     * Get Shift_Date value
     * @return string|null
     */
    public function getShift_Date()
    {
        return $this->Shift_Date;
    }
    /**
     * Set Shift_Date value
     * @param string $shift_Date
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setShift_Date($shift_Date = null)
    {
        // validation for constraint: string
        if (!is_null($shift_Date) && !is_string($shift_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shift_Date)), __LINE__);
        }
        $this->Shift_Date = $shift_Date;
        return $this;
    }
    /**
     * Get In_Time value
     * @return string|null
     */
    public function getIn_Time()
    {
        return $this->In_Time;
    }
    /**
     * Set In_Time value
     * @param string $in_Time
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setIn_Time($in_Time = null)
    {
        // validation for constraint: string
        if (!is_null($in_Time) && !is_string($in_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($in_Time)), __LINE__);
        }
        $this->In_Time = $in_Time;
        return $this;
    }
    /**
     * Get Out_Time value
     * @return string|null
     */
    public function getOut_Time()
    {
        return $this->Out_Time;
    }
    /**
     * Set Out_Time value
     * @param string $out_Time
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setOut_Time($out_Time = null)
    {
        // validation for constraint: string
        if (!is_null($out_Time) && !is_string($out_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($out_Time)), __LINE__);
        }
        $this->Out_Time = $out_Time;
        return $this;
    }
    /**
     * Get Calculated_Quantity value
     * @return float|null
     */
    public function getCalculated_Quantity()
    {
        return $this->Calculated_Quantity;
    }
    /**
     * Set Calculated_Quantity value
     * @param float $calculated_Quantity
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCalculated_Quantity($calculated_Quantity = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($calculated_Quantity) && strlen(substr($calculated_Quantity, strpos($calculated_Quantity, '.') + 1)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 fraction digits, "%d" given', strlen(substr($calculated_Quantity, strpos($calculated_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($calculated_Quantity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $calculated_Quantity)) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 18 digits, "%d" given', strlen(substr($calculated_Quantity, strpos($calculated_Quantity, '.')))), __LINE__);
        }
        $this->Calculated_Quantity = $calculated_Quantity;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Time_Tracking_Set_Up_OptionObjectType|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * Set Status_Reference value
     * @param \StructType\Time_Tracking_Set_Up_OptionObjectType $status_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setStatus_Reference(\StructType\Time_Tracking_Set_Up_OptionObjectType $status_Reference = null)
    {
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Get Is_Deleted value
     * @return bool|null
     */
    public function getIs_Deleted()
    {
        return $this->Is_Deleted;
    }
    /**
     * Set Is_Deleted value
     * @param bool $is_Deleted
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setIs_Deleted($is_Deleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Deleted) && !is_bool($is_Deleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_Deleted)), __LINE__);
        }
        $this->Is_Deleted = $is_Deleted;
        return $this;
    }
    /**
     * Get Calculation_Tag_Reference value
     * @return \StructType\Time_Calculation_TagObjectType[]|null
     */
    public function getCalculation_Tag_Reference()
    {
        return $this->Calculation_Tag_Reference;
    }
    /**
     * Set Calculation_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Calculation_TagObjectType[] $calculation_Tag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCalculation_Tag_Reference(array $calculation_Tag_Reference = array())
    {
        foreach ($calculation_Tag_Reference as $calculated_Time_Block_DataTypeCalculation_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$calculated_Time_Block_DataTypeCalculation_Tag_ReferenceItem instanceof \StructType\Time_Calculation_TagObjectType) {
                throw new \InvalidArgumentException(sprintf('The Calculation_Tag_Reference property can only contain items of \StructType\Time_Calculation_TagObjectType, "%s" given', is_object($calculated_Time_Block_DataTypeCalculation_Tag_ReferenceItem) ? get_class($calculated_Time_Block_DataTypeCalculation_Tag_ReferenceItem) : gettype($calculated_Time_Block_DataTypeCalculation_Tag_ReferenceItem)), __LINE__);
            }
        }
        $this->Calculation_Tag_Reference = $calculation_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Calculation_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Calculation_TagObjectType $item
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function addToCalculation_Tag_Reference(\StructType\Time_Calculation_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Time_Calculation_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Calculation_Tag_Reference property can only contain items of \StructType\Time_Calculation_TagObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Calculation_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Last_Updated value
     * @return string|null
     */
    public function getLast_Updated()
    {
        return $this->Last_Updated;
    }
    /**
     * Set Last_Updated value
     * @param string $last_Updated
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setLast_Updated($last_Updated = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated) && !is_string($last_Updated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_Updated)), __LINE__);
        }
        $this->Last_Updated = $last_Updated;
        return $this;
    }
    /**
     * Get Business_Unit_Reference value
     * @return \StructType\Business_UnitObjectType|null
     */
    public function getBusiness_Unit_Reference()
    {
        return $this->Business_Unit_Reference;
    }
    /**
     * Set Business_Unit_Reference value
     * @param \StructType\Business_UnitObjectType $business_Unit_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setBusiness_Unit_Reference(\StructType\Business_UnitObjectType $business_Unit_Reference = null)
    {
        $this->Business_Unit_Reference = $business_Unit_Reference;
        return $this;
    }
    /**
     * Get Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCost_Center_Reference()
    {
        return $this->Cost_Center_Reference;
    }
    /**
     * Set Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCost_Center_Reference(\StructType\Cost_CenterObjectType $cost_Center_Reference = null)
    {
        $this->Cost_Center_Reference = $cost_Center_Reference;
        return $this;
    }
    /**
     * Get Fund_Reference value
     * @return \StructType\FundObjectType|null
     */
    public function getFund_Reference()
    {
        return $this->Fund_Reference;
    }
    /**
     * Set Fund_Reference value
     * @param \StructType\FundObjectType $fund_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setFund_Reference(\StructType\FundObjectType $fund_Reference = null)
    {
        $this->Fund_Reference = $fund_Reference;
        return $this;
    }
    /**
     * Get Gift_Reference value
     * @return \StructType\GiftObjectType|null
     */
    public function getGift_Reference()
    {
        return $this->Gift_Reference;
    }
    /**
     * Set Gift_Reference value
     * @param \StructType\GiftObjectType $gift_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setGift_Reference(\StructType\GiftObjectType $gift_Reference = null)
    {
        $this->Gift_Reference = $gift_Reference;
        return $this;
    }
    /**
     * Get Grant_Reference value
     * @return \StructType\GrantObjectType|null
     */
    public function getGrant_Reference()
    {
        return $this->Grant_Reference;
    }
    /**
     * Set Grant_Reference value
     * @param \StructType\GrantObjectType $grant_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setGrant_Reference(\StructType\GrantObjectType $grant_Reference = null)
    {
        $this->Grant_Reference = $grant_Reference;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * Set Job_Profile_Reference value
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setJob_Profile_Reference(\StructType\Job_ProfileObjectType $job_Profile_Reference = null)
    {
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Program_Reference value
     * @return \StructType\ProgramObjectType|null
     */
    public function getProgram_Reference()
    {
        return $this->Program_Reference;
    }
    /**
     * Set Program_Reference value
     * @param \StructType\ProgramObjectType $program_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setProgram_Reference(\StructType\ProgramObjectType $program_Reference = null)
    {
        $this->Program_Reference = $program_Reference;
        return $this;
    }
    /**
     * Get Region_Reference value
     * @return \StructType\RegionObjectType|null
     */
    public function getRegion_Reference()
    {
        return $this->Region_Reference;
    }
    /**
     * Set Region_Reference value
     * @param \StructType\RegionObjectType $region_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setRegion_Reference(\StructType\RegionObjectType $region_Reference = null)
    {
        $this->Region_Reference = $region_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_01_Reference()
    {
        return $this->Custom_Worktag_01_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_01_Reference(\StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference = null)
    {
        $this->Custom_Worktag_01_Reference = $custom_Worktag_01_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_02_Reference()
    {
        return $this->Custom_Worktag_02_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_02_Reference(\StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference = null)
    {
        $this->Custom_Worktag_02_Reference = $custom_Worktag_02_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_03_Reference()
    {
        return $this->Custom_Worktag_03_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_03_Reference(\StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference = null)
    {
        $this->Custom_Worktag_03_Reference = $custom_Worktag_03_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_04_Reference()
    {
        return $this->Custom_Worktag_04_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_04_Reference(\StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference = null)
    {
        $this->Custom_Worktag_04_Reference = $custom_Worktag_04_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_05_Reference()
    {
        return $this->Custom_Worktag_05_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_05_Reference(\StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference = null)
    {
        $this->Custom_Worktag_05_Reference = $custom_Worktag_05_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_06_Reference()
    {
        return $this->Custom_Worktag_06_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_06_Reference(\StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference = null)
    {
        $this->Custom_Worktag_06_Reference = $custom_Worktag_06_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_07_Reference()
    {
        return $this->Custom_Worktag_07_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_07_Reference(\StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference = null)
    {
        $this->Custom_Worktag_07_Reference = $custom_Worktag_07_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_08_Reference()
    {
        return $this->Custom_Worktag_08_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_08_Reference(\StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference = null)
    {
        $this->Custom_Worktag_08_Reference = $custom_Worktag_08_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_09_Reference()
    {
        return $this->Custom_Worktag_09_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_09_Reference(\StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference = null)
    {
        $this->Custom_Worktag_09_Reference = $custom_Worktag_09_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_10_Reference()
    {
        return $this->Custom_Worktag_10_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_10_Reference(\StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference = null)
    {
        $this->Custom_Worktag_10_Reference = $custom_Worktag_10_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_11_Reference()
    {
        return $this->Custom_Worktag_11_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_11_Reference(\StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference = null)
    {
        $this->Custom_Worktag_11_Reference = $custom_Worktag_11_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_12_Reference()
    {
        return $this->Custom_Worktag_12_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_12_Reference(\StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference = null)
    {
        $this->Custom_Worktag_12_Reference = $custom_Worktag_12_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_13_Reference()
    {
        return $this->Custom_Worktag_13_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_13_Reference(\StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference = null)
    {
        $this->Custom_Worktag_13_Reference = $custom_Worktag_13_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_14_Reference()
    {
        return $this->Custom_Worktag_14_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_14_Reference(\StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference = null)
    {
        $this->Custom_Worktag_14_Reference = $custom_Worktag_14_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_15_Reference()
    {
        return $this->Custom_Worktag_15_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Worktag_15_Reference(\StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference = null)
    {
        $this->Custom_Worktag_15_Reference = $custom_Worktag_15_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_01_Reference()
    {
        return $this->Custom_Organization_01_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_01_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference = null)
    {
        $this->Custom_Organization_01_Reference = $custom_Organization_01_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_02_Reference()
    {
        return $this->Custom_Organization_02_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_02_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference = null)
    {
        $this->Custom_Organization_02_Reference = $custom_Organization_02_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_03_Reference()
    {
        return $this->Custom_Organization_03_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_03_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference = null)
    {
        $this->Custom_Organization_03_Reference = $custom_Organization_03_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_04_Reference()
    {
        return $this->Custom_Organization_04_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_04_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference = null)
    {
        $this->Custom_Organization_04_Reference = $custom_Organization_04_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_05_Reference()
    {
        return $this->Custom_Organization_05_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_05_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference = null)
    {
        $this->Custom_Organization_05_Reference = $custom_Organization_05_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_06_Reference()
    {
        return $this->Custom_Organization_06_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_06_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference = null)
    {
        $this->Custom_Organization_06_Reference = $custom_Organization_06_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_07_Reference()
    {
        return $this->Custom_Organization_07_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_07_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference = null)
    {
        $this->Custom_Organization_07_Reference = $custom_Organization_07_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_08_Reference()
    {
        return $this->Custom_Organization_08_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_08_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference = null)
    {
        $this->Custom_Organization_08_Reference = $custom_Organization_08_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_09_Reference()
    {
        return $this->Custom_Organization_09_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_09_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference = null)
    {
        $this->Custom_Organization_09_Reference = $custom_Organization_09_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_10_Reference()
    {
        return $this->Custom_Organization_10_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public function setCustom_Organization_10_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference = null)
    {
        $this->Custom_Organization_10_Reference = $custom_Organization_10_Reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Calculated_Time_Block_DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
