<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Work_Schedule_DataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains each work schedule calendar assignment.
 * @subpackage Structs
 */
class Assign_Work_Schedule_DataType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Worker to whom the work schedule calendar is being assigned.
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Start_Date
     * Meta informations extracted from the WSDL
     * - documentation: Date attribute for the start date of the work schedule calendar assignment.
     * - maxOccurs: 1
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta informations extracted from the WSDL
     * - documentation: Date attribute for the end date of the work schedule calendar assignment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Work_Schedule_Calendar_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Work schedule calendar to be assigned.
     * @var \StructType\Work_Schedule_CalendarObjectType
     */
    public $Work_Schedule_Calendar_Reference;
    /**
     * Constructor method for Assign_Work_Schedule_DataType
     * @uses Assign_Work_Schedule_DataType::setWorker_Reference()
     * @uses Assign_Work_Schedule_DataType::setStart_Date()
     * @uses Assign_Work_Schedule_DataType::setEnd_Date()
     * @uses Assign_Work_Schedule_DataType::setWork_Schedule_Calendar_Reference()
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Work_Schedule_CalendarObjectType $work_Schedule_Calendar_Reference
     */
    public function __construct(\StructType\WorkerObjectType $worker_Reference = null, $start_Date = null, $end_Date = null, \StructType\Work_Schedule_CalendarObjectType $work_Schedule_Calendar_Reference = null)
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setWork_Schedule_Calendar_Reference($work_Schedule_Calendar_Reference);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Assign_Work_Schedule_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Assign_Work_Schedule_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Assign_Work_Schedule_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Work_Schedule_Calendar_Reference value
     * @return \StructType\Work_Schedule_CalendarObjectType|null
     */
    public function getWork_Schedule_Calendar_Reference()
    {
        return $this->Work_Schedule_Calendar_Reference;
    }
    /**
     * Set Work_Schedule_Calendar_Reference value
     * @param \StructType\Work_Schedule_CalendarObjectType $work_Schedule_Calendar_Reference
     * @return \StructType\Assign_Work_Schedule_DataType
     */
    public function setWork_Schedule_Calendar_Reference(\StructType\Work_Schedule_CalendarObjectType $work_Schedule_Calendar_Reference = null)
    {
        $this->Work_Schedule_Calendar_Reference = $work_Schedule_Calendar_Reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Assign_Work_Schedule_DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
