<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ad_Hoc_Schedule_Event_DataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Data related to the Ad Hoc Schedule Event to be processed.
 * @subpackage Structs
 */
class Ad_Hoc_Schedule_Event_DataType extends AbstractStructBase
{
    /**
     * The Ad_Hoc_Schedule_ID
     * Meta informations extracted from the WSDL
     * - documentation: Reference ID to identify the Ad Hoc Schedule Event.
     * - maxOccurs: 1
     * @var string
     */
    public $Ad_Hoc_Schedule_ID;
    /**
     * The Employee_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Worker associated with the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Employee_Reference;
    /**
     * The Position_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Position associated with the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Position_ElementObjectType
     */
    public $Position_Reference;
    /**
     * The Display_Name
     * Meta informations extracted from the WSDL
     * - documentation: Display Name for Ad Hoc Schedule Event when viewed in the UI.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Display_Name;
    /**
     * The Schedule_Start_DateTime
     * Meta informations extracted from the WSDL
     * - documentation: Start date and time of the Ad Hoc Schedule Event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schedule_Start_DateTime;
    /**
     * The Schedule_End_DateTime
     * Meta informations extracted from the WSDL
     * - documentation: End date and time of the Ad Hoc Schedule Event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schedule_End_DateTime;
    /**
     * The Meal_Data
     * Meta informations extracted from the WSDL
     * - documentation: Data related to the meals to be processed.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Ad_Hoc_Schedule_Event_Meal_DataType[]
     */
    public $Meal_Data;
    /**
     * The Time_Type_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Time Type for the Ad Hoc Schedule Event, for use in Time Tracking.
     * - minOccurs: 0
     * @var \StructType\Time_TypeObjectType
     */
    public $Time_Type_Reference;
    /**
     * The Override_Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Override Rate specified by worker. | Override Rate used while reporting time. | Override Rate for the Ad Hoc Schedule Event.
     * - fractionDigits: 6
     * - minInclusive: 0
     * - totalDigits: 10
     * @var float
     */
    public $Override_Rate;
    /**
     * The Business_Unit_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Business Unit for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Business_UnitObjectType
     */
    public $Business_Unit_Reference;
    /**
     * The Cost_Center_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Cost Center for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Cost_Center_Reference;
    /**
     * The Custom_Organization_01_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_01_Reference;
    /**
     * The Custom_Organization_02_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_02_Reference;
    /**
     * The Custom_Organization_03_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_03_Reference;
    /**
     * The Custom_Organization_04_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_04_Reference;
    /**
     * The Custom_Organization_05_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_05_Reference;
    /**
     * The Custom_Organization_06_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_06_Reference;
    /**
     * The Custom_Organization_07_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_07_Reference;
    /**
     * The Custom_Organization_08_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_08_Reference;
    /**
     * The Custom_Organization_09_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_09_Reference;
    /**
     * The Custom_Organization_10_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Organization for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_OrganizationObjectType
     */
    public $Custom_Organization_10_Reference;
    /**
     * The Custom_Worktag_01_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_01ObjectType
     */
    public $Custom_Worktag_01_Reference;
    /**
     * The Custom_Worktag_02_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_02ObjectType
     */
    public $Custom_Worktag_02_Reference;
    /**
     * The Custom_Worktag_03_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_03ObjectType
     */
    public $Custom_Worktag_03_Reference;
    /**
     * The Custom_Worktag_04_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_04ObjectType
     */
    public $Custom_Worktag_04_Reference;
    /**
     * The Custom_Worktag_05_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_05ObjectType
     */
    public $Custom_Worktag_05_Reference;
    /**
     * The Custom_Worktag_06_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_06ObjectType
     */
    public $Custom_Worktag_06_Reference;
    /**
     * The Custom_Worktag_07_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_07ObjectType
     */
    public $Custom_Worktag_07_Reference;
    /**
     * The Custom_Worktag_08_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_08ObjectType
     */
    public $Custom_Worktag_08_Reference;
    /**
     * The Custom_Worktag_09_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_09ObjectType
     */
    public $Custom_Worktag_09_Reference;
    /**
     * The Custom_Worktag_10_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_10ObjectType
     */
    public $Custom_Worktag_10_Reference;
    /**
     * The Custom_Worktag_11_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_11ObjectType
     */
    public $Custom_Worktag_11_Reference;
    /**
     * The Custom_Worktag_12_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_12ObjectType
     */
    public $Custom_Worktag_12_Reference;
    /**
     * The Custom_Worktag_13_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_13ObjectType
     */
    public $Custom_Worktag_13_Reference;
    /**
     * The Custom_Worktag_14_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_14ObjectType
     */
    public $Custom_Worktag_14_Reference;
    /**
     * The Custom_Worktag_15_Reference
     * Meta informations extracted from the WSDL
     * - documentation: A Custom Worktag for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Custom_Worktag_15ObjectType
     */
    public $Custom_Worktag_15_Reference;
    /**
     * The Fund_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Fund for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\FundObjectType
     */
    public $Fund_Reference;
    /**
     * The Gift_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Gift for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\GiftObjectType
     */
    public $Gift_Reference;
    /**
     * The Grant_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Grant for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\GrantObjectType
     */
    public $Grant_Reference;
    /**
     * The Job_Profile_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Job Profile for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType
     */
    public $Job_Profile_Reference;
    /**
     * The Location_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Location for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Program_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Program for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\ProgramObjectType
     */
    public $Program_Reference;
    /**
     * The Region_Reference
     * Meta informations extracted from the WSDL
     * - documentation: Region for the Ad Hoc Schedule Event.
     * - minOccurs: 0
     * @var \StructType\RegionObjectType
     */
    public $Region_Reference;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Comment for the Ad Hoc Schedule Event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Delete
     * Meta informations extracted from the WSDL
     * - documentation: Flag to indicate whether the Ad Hoc Schedule Event should be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Ad_Hoc_Schedule_Event_DataType
     * @uses Ad_Hoc_Schedule_Event_DataType::setAd_Hoc_Schedule_ID()
     * @uses Ad_Hoc_Schedule_Event_DataType::setEmployee_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setPosition_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setDisplay_Name()
     * @uses Ad_Hoc_Schedule_Event_DataType::setSchedule_Start_DateTime()
     * @uses Ad_Hoc_Schedule_Event_DataType::setSchedule_End_DateTime()
     * @uses Ad_Hoc_Schedule_Event_DataType::setMeal_Data()
     * @uses Ad_Hoc_Schedule_Event_DataType::setTime_Type_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setOverride_Rate()
     * @uses Ad_Hoc_Schedule_Event_DataType::setBusiness_Unit_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCost_Center_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_01_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_02_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_03_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_04_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_05_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_06_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_07_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_08_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_09_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Organization_10_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_01_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_02_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_03_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_04_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_05_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_06_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_07_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_08_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_09_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_10_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_11_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_12_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_13_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_14_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setCustom_Worktag_15_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setFund_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setGift_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setGrant_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setJob_Profile_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setLocation_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setProgram_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setRegion_Reference()
     * @uses Ad_Hoc_Schedule_Event_DataType::setComment()
     * @uses Ad_Hoc_Schedule_Event_DataType::setDelete()
     * @param string $ad_Hoc_Schedule_ID
     * @param \StructType\WorkerObjectType $employee_Reference
     * @param \StructType\Position_ElementObjectType $position_Reference
     * @param string $display_Name
     * @param string $schedule_Start_DateTime
     * @param string $schedule_End_DateTime
     * @param \StructType\Ad_Hoc_Schedule_Event_Meal_DataType[] $meal_Data
     * @param \StructType\Time_TypeObjectType $time_Type_Reference
     * @param float $override_Rate
     * @param \StructType\Business_UnitObjectType $business_Unit_Reference
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference
     * @param \StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference
     * @param \StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference
     * @param \StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference
     * @param \StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference
     * @param \StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference
     * @param \StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference
     * @param \StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference
     * @param \StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference
     * @param \StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference
     * @param \StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference
     * @param \StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference
     * @param \StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference
     * @param \StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference
     * @param \StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference
     * @param \StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference
     * @param \StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference
     * @param \StructType\FundObjectType $fund_Reference
     * @param \StructType\GiftObjectType $gift_Reference
     * @param \StructType\GrantObjectType $grant_Reference
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @param \StructType\LocationObjectType $location_Reference
     * @param \StructType\ProgramObjectType $program_Reference
     * @param \StructType\RegionObjectType $region_Reference
     * @param string $comment
     * @param bool $delete
     */
    public function __construct($ad_Hoc_Schedule_ID = null, \StructType\WorkerObjectType $employee_Reference = null, \StructType\Position_ElementObjectType $position_Reference = null, $display_Name = null, $schedule_Start_DateTime = null, $schedule_End_DateTime = null, array $meal_Data = array(), \StructType\Time_TypeObjectType $time_Type_Reference = null, $override_Rate = null, \StructType\Business_UnitObjectType $business_Unit_Reference = null, \StructType\Cost_CenterObjectType $cost_Center_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference = null, \StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference = null, \StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference = null, \StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference = null, \StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference = null, \StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference = null, \StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference = null, \StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference = null, \StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference = null, \StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference = null, \StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference = null, \StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference = null, \StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference = null, \StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference = null, \StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference = null, \StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference = null, \StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference = null, \StructType\FundObjectType $fund_Reference = null, \StructType\GiftObjectType $gift_Reference = null, \StructType\GrantObjectType $grant_Reference = null, \StructType\Job_ProfileObjectType $job_Profile_Reference = null, \StructType\LocationObjectType $location_Reference = null, \StructType\ProgramObjectType $program_Reference = null, \StructType\RegionObjectType $region_Reference = null, $comment = null, $delete = null)
    {
        $this
            ->setAd_Hoc_Schedule_ID($ad_Hoc_Schedule_ID)
            ->setEmployee_Reference($employee_Reference)
            ->setPosition_Reference($position_Reference)
            ->setDisplay_Name($display_Name)
            ->setSchedule_Start_DateTime($schedule_Start_DateTime)
            ->setSchedule_End_DateTime($schedule_End_DateTime)
            ->setMeal_Data($meal_Data)
            ->setTime_Type_Reference($time_Type_Reference)
            ->setOverride_Rate($override_Rate)
            ->setBusiness_Unit_Reference($business_Unit_Reference)
            ->setCost_Center_Reference($cost_Center_Reference)
            ->setCustom_Organization_01_Reference($custom_Organization_01_Reference)
            ->setCustom_Organization_02_Reference($custom_Organization_02_Reference)
            ->setCustom_Organization_03_Reference($custom_Organization_03_Reference)
            ->setCustom_Organization_04_Reference($custom_Organization_04_Reference)
            ->setCustom_Organization_05_Reference($custom_Organization_05_Reference)
            ->setCustom_Organization_06_Reference($custom_Organization_06_Reference)
            ->setCustom_Organization_07_Reference($custom_Organization_07_Reference)
            ->setCustom_Organization_08_Reference($custom_Organization_08_Reference)
            ->setCustom_Organization_09_Reference($custom_Organization_09_Reference)
            ->setCustom_Organization_10_Reference($custom_Organization_10_Reference)
            ->setCustom_Worktag_01_Reference($custom_Worktag_01_Reference)
            ->setCustom_Worktag_02_Reference($custom_Worktag_02_Reference)
            ->setCustom_Worktag_03_Reference($custom_Worktag_03_Reference)
            ->setCustom_Worktag_04_Reference($custom_Worktag_04_Reference)
            ->setCustom_Worktag_05_Reference($custom_Worktag_05_Reference)
            ->setCustom_Worktag_06_Reference($custom_Worktag_06_Reference)
            ->setCustom_Worktag_07_Reference($custom_Worktag_07_Reference)
            ->setCustom_Worktag_08_Reference($custom_Worktag_08_Reference)
            ->setCustom_Worktag_09_Reference($custom_Worktag_09_Reference)
            ->setCustom_Worktag_10_Reference($custom_Worktag_10_Reference)
            ->setCustom_Worktag_11_Reference($custom_Worktag_11_Reference)
            ->setCustom_Worktag_12_Reference($custom_Worktag_12_Reference)
            ->setCustom_Worktag_13_Reference($custom_Worktag_13_Reference)
            ->setCustom_Worktag_14_Reference($custom_Worktag_14_Reference)
            ->setCustom_Worktag_15_Reference($custom_Worktag_15_Reference)
            ->setFund_Reference($fund_Reference)
            ->setGift_Reference($gift_Reference)
            ->setGrant_Reference($grant_Reference)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setLocation_Reference($location_Reference)
            ->setProgram_Reference($program_Reference)
            ->setRegion_Reference($region_Reference)
            ->setComment($comment)
            ->setDelete($delete);
    }
    /**
     * Get Ad_Hoc_Schedule_ID value
     * @return string|null
     */
    public function getAd_Hoc_Schedule_ID()
    {
        return $this->Ad_Hoc_Schedule_ID;
    }
    /**
     * Set Ad_Hoc_Schedule_ID value
     * @param string $ad_Hoc_Schedule_ID
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setAd_Hoc_Schedule_ID($ad_Hoc_Schedule_ID = null)
    {
        // validation for constraint: string
        if (!is_null($ad_Hoc_Schedule_ID) && !is_string($ad_Hoc_Schedule_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ad_Hoc_Schedule_ID)), __LINE__);
        }
        $this->Ad_Hoc_Schedule_ID = $ad_Hoc_Schedule_ID;
        return $this;
    }
    /**
     * Get Employee_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getEmployee_Reference()
    {
        return $this->Employee_Reference;
    }
    /**
     * Set Employee_Reference value
     * @param \StructType\WorkerObjectType $employee_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setEmployee_Reference(\StructType\WorkerObjectType $employee_Reference = null)
    {
        $this->Employee_Reference = $employee_Reference;
        return $this;
    }
    /**
     * Get Position_Reference value
     * @return \StructType\Position_ElementObjectType|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * Set Position_Reference value
     * @param \StructType\Position_ElementObjectType $position_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setPosition_Reference(\StructType\Position_ElementObjectType $position_Reference = null)
    {
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Get Display_Name value
     * @return string|null
     */
    public function getDisplay_Name()
    {
        return $this->Display_Name;
    }
    /**
     * Set Display_Name value
     * @param string $display_Name
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setDisplay_Name($display_Name = null)
    {
        // validation for constraint: string
        if (!is_null($display_Name) && !is_string($display_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($display_Name)), __LINE__);
        }
        $this->Display_Name = $display_Name;
        return $this;
    }
    /**
     * Get Schedule_Start_DateTime value
     * @return string|null
     */
    public function getSchedule_Start_DateTime()
    {
        return $this->Schedule_Start_DateTime;
    }
    /**
     * Set Schedule_Start_DateTime value
     * @param string $schedule_Start_DateTime
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setSchedule_Start_DateTime($schedule_Start_DateTime = null)
    {
        // validation for constraint: string
        if (!is_null($schedule_Start_DateTime) && !is_string($schedule_Start_DateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schedule_Start_DateTime)), __LINE__);
        }
        $this->Schedule_Start_DateTime = $schedule_Start_DateTime;
        return $this;
    }
    /**
     * Get Schedule_End_DateTime value
     * @return string|null
     */
    public function getSchedule_End_DateTime()
    {
        return $this->Schedule_End_DateTime;
    }
    /**
     * Set Schedule_End_DateTime value
     * @param string $schedule_End_DateTime
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setSchedule_End_DateTime($schedule_End_DateTime = null)
    {
        // validation for constraint: string
        if (!is_null($schedule_End_DateTime) && !is_string($schedule_End_DateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schedule_End_DateTime)), __LINE__);
        }
        $this->Schedule_End_DateTime = $schedule_End_DateTime;
        return $this;
    }
    /**
     * Get Meal_Data value
     * @return \StructType\Ad_Hoc_Schedule_Event_Meal_DataType[]|null
     */
    public function getMeal_Data()
    {
        return $this->Meal_Data;
    }
    /**
     * Set Meal_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Ad_Hoc_Schedule_Event_Meal_DataType[] $meal_Data
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setMeal_Data(array $meal_Data = array())
    {
        foreach ($meal_Data as $ad_Hoc_Schedule_Event_DataTypeMeal_DataItem) {
            // validation for constraint: itemType
            if (!$ad_Hoc_Schedule_Event_DataTypeMeal_DataItem instanceof \StructType\Ad_Hoc_Schedule_Event_Meal_DataType) {
                throw new \InvalidArgumentException(sprintf('The Meal_Data property can only contain items of \StructType\Ad_Hoc_Schedule_Event_Meal_DataType, "%s" given', is_object($ad_Hoc_Schedule_Event_DataTypeMeal_DataItem) ? get_class($ad_Hoc_Schedule_Event_DataTypeMeal_DataItem) : gettype($ad_Hoc_Schedule_Event_DataTypeMeal_DataItem)), __LINE__);
            }
        }
        $this->Meal_Data = $meal_Data;
        return $this;
    }
    /**
     * Add item to Meal_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Ad_Hoc_Schedule_Event_Meal_DataType $item
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function addToMeal_Data(\StructType\Ad_Hoc_Schedule_Event_Meal_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ad_Hoc_Schedule_Event_Meal_DataType) {
            throw new \InvalidArgumentException(sprintf('The Meal_Data property can only contain items of \StructType\Ad_Hoc_Schedule_Event_Meal_DataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Meal_Data[] = $item;
        return $this;
    }
    /**
     * Get Time_Type_Reference value
     * @return \StructType\Time_TypeObjectType|null
     */
    public function getTime_Type_Reference()
    {
        return $this->Time_Type_Reference;
    }
    /**
     * Set Time_Type_Reference value
     * @param \StructType\Time_TypeObjectType $time_Type_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setTime_Type_Reference(\StructType\Time_TypeObjectType $time_Type_Reference = null)
    {
        $this->Time_Type_Reference = $time_Type_Reference;
        return $this;
    }
    /**
     * Get Override_Rate value
     * @return float|null
     */
    public function getOverride_Rate()
    {
        return $this->Override_Rate;
    }
    /**
     * Set Override_Rate value
     * @param float $override_Rate
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setOverride_Rate($override_Rate = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($override_Rate) && strlen(substr($override_Rate, strpos($override_Rate, '.') + 1)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 fraction digits, "%d" given', strlen(substr($override_Rate, strpos($override_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($override_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $override_Rate), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($override_Rate) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $override_Rate)) !== 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 10 digits, "%d" given', strlen(substr($override_Rate, strpos($override_Rate, '.')))), __LINE__);
        }
        $this->Override_Rate = $override_Rate;
        return $this;
    }
    /**
     * Get Business_Unit_Reference value
     * @return \StructType\Business_UnitObjectType|null
     */
    public function getBusiness_Unit_Reference()
    {
        return $this->Business_Unit_Reference;
    }
    /**
     * Set Business_Unit_Reference value
     * @param \StructType\Business_UnitObjectType $business_Unit_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setBusiness_Unit_Reference(\StructType\Business_UnitObjectType $business_Unit_Reference = null)
    {
        $this->Business_Unit_Reference = $business_Unit_Reference;
        return $this;
    }
    /**
     * Get Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCost_Center_Reference()
    {
        return $this->Cost_Center_Reference;
    }
    /**
     * Set Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCost_Center_Reference(\StructType\Cost_CenterObjectType $cost_Center_Reference = null)
    {
        $this->Cost_Center_Reference = $cost_Center_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_01_Reference()
    {
        return $this->Custom_Organization_01_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_01_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_01_Reference = null)
    {
        $this->Custom_Organization_01_Reference = $custom_Organization_01_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_02_Reference()
    {
        return $this->Custom_Organization_02_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_02_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_02_Reference = null)
    {
        $this->Custom_Organization_02_Reference = $custom_Organization_02_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_03_Reference()
    {
        return $this->Custom_Organization_03_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_03_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_03_Reference = null)
    {
        $this->Custom_Organization_03_Reference = $custom_Organization_03_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_04_Reference()
    {
        return $this->Custom_Organization_04_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_04_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_04_Reference = null)
    {
        $this->Custom_Organization_04_Reference = $custom_Organization_04_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_05_Reference()
    {
        return $this->Custom_Organization_05_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_05_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_05_Reference = null)
    {
        $this->Custom_Organization_05_Reference = $custom_Organization_05_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_06_Reference()
    {
        return $this->Custom_Organization_06_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_06_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_06_Reference = null)
    {
        $this->Custom_Organization_06_Reference = $custom_Organization_06_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_07_Reference()
    {
        return $this->Custom_Organization_07_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_07_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_07_Reference = null)
    {
        $this->Custom_Organization_07_Reference = $custom_Organization_07_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_08_Reference()
    {
        return $this->Custom_Organization_08_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_08_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_08_Reference = null)
    {
        $this->Custom_Organization_08_Reference = $custom_Organization_08_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_09_Reference()
    {
        return $this->Custom_Organization_09_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_09_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_09_Reference = null)
    {
        $this->Custom_Organization_09_Reference = $custom_Organization_09_Reference;
        return $this;
    }
    /**
     * Get custom_Organization_Reference value
     * @return custom_Organization_Reference
     */
    public function getCustom_Organization_10_Reference()
    {
        return $this->Custom_Organization_10_Reference;
    }
    /**
     * Set custom_Organization_Reference value
     * @param custom_Organization_Reference $custom_Organization_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Organization_10_Reference(\StructType\Custom_OrganizationObjectType $custom_Organization_10_Reference = null)
    {
        $this->Custom_Organization_10_Reference = $custom_Organization_10_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_01_Reference()
    {
        return $this->Custom_Worktag_01_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_01_Reference(\StructType\Custom_Worktag_01ObjectType $custom_Worktag_01_Reference = null)
    {
        $this->Custom_Worktag_01_Reference = $custom_Worktag_01_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_02_Reference()
    {
        return $this->Custom_Worktag_02_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_02_Reference(\StructType\Custom_Worktag_02ObjectType $custom_Worktag_02_Reference = null)
    {
        $this->Custom_Worktag_02_Reference = $custom_Worktag_02_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_03_Reference()
    {
        return $this->Custom_Worktag_03_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_03_Reference(\StructType\Custom_Worktag_03ObjectType $custom_Worktag_03_Reference = null)
    {
        $this->Custom_Worktag_03_Reference = $custom_Worktag_03_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_04_Reference()
    {
        return $this->Custom_Worktag_04_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_04_Reference(\StructType\Custom_Worktag_04ObjectType $custom_Worktag_04_Reference = null)
    {
        $this->Custom_Worktag_04_Reference = $custom_Worktag_04_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_05_Reference()
    {
        return $this->Custom_Worktag_05_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_05_Reference(\StructType\Custom_Worktag_05ObjectType $custom_Worktag_05_Reference = null)
    {
        $this->Custom_Worktag_05_Reference = $custom_Worktag_05_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_06_Reference()
    {
        return $this->Custom_Worktag_06_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_06_Reference(\StructType\Custom_Worktag_06ObjectType $custom_Worktag_06_Reference = null)
    {
        $this->Custom_Worktag_06_Reference = $custom_Worktag_06_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_07_Reference()
    {
        return $this->Custom_Worktag_07_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_07_Reference(\StructType\Custom_Worktag_07ObjectType $custom_Worktag_07_Reference = null)
    {
        $this->Custom_Worktag_07_Reference = $custom_Worktag_07_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_08_Reference()
    {
        return $this->Custom_Worktag_08_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_08_Reference(\StructType\Custom_Worktag_08ObjectType $custom_Worktag_08_Reference = null)
    {
        $this->Custom_Worktag_08_Reference = $custom_Worktag_08_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_09_Reference()
    {
        return $this->Custom_Worktag_09_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_09_Reference(\StructType\Custom_Worktag_09ObjectType $custom_Worktag_09_Reference = null)
    {
        $this->Custom_Worktag_09_Reference = $custom_Worktag_09_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_10_Reference()
    {
        return $this->Custom_Worktag_10_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_10_Reference(\StructType\Custom_Worktag_10ObjectType $custom_Worktag_10_Reference = null)
    {
        $this->Custom_Worktag_10_Reference = $custom_Worktag_10_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_11_Reference()
    {
        return $this->Custom_Worktag_11_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_11_Reference(\StructType\Custom_Worktag_11ObjectType $custom_Worktag_11_Reference = null)
    {
        $this->Custom_Worktag_11_Reference = $custom_Worktag_11_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_12_Reference()
    {
        return $this->Custom_Worktag_12_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_12_Reference(\StructType\Custom_Worktag_12ObjectType $custom_Worktag_12_Reference = null)
    {
        $this->Custom_Worktag_12_Reference = $custom_Worktag_12_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_13_Reference()
    {
        return $this->Custom_Worktag_13_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_13_Reference(\StructType\Custom_Worktag_13ObjectType $custom_Worktag_13_Reference = null)
    {
        $this->Custom_Worktag_13_Reference = $custom_Worktag_13_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_14_Reference()
    {
        return $this->Custom_Worktag_14_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_14_Reference(\StructType\Custom_Worktag_14ObjectType $custom_Worktag_14_Reference = null)
    {
        $this->Custom_Worktag_14_Reference = $custom_Worktag_14_Reference;
        return $this;
    }
    /**
     * Get custom_Worktag_Reference value
     * @return custom_Worktag_Reference
     */
    public function getCustom_Worktag_15_Reference()
    {
        return $this->Custom_Worktag_15_Reference;
    }
    /**
     * Set custom_Worktag_Reference value
     * @param custom_Worktag_Reference $custom_Worktag_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setCustom_Worktag_15_Reference(\StructType\Custom_Worktag_15ObjectType $custom_Worktag_15_Reference = null)
    {
        $this->Custom_Worktag_15_Reference = $custom_Worktag_15_Reference;
        return $this;
    }
    /**
     * Get Fund_Reference value
     * @return \StructType\FundObjectType|null
     */
    public function getFund_Reference()
    {
        return $this->Fund_Reference;
    }
    /**
     * Set Fund_Reference value
     * @param \StructType\FundObjectType $fund_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setFund_Reference(\StructType\FundObjectType $fund_Reference = null)
    {
        $this->Fund_Reference = $fund_Reference;
        return $this;
    }
    /**
     * Get Gift_Reference value
     * @return \StructType\GiftObjectType|null
     */
    public function getGift_Reference()
    {
        return $this->Gift_Reference;
    }
    /**
     * Set Gift_Reference value
     * @param \StructType\GiftObjectType $gift_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setGift_Reference(\StructType\GiftObjectType $gift_Reference = null)
    {
        $this->Gift_Reference = $gift_Reference;
        return $this;
    }
    /**
     * Get Grant_Reference value
     * @return \StructType\GrantObjectType|null
     */
    public function getGrant_Reference()
    {
        return $this->Grant_Reference;
    }
    /**
     * Set Grant_Reference value
     * @param \StructType\GrantObjectType $grant_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setGrant_Reference(\StructType\GrantObjectType $grant_Reference = null)
    {
        $this->Grant_Reference = $grant_Reference;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * Set Job_Profile_Reference value
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setJob_Profile_Reference(\StructType\Job_ProfileObjectType $job_Profile_Reference = null)
    {
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Program_Reference value
     * @return \StructType\ProgramObjectType|null
     */
    public function getProgram_Reference()
    {
        return $this->Program_Reference;
    }
    /**
     * Set Program_Reference value
     * @param \StructType\ProgramObjectType $program_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setProgram_Reference(\StructType\ProgramObjectType $program_Reference = null)
    {
        $this->Program_Reference = $program_Reference;
        return $this;
    }
    /**
     * Get Region_Reference value
     * @return \StructType\RegionObjectType|null
     */
    public function getRegion_Reference()
    {
        return $this->Region_Reference;
    }
    /**
     * Set Region_Reference value
     * @param \StructType\RegionObjectType $region_Reference
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setRegion_Reference(\StructType\RegionObjectType $region_Reference = null)
    {
        $this->Region_Reference = $region_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ad_Hoc_Schedule_Event_DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
