<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsortiMiktar StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AsortiMiktar
 * @subpackage Structs
 */
class AsortiMiktar extends AbstractStructBase
{
    /**
     * The Adet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Adet;
    /**
     * The EkSecenekTanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EkSecenekTanim;
    /**
     * The GrupID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GrupID;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * Constructor method for AsortiMiktar
     * @uses AsortiMiktar::setAdet()
     * @uses AsortiMiktar::setEkSecenekTanim()
     * @uses AsortiMiktar::setGrupID()
     * @uses AsortiMiktar::setID()
     * @param int $adet
     * @param string $ekSecenekTanim
     * @param int $grupID
     * @param int $iD
     */
    public function __construct($adet = null, $ekSecenekTanim = null, $grupID = null, $iD = null)
    {
        $this
            ->setAdet($adet)
            ->setEkSecenekTanim($ekSecenekTanim)
            ->setGrupID($grupID)
            ->setID($iD);
    }
    /**
     * Get Adet value
     * @return int|null
     */
    public function getAdet()
    {
        return $this->Adet;
    }
    /**
     * Set Adet value
     * @param int $adet
     * @return \StructType\AsortiMiktar
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: int
        if (!is_null($adet) && !is_numeric($adet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adet)), __LINE__);
        }
        $this->Adet = $adet;
        return $this;
    }
    /**
     * Get EkSecenekTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEkSecenekTanim()
    {
        return isset($this->EkSecenekTanim) ? $this->EkSecenekTanim : null;
    }
    /**
     * Set EkSecenekTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ekSecenekTanim
     * @return \StructType\AsortiMiktar
     */
    public function setEkSecenekTanim($ekSecenekTanim = null)
    {
        // validation for constraint: string
        if (!is_null($ekSecenekTanim) && !is_string($ekSecenekTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ekSecenekTanim)), __LINE__);
        }
        if (is_null($ekSecenekTanim) || (is_array($ekSecenekTanim) && empty($ekSecenekTanim))) {
            unset($this->EkSecenekTanim);
        } else {
            $this->EkSecenekTanim = $ekSecenekTanim;
        }
        return $this;
    }
    /**
     * Get GrupID value
     * @return int|null
     */
    public function getGrupID()
    {
        return $this->GrupID;
    }
    /**
     * Set GrupID value
     * @param int $grupID
     * @return \StructType\AsortiMiktar
     */
    public function setGrupID($grupID = null)
    {
        // validation for constraint: int
        if (!is_null($grupID) && !is_numeric($grupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($grupID)), __LINE__);
        }
        $this->GrupID = $grupID;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\AsortiMiktar
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AsortiMiktar
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
