<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUrlRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateUrlRequest
 * @subpackage Structs
 */
class UpdateUrlRequest extends AbstractStructBase
{
    /**
     * The Dil
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Dil;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Tip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tip;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for UpdateUrlRequest
     * @uses UpdateUrlRequest::setDil()
     * @uses UpdateUrlRequest::setID()
     * @uses UpdateUrlRequest::setTip()
     * @uses UpdateUrlRequest::setUrl()
     * @param string $dil
     * @param int $iD
     * @param string $tip
     * @param string $url
     */
    public function __construct($dil = null, $iD = null, $tip = null, $url = null)
    {
        $this
            ->setDil($dil)
            ->setID($iD)
            ->setTip($tip)
            ->setUrl($url);
    }
    /**
     * Get Dil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDil()
    {
        return isset($this->Dil) ? $this->Dil : null;
    }
    /**
     * Set Dil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dil
     * @return \StructType\UpdateUrlRequest
     */
    public function setDil($dil = null)
    {
        // validation for constraint: string
        if (!is_null($dil) && !is_string($dil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dil)), __LINE__);
        }
        if (is_null($dil) || (is_array($dil) && empty($dil))) {
            unset($this->Dil);
        } else {
            $this->Dil = $dil;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\UpdateUrlRequest
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Tip value
     * @return string|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @uses \EnumType\UrlType::valueIsValid()
     * @uses \EnumType\UrlType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tip
     * @return \StructType\UpdateUrlRequest
     */
    public function setTip($tip = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UrlType::valueIsValid($tip)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tip, implode(', ', \EnumType\UrlType::getValidValues())), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\UpdateUrlRequest
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateUrlRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
