<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marka StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Marka
 * @subpackage Structs
 */
class Marka extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The SeoAnahtarKelime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoAnahtarKelime;
    /**
     * The SeoSayfaAciklama
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoSayfaAciklama;
    /**
     * The SeoSayfaBaslik
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoSayfaBaslik;
    /**
     * The Tanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * Constructor method for Marka
     * @uses Marka::setAktif()
     * @uses Marka::setID()
     * @uses Marka::setSeoAnahtarKelime()
     * @uses Marka::setSeoSayfaAciklama()
     * @uses Marka::setSeoSayfaBaslik()
     * @uses Marka::setTanim()
     * @param bool $aktif
     * @param int $iD
     * @param string $seoAnahtarKelime
     * @param string $seoSayfaAciklama
     * @param string $seoSayfaBaslik
     * @param string $tanim
     */
    public function __construct($aktif = null, $iD = null, $seoAnahtarKelime = null, $seoSayfaAciklama = null, $seoSayfaBaslik = null, $tanim = null)
    {
        $this
            ->setAktif($aktif)
            ->setID($iD)
            ->setSeoAnahtarKelime($seoAnahtarKelime)
            ->setSeoSayfaAciklama($seoSayfaAciklama)
            ->setSeoSayfaBaslik($seoSayfaBaslik)
            ->setTanim($tanim);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\Marka
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Marka
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get SeoAnahtarKelime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoAnahtarKelime()
    {
        return isset($this->SeoAnahtarKelime) ? $this->SeoAnahtarKelime : null;
    }
    /**
     * Set SeoAnahtarKelime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoAnahtarKelime
     * @return \StructType\Marka
     */
    public function setSeoAnahtarKelime($seoAnahtarKelime = null)
    {
        // validation for constraint: string
        if (!is_null($seoAnahtarKelime) && !is_string($seoAnahtarKelime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seoAnahtarKelime)), __LINE__);
        }
        if (is_null($seoAnahtarKelime) || (is_array($seoAnahtarKelime) && empty($seoAnahtarKelime))) {
            unset($this->SeoAnahtarKelime);
        } else {
            $this->SeoAnahtarKelime = $seoAnahtarKelime;
        }
        return $this;
    }
    /**
     * Get SeoSayfaAciklama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoSayfaAciklama()
    {
        return isset($this->SeoSayfaAciklama) ? $this->SeoSayfaAciklama : null;
    }
    /**
     * Set SeoSayfaAciklama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoSayfaAciklama
     * @return \StructType\Marka
     */
    public function setSeoSayfaAciklama($seoSayfaAciklama = null)
    {
        // validation for constraint: string
        if (!is_null($seoSayfaAciklama) && !is_string($seoSayfaAciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seoSayfaAciklama)), __LINE__);
        }
        if (is_null($seoSayfaAciklama) || (is_array($seoSayfaAciklama) && empty($seoSayfaAciklama))) {
            unset($this->SeoSayfaAciklama);
        } else {
            $this->SeoSayfaAciklama = $seoSayfaAciklama;
        }
        return $this;
    }
    /**
     * Get SeoSayfaBaslik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoSayfaBaslik()
    {
        return isset($this->SeoSayfaBaslik) ? $this->SeoSayfaBaslik : null;
    }
    /**
     * Set SeoSayfaBaslik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoSayfaBaslik
     * @return \StructType\Marka
     */
    public function setSeoSayfaBaslik($seoSayfaBaslik = null)
    {
        // validation for constraint: string
        if (!is_null($seoSayfaBaslik) && !is_string($seoSayfaBaslik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seoSayfaBaslik)), __LINE__);
        }
        if (is_null($seoSayfaBaslik) || (is_array($seoSayfaBaslik) && empty($seoSayfaBaslik))) {
            unset($this->SeoSayfaBaslik);
        } else {
            $this->SeoSayfaBaslik = $seoSayfaBaslik;
        }
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\Marka
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Marka
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
