<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kategori StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Kategori
 * @subpackage Structs
 */
class Kategori extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Icerik
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Icerik;
    /**
     * The KategoriMenuGoster
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KategoriMenuGoster;
    /**
     * The Kod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kod;
    /**
     * The PID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PID;
    /**
     * The SeoAnahtarKelime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoAnahtarKelime;
    /**
     * The SeoSayfaAciklama
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoSayfaAciklama;
    /**
     * The SeoSayfaBaslik
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoSayfaBaslik;
    /**
     * The Sira
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sira;
    /**
     * The Tanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for Kategori
     * @uses Kategori::setAktif()
     * @uses Kategori::setID()
     * @uses Kategori::setIcerik()
     * @uses Kategori::setKategoriMenuGoster()
     * @uses Kategori::setKod()
     * @uses Kategori::setPID()
     * @uses Kategori::setSeoAnahtarKelime()
     * @uses Kategori::setSeoSayfaAciklama()
     * @uses Kategori::setSeoSayfaBaslik()
     * @uses Kategori::setSira()
     * @uses Kategori::setTanim()
     * @uses Kategori::setUrl()
     * @param bool $aktif
     * @param int $iD
     * @param string $icerik
     * @param bool $kategoriMenuGoster
     * @param string $kod
     * @param int $pID
     * @param string $seoAnahtarKelime
     * @param string $seoSayfaAciklama
     * @param string $seoSayfaBaslik
     * @param int $sira
     * @param string $tanim
     * @param string $url
     */
    public function __construct($aktif = null, $iD = null, $icerik = null, $kategoriMenuGoster = null, $kod = null, $pID = null, $seoAnahtarKelime = null, $seoSayfaAciklama = null, $seoSayfaBaslik = null, $sira = null, $tanim = null, $url = null)
    {
        $this
            ->setAktif($aktif)
            ->setID($iD)
            ->setIcerik($icerik)
            ->setKategoriMenuGoster($kategoriMenuGoster)
            ->setKod($kod)
            ->setPID($pID)
            ->setSeoAnahtarKelime($seoAnahtarKelime)
            ->setSeoSayfaAciklama($seoSayfaAciklama)
            ->setSeoSayfaBaslik($seoSayfaBaslik)
            ->setSira($sira)
            ->setTanim($tanim)
            ->setUrl($url);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\Kategori
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Kategori
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Icerik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIcerik()
    {
        return isset($this->Icerik) ? $this->Icerik : null;
    }
    /**
     * Set Icerik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $icerik
     * @return \StructType\Kategori
     */
    public function setIcerik($icerik = null)
    {
        // validation for constraint: string
        if (!is_null($icerik) && !is_string($icerik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icerik)), __LINE__);
        }
        if (is_null($icerik) || (is_array($icerik) && empty($icerik))) {
            unset($this->Icerik);
        } else {
            $this->Icerik = $icerik;
        }
        return $this;
    }
    /**
     * Get KategoriMenuGoster value
     * @return bool|null
     */
    public function getKategoriMenuGoster()
    {
        return $this->KategoriMenuGoster;
    }
    /**
     * Set KategoriMenuGoster value
     * @param bool $kategoriMenuGoster
     * @return \StructType\Kategori
     */
    public function setKategoriMenuGoster($kategoriMenuGoster = null)
    {
        // validation for constraint: boolean
        if (!is_null($kategoriMenuGoster) && !is_bool($kategoriMenuGoster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($kategoriMenuGoster)), __LINE__);
        }
        $this->KategoriMenuGoster = $kategoriMenuGoster;
        return $this;
    }
    /**
     * Get Kod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKod()
    {
        return isset($this->Kod) ? $this->Kod : null;
    }
    /**
     * Set Kod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kod
     * @return \StructType\Kategori
     */
    public function setKod($kod = null)
    {
        // validation for constraint: string
        if (!is_null($kod) && !is_string($kod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kod)), __LINE__);
        }
        if (is_null($kod) || (is_array($kod) && empty($kod))) {
            unset($this->Kod);
        } else {
            $this->Kod = $kod;
        }
        return $this;
    }
    /**
     * Get PID value
     * @return int|null
     */
    public function getPID()
    {
        return $this->PID;
    }
    /**
     * Set PID value
     * @param int $pID
     * @return \StructType\Kategori
     */
    public function setPID($pID = null)
    {
        // validation for constraint: int
        if (!is_null($pID) && !is_numeric($pID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pID)), __LINE__);
        }
        $this->PID = $pID;
        return $this;
    }
    /**
     * Get SeoAnahtarKelime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoAnahtarKelime()
    {
        return isset($this->SeoAnahtarKelime) ? $this->SeoAnahtarKelime : null;
    }
    /**
     * Set SeoAnahtarKelime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoAnahtarKelime
     * @return \StructType\Kategori
     */
    public function setSeoAnahtarKelime($seoAnahtarKelime = null)
    {
        // validation for constraint: string
        if (!is_null($seoAnahtarKelime) && !is_string($seoAnahtarKelime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seoAnahtarKelime)), __LINE__);
        }
        if (is_null($seoAnahtarKelime) || (is_array($seoAnahtarKelime) && empty($seoAnahtarKelime))) {
            unset($this->SeoAnahtarKelime);
        } else {
            $this->SeoAnahtarKelime = $seoAnahtarKelime;
        }
        return $this;
    }
    /**
     * Get SeoSayfaAciklama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoSayfaAciklama()
    {
        return isset($this->SeoSayfaAciklama) ? $this->SeoSayfaAciklama : null;
    }
    /**
     * Set SeoSayfaAciklama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoSayfaAciklama
     * @return \StructType\Kategori
     */
    public function setSeoSayfaAciklama($seoSayfaAciklama = null)
    {
        // validation for constraint: string
        if (!is_null($seoSayfaAciklama) && !is_string($seoSayfaAciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seoSayfaAciklama)), __LINE__);
        }
        if (is_null($seoSayfaAciklama) || (is_array($seoSayfaAciklama) && empty($seoSayfaAciklama))) {
            unset($this->SeoSayfaAciklama);
        } else {
            $this->SeoSayfaAciklama = $seoSayfaAciklama;
        }
        return $this;
    }
    /**
     * Get SeoSayfaBaslik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoSayfaBaslik()
    {
        return isset($this->SeoSayfaBaslik) ? $this->SeoSayfaBaslik : null;
    }
    /**
     * Set SeoSayfaBaslik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoSayfaBaslik
     * @return \StructType\Kategori
     */
    public function setSeoSayfaBaslik($seoSayfaBaslik = null)
    {
        // validation for constraint: string
        if (!is_null($seoSayfaBaslik) && !is_string($seoSayfaBaslik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seoSayfaBaslik)), __LINE__);
        }
        if (is_null($seoSayfaBaslik) || (is_array($seoSayfaBaslik) && empty($seoSayfaBaslik))) {
            unset($this->SeoSayfaBaslik);
        } else {
            $this->SeoSayfaBaslik = $seoSayfaBaslik;
        }
        return $this;
    }
    /**
     * Get Sira value
     * @return int|null
     */
    public function getSira()
    {
        return $this->Sira;
    }
    /**
     * Set Sira value
     * @param int $sira
     * @return \StructType\Kategori
     */
    public function setSira($sira = null)
    {
        // validation for constraint: int
        if (!is_null($sira) && !is_numeric($sira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sira)), __LINE__);
        }
        $this->Sira = $sira;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\Kategori
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\Kategori
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Kategori
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
