<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BLPaketlemeDurum StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BLPaketlemeDurum
 * @subpackage Structs
 */
class BLPaketlemeDurum extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Islem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Islem;
    /**
     * The Tanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * Constructor method for BLPaketlemeDurum
     * @uses BLPaketlemeDurum::setAktif()
     * @uses BLPaketlemeDurum::setId()
     * @uses BLPaketlemeDurum::setIslem()
     * @uses BLPaketlemeDurum::setTanim()
     * @param bool $aktif
     * @param int $id
     * @param int $islem
     * @param string $tanim
     */
    public function __construct($aktif = null, $id = null, $islem = null, $tanim = null)
    {
        $this
            ->setAktif($aktif)
            ->setId($id)
            ->setIslem($islem)
            ->setTanim($tanim);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\BLPaketlemeDurum
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\BLPaketlemeDurum
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Islem value
     * @return int|null
     */
    public function getIslem()
    {
        return $this->Islem;
    }
    /**
     * Set Islem value
     * @param int $islem
     * @return \StructType\BLPaketlemeDurum
     */
    public function setIslem($islem = null)
    {
        // validation for constraint: int
        if (!is_null($islem) && !(is_int($islem) || ctype_digit($islem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($islem, true), gettype($islem)), __LINE__);
        }
        $this->Islem = $islem;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\BLPaketlemeDurum
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
}
