<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebSiparisKampanya StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebSiparisKampanya
 * @subpackage Structs
 */
class WebSiparisKampanya extends AbstractStructBase
{
    /**
     * The KampanyaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KampanyaID;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The UrunID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunID;
    /**
     * Constructor method for WebSiparisKampanya
     * @uses WebSiparisKampanya::setKampanyaID()
     * @uses WebSiparisKampanya::setSiparisID()
     * @uses WebSiparisKampanya::setUrunID()
     * @param int $kampanyaID
     * @param int $siparisID
     * @param int $urunID
     */
    public function __construct($kampanyaID = null, $siparisID = null, $urunID = null)
    {
        $this
            ->setKampanyaID($kampanyaID)
            ->setSiparisID($siparisID)
            ->setUrunID($urunID);
    }
    /**
     * Get KampanyaID value
     * @return int|null
     */
    public function getKampanyaID()
    {
        return $this->KampanyaID;
    }
    /**
     * Set KampanyaID value
     * @param int $kampanyaID
     * @return \StructType\WebSiparisKampanya
     */
    public function setKampanyaID($kampanyaID = null)
    {
        // validation for constraint: int
        if (!is_null($kampanyaID) && !(is_int($kampanyaID) || ctype_digit($kampanyaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kampanyaID, true), gettype($kampanyaID)), __LINE__);
        }
        $this->KampanyaID = $kampanyaID;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\WebSiparisKampanya
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get UrunID value
     * @return int|null
     */
    public function getUrunID()
    {
        return $this->UrunID;
    }
    /**
     * Set UrunID value
     * @param int $urunID
     * @return \StructType\WebSiparisKampanya
     */
    public function setUrunID($urunID = null)
    {
        // validation for constraint: int
        if (!is_null($urunID) && !(is_int($urunID) || ctype_digit($urunID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunID, true), gettype($urunID)), __LINE__);
        }
        $this->UrunID = $urunID;
        return $this;
    }
}
