<?php

namespace EnumType;

/**
 * This class stands for EFaturaTuru EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EFaturaTuru
 * @subpackage Enumerations
 */
class EFaturaTuru
{
    /**
     * Constant for value 'Satis'
     * @return string 'Satis'
     */
    const VALUE_SATIS = 'Satis';
    /**
     * Constant for value 'Iptal'
     * @return string 'Iptal'
     */
    const VALUE_IPTAL = 'Iptal';
    /**
     * Constant for value 'Iade'
     * @return string 'Iade'
     */
    const VALUE_IADE = 'Iade';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SATIS
     * @uses self::VALUE_IPTAL
     * @uses self::VALUE_IADE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SATIS,
            self::VALUE_IPTAL,
            self::VALUE_IADE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
