<?php

namespace EnumType;

/**
 * This class stands for WebMusteriHizmetleriTip EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebMusteriHizmetleriTip
 * @subpackage Enumerations
 */
class WebMusteriHizmetleriTip
{
    /**
     * Constant for value 'KapidaOdemeOnayiBekleyenSiparisler'
     * @return string 'KapidaOdemeOnayiBekleyenSiparisler'
     */
    const VALUE_KAPIDA_ODEME_ONAYI_BEKLEYEN_SIPARISLER = 'KapidaOdemeOnayiBekleyenSiparisler';
    /**
     * Constant for value 'EksikUrunBekleyenSiparisler'
     * @return string 'EksikUrunBekleyenSiparisler'
     */
    const VALUE_EKSIK_URUN_BEKLEYEN_SIPARISLER = 'EksikUrunBekleyenSiparisler';
    /**
     * Constant for value 'IbanBekleyenSiparisler'
     * @return string 'IbanBekleyenSiparisler'
     */
    const VALUE_IBAN_BEKLEYEN_SIPARISLER = 'IbanBekleyenSiparisler';
    /**
     * Constant for value 'IadeAramasiBekleyen'
     * @return string 'IadeAramasiBekleyen'
     */
    const VALUE_IADE_ARAMASI_BEKLEYEN = 'IadeAramasiBekleyen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KAPIDA_ODEME_ONAYI_BEKLEYEN_SIPARISLER
     * @uses self::VALUE_EKSIK_URUN_BEKLEYEN_SIPARISLER
     * @uses self::VALUE_IBAN_BEKLEYEN_SIPARISLER
     * @uses self::VALUE_IADE_ARAMASI_BEKLEYEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KAPIDA_ODEME_ONAYI_BEKLEYEN_SIPARISLER,
            self::VALUE_EKSIK_URUN_BEKLEYEN_SIPARISLER,
            self::VALUE_IBAN_BEKLEYEN_SIPARISLER,
            self::VALUE_IADE_ARAMASI_BEKLEYEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
