<?php

namespace EnumType;

/**
 * This class stands for OdemeIadeIslemTip EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OdemeIadeIslemTip
 * @subpackage Enumerations
 */
class OdemeIadeIslemTip
{
    /**
     * Constant for value 'Hepsi'
     * @return string 'Hepsi'
     */
    const VALUE_HEPSI = 'Hepsi';
    /**
     * Constant for value 'IptalEdilmis'
     * @return string 'IptalEdilmis'
     */
    const VALUE_IPTAL_EDILMIS = 'IptalEdilmis';
    /**
     * Constant for value 'IadeEdilmis'
     * @return string 'IadeEdilmis'
     */
    const VALUE_IADE_EDILMIS = 'IadeEdilmis';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HEPSI
     * @uses self::VALUE_IPTAL_EDILMIS
     * @uses self::VALUE_IADE_EDILMIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HEPSI,
            self::VALUE_IPTAL_EDILMIS,
            self::VALUE_IADE_EDILMIS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
