<?php

namespace EnumType;

/**
 * This class stands for WebOdemeDurumlari EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebOdemeDurumlari
 * @subpackage Enumerations
 */
class WebOdemeDurumlari
{
    /**
     * Constant for value 'OnayBekliyor'
     * @return string 'OnayBekliyor'
     */
    const VALUE_ONAY_BEKLIYOR = 'OnayBekliyor';
    /**
     * Constant for value 'Onaylandi'
     * @return string 'Onaylandi'
     */
    const VALUE_ONAYLANDI = 'Onaylandi';
    /**
     * Constant for value 'Hatali'
     * @return string 'Hatali'
     */
    const VALUE_HATALI = 'Hatali';
    /**
     * Constant for value 'IadeEdilmis'
     * @return string 'IadeEdilmis'
     */
    const VALUE_IADE_EDILMIS = 'IadeEdilmis';
    /**
     * Constant for value 'IptalEdilmis'
     * @return string 'IptalEdilmis'
     */
    const VALUE_IPTAL_EDILMIS = 'IptalEdilmis';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONAY_BEKLIYOR
     * @uses self::VALUE_ONAYLANDI
     * @uses self::VALUE_HATALI
     * @uses self::VALUE_IADE_EDILMIS
     * @uses self::VALUE_IPTAL_EDILMIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONAY_BEKLIYOR,
            self::VALUE_ONAYLANDI,
            self::VALUE_HATALI,
            self::VALUE_IADE_EDILMIS,
            self::VALUE_IPTAL_EDILMIS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
