<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebHediyeCekiUygulaRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebHediyeCekiUygulaRequest
 * @subpackage Structs
 */
class WebHediyeCekiUygulaRequest extends AbstractStructBase
{
    /**
     * The HediyeCekiKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HediyeCekiKodu;
    /**
     * The SepetID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SepetID;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * Constructor method for WebHediyeCekiUygulaRequest
     * @uses WebHediyeCekiUygulaRequest::setHediyeCekiKodu()
     * @uses WebHediyeCekiUygulaRequest::setSepetID()
     * @uses WebHediyeCekiUygulaRequest::setUyeID()
     * @param string $hediyeCekiKodu
     * @param int $sepetID
     * @param int $uyeID
     */
    public function __construct($hediyeCekiKodu = null, $sepetID = null, $uyeID = null)
    {
        $this
            ->setHediyeCekiKodu($hediyeCekiKodu)
            ->setSepetID($sepetID)
            ->setUyeID($uyeID);
    }
    /**
     * Get HediyeCekiKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHediyeCekiKodu()
    {
        return isset($this->HediyeCekiKodu) ? $this->HediyeCekiKodu : null;
    }
    /**
     * Set HediyeCekiKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hediyeCekiKodu
     * @return \StructType\WebHediyeCekiUygulaRequest
     */
    public function setHediyeCekiKodu($hediyeCekiKodu = null)
    {
        // validation for constraint: string
        if (!is_null($hediyeCekiKodu) && !is_string($hediyeCekiKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hediyeCekiKodu, true), gettype($hediyeCekiKodu)), __LINE__);
        }
        if (is_null($hediyeCekiKodu) || (is_array($hediyeCekiKodu) && empty($hediyeCekiKodu))) {
            unset($this->HediyeCekiKodu);
        } else {
            $this->HediyeCekiKodu = $hediyeCekiKodu;
        }
        return $this;
    }
    /**
     * Get SepetID value
     * @return int|null
     */
    public function getSepetID()
    {
        return $this->SepetID;
    }
    /**
     * Set SepetID value
     * @param int $sepetID
     * @return \StructType\WebHediyeCekiUygulaRequest
     */
    public function setSepetID($sepetID = null)
    {
        // validation for constraint: int
        if (!is_null($sepetID) && !(is_int($sepetID) || ctype_digit($sepetID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sepetID, true), gettype($sepetID)), __LINE__);
        }
        $this->SepetID = $sepetID;
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\WebHediyeCekiUygulaRequest
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebHediyeCekiUygulaRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
