<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUlke StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WebUlke
 * @subpackage Structs
 */
class WebUlke extends AbstractStructBase
{
    /**
     * The Alpha2Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Alpha2Code;
    /**
     * The Alpha3Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Alpha3Code;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The NumericCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumericCode;
    /**
     * The Tanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * Constructor method for WebUlke
     * @uses WebUlke::setAlpha2Code()
     * @uses WebUlke::setAlpha3Code()
     * @uses WebUlke::setID()
     * @uses WebUlke::setNumericCode()
     * @uses WebUlke::setTanim()
     * @param string $alpha2Code
     * @param string $alpha3Code
     * @param int $iD
     * @param string $numericCode
     * @param string $tanim
     */
    public function __construct($alpha2Code = null, $alpha3Code = null, $iD = null, $numericCode = null, $tanim = null)
    {
        $this
            ->setAlpha2Code($alpha2Code)
            ->setAlpha3Code($alpha3Code)
            ->setID($iD)
            ->setNumericCode($numericCode)
            ->setTanim($tanim);
    }
    /**
     * Get Alpha2Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlpha2Code()
    {
        return isset($this->Alpha2Code) ? $this->Alpha2Code : null;
    }
    /**
     * Set Alpha2Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alpha2Code
     * @return \StructType\WebUlke
     */
    public function setAlpha2Code($alpha2Code = null)
    {
        // validation for constraint: string
        if (!is_null($alpha2Code) && !is_string($alpha2Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alpha2Code, true), gettype($alpha2Code)), __LINE__);
        }
        if (is_null($alpha2Code) || (is_array($alpha2Code) && empty($alpha2Code))) {
            unset($this->Alpha2Code);
        } else {
            $this->Alpha2Code = $alpha2Code;
        }
        return $this;
    }
    /**
     * Get Alpha3Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlpha3Code()
    {
        return isset($this->Alpha3Code) ? $this->Alpha3Code : null;
    }
    /**
     * Set Alpha3Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alpha3Code
     * @return \StructType\WebUlke
     */
    public function setAlpha3Code($alpha3Code = null)
    {
        // validation for constraint: string
        if (!is_null($alpha3Code) && !is_string($alpha3Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alpha3Code, true), gettype($alpha3Code)), __LINE__);
        }
        if (is_null($alpha3Code) || (is_array($alpha3Code) && empty($alpha3Code))) {
            unset($this->Alpha3Code);
        } else {
            $this->Alpha3Code = $alpha3Code;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WebUlke
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get NumericCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumericCode()
    {
        return isset($this->NumericCode) ? $this->NumericCode : null;
    }
    /**
     * Set NumericCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numericCode
     * @return \StructType\WebUlke
     */
    public function setNumericCode($numericCode = null)
    {
        // validation for constraint: string
        if (!is_null($numericCode) && !is_string($numericCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numericCode, true), gettype($numericCode)), __LINE__);
        }
        if (is_null($numericCode) || (is_array($numericCode) && empty($numericCode))) {
            unset($this->NumericCode);
        } else {
            $this->NumericCode = $numericCode;
        }
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\WebUlke
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebUlke
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
