<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWebSepet ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfWebSepet
 * @subpackage Arrays
 */
class ArrayOfWebSepet extends AbstractStructArrayBase
{
    /**
     * The WebSepet
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebSepet[]
     */
    public $WebSepet;
    /**
     * Constructor method for ArrayOfWebSepet
     * @uses ArrayOfWebSepet::setWebSepet()
     * @param \StructType\WebSepet[] $webSepet
     */
    public function __construct(array $webSepet = array())
    {
        $this
            ->setWebSepet($webSepet);
    }
    /**
     * Get WebSepet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebSepet[]|null
     */
    public function getWebSepet()
    {
        return isset($this->WebSepet) ? $this->WebSepet : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWebSepet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebSepet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWebSepetForArrayConstraintsFromSetWebSepet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWebSepetWebSepetItem) {
            // validation for constraint: itemType
            if (!$arrayOfWebSepetWebSepetItem instanceof \StructType\WebSepet) {
                $invalidValues[] = is_object($arrayOfWebSepetWebSepetItem) ? get_class($arrayOfWebSepetWebSepetItem) : sprintf('%s(%s)', gettype($arrayOfWebSepetWebSepetItem), var_export($arrayOfWebSepetWebSepetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WebSepet property can only contain items of type \StructType\WebSepet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WebSepet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebSepet[] $webSepet
     * @return \ArrayType\ArrayOfWebSepet
     */
    public function setWebSepet(array $webSepet = array())
    {
        // validation for constraint: array
        if ('' !== ($webSepetArrayErrorMessage = self::validateWebSepetForArrayConstraintsFromSetWebSepet($webSepet))) {
            throw new \InvalidArgumentException($webSepetArrayErrorMessage, __LINE__);
        }
        if (is_null($webSepet) || (is_array($webSepet) && empty($webSepet))) {
            unset($this->WebSepet);
        } else {
            $this->WebSepet = $webSepet;
        }
        return $this;
    }
    /**
     * Add item to WebSepet value
     * @throws \InvalidArgumentException
     * @param \StructType\WebSepet $item
     * @return \ArrayType\ArrayOfWebSepet
     */
    public function addToWebSepet(\StructType\WebSepet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebSepet) {
            throw new \InvalidArgumentException(sprintf('The WebSepet property can only contain items of type \StructType\WebSepet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WebSepet[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WebSepet|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WebSepet|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WebSepet|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WebSepet|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WebSepet|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WebSepet
     */
    public function getAttributeName()
    {
        return 'WebSepet';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfWebSepet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
