<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebSiparisKampanya StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WebSiparisKampanya
 * @subpackage Structs
 */
class WebSiparisKampanya extends AbstractStructBase
{
    /**
     * The KampanyaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KampanyaID;
    /**
     * The SiparisID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The UrunID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunID;
    /**
     * Constructor method for WebSiparisKampanya
     * @uses WebSiparisKampanya::setKampanyaID()
     * @uses WebSiparisKampanya::setSiparisID()
     * @uses WebSiparisKampanya::setUrunID()
     * @param int $kampanyaID
     * @param int $siparisID
     * @param int $urunID
     */
    public function __construct($kampanyaID = null, $siparisID = null, $urunID = null)
    {
        $this
            ->setKampanyaID($kampanyaID)
            ->setSiparisID($siparisID)
            ->setUrunID($urunID);
    }
    /**
     * Get KampanyaID value
     * @return int|null
     */
    public function getKampanyaID()
    {
        return $this->KampanyaID;
    }
    /**
     * Set KampanyaID value
     * @param int $kampanyaID
     * @return \StructType\WebSiparisKampanya
     */
    public function setKampanyaID($kampanyaID = null)
    {
        // validation for constraint: int
        if (!is_null($kampanyaID) && !(is_int($kampanyaID) || ctype_digit($kampanyaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kampanyaID, true), gettype($kampanyaID)), __LINE__);
        }
        $this->KampanyaID = $kampanyaID;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\WebSiparisKampanya
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get UrunID value
     * @return int|null
     */
    public function getUrunID()
    {
        return $this->UrunID;
    }
    /**
     * Set UrunID value
     * @param int $urunID
     * @return \StructType\WebSiparisKampanya
     */
    public function setUrunID($urunID = null)
    {
        // validation for constraint: int
        if (!is_null($urunID) && !(is_int($urunID) || ctype_digit($urunID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunID, true), gettype($urunID)), __LINE__);
        }
        $this->UrunID = $urunID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebSiparisKampanya
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
