<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebKargoFirma StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WebKargoFirma
 * @subpackage Structs
 */
class WebKargoFirma extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The KapidaOdeme
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KapidaOdeme;
    /**
     * The KapidaOdemeFiyati
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KapidaOdemeFiyati;
    /**
     * The KapidaOdemeKK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KapidaOdemeKK;
    /**
     * The KapidaOdemeKKFiyati
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KapidaOdemeKKFiyati;
    /**
     * The KargoTutari
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KargoTutari;
    /**
     * The Tanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * Constructor method for WebKargoFirma
     * @uses WebKargoFirma::setID()
     * @uses WebKargoFirma::setKapidaOdeme()
     * @uses WebKargoFirma::setKapidaOdemeFiyati()
     * @uses WebKargoFirma::setKapidaOdemeKK()
     * @uses WebKargoFirma::setKapidaOdemeKKFiyati()
     * @uses WebKargoFirma::setKargoTutari()
     * @uses WebKargoFirma::setTanim()
     * @param int $iD
     * @param bool $kapidaOdeme
     * @param float $kapidaOdemeFiyati
     * @param bool $kapidaOdemeKK
     * @param float $kapidaOdemeKKFiyati
     * @param float $kargoTutari
     * @param string $tanim
     */
    public function __construct($iD = null, $kapidaOdeme = null, $kapidaOdemeFiyati = null, $kapidaOdemeKK = null, $kapidaOdemeKKFiyati = null, $kargoTutari = null, $tanim = null)
    {
        $this
            ->setID($iD)
            ->setKapidaOdeme($kapidaOdeme)
            ->setKapidaOdemeFiyati($kapidaOdemeFiyati)
            ->setKapidaOdemeKK($kapidaOdemeKK)
            ->setKapidaOdemeKKFiyati($kapidaOdemeKKFiyati)
            ->setKargoTutari($kargoTutari)
            ->setTanim($tanim);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WebKargoFirma
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get KapidaOdeme value
     * @return bool|null
     */
    public function getKapidaOdeme()
    {
        return $this->KapidaOdeme;
    }
    /**
     * Set KapidaOdeme value
     * @param bool $kapidaOdeme
     * @return \StructType\WebKargoFirma
     */
    public function setKapidaOdeme($kapidaOdeme = null)
    {
        // validation for constraint: boolean
        if (!is_null($kapidaOdeme) && !is_bool($kapidaOdeme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kapidaOdeme, true), gettype($kapidaOdeme)), __LINE__);
        }
        $this->KapidaOdeme = $kapidaOdeme;
        return $this;
    }
    /**
     * Get KapidaOdemeFiyati value
     * @return float|null
     */
    public function getKapidaOdemeFiyati()
    {
        return $this->KapidaOdemeFiyati;
    }
    /**
     * Set KapidaOdemeFiyati value
     * @param float $kapidaOdemeFiyati
     * @return \StructType\WebKargoFirma
     */
    public function setKapidaOdemeFiyati($kapidaOdemeFiyati = null)
    {
        // validation for constraint: float
        if (!is_null($kapidaOdemeFiyati) && !(is_float($kapidaOdemeFiyati) || is_numeric($kapidaOdemeFiyati))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kapidaOdemeFiyati, true), gettype($kapidaOdemeFiyati)), __LINE__);
        }
        $this->KapidaOdemeFiyati = $kapidaOdemeFiyati;
        return $this;
    }
    /**
     * Get KapidaOdemeKK value
     * @return bool|null
     */
    public function getKapidaOdemeKK()
    {
        return $this->KapidaOdemeKK;
    }
    /**
     * Set KapidaOdemeKK value
     * @param bool $kapidaOdemeKK
     * @return \StructType\WebKargoFirma
     */
    public function setKapidaOdemeKK($kapidaOdemeKK = null)
    {
        // validation for constraint: boolean
        if (!is_null($kapidaOdemeKK) && !is_bool($kapidaOdemeKK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kapidaOdemeKK, true), gettype($kapidaOdemeKK)), __LINE__);
        }
        $this->KapidaOdemeKK = $kapidaOdemeKK;
        return $this;
    }
    /**
     * Get KapidaOdemeKKFiyati value
     * @return float|null
     */
    public function getKapidaOdemeKKFiyati()
    {
        return $this->KapidaOdemeKKFiyati;
    }
    /**
     * Set KapidaOdemeKKFiyati value
     * @param float $kapidaOdemeKKFiyati
     * @return \StructType\WebKargoFirma
     */
    public function setKapidaOdemeKKFiyati($kapidaOdemeKKFiyati = null)
    {
        // validation for constraint: float
        if (!is_null($kapidaOdemeKKFiyati) && !(is_float($kapidaOdemeKKFiyati) || is_numeric($kapidaOdemeKKFiyati))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kapidaOdemeKKFiyati, true), gettype($kapidaOdemeKKFiyati)), __LINE__);
        }
        $this->KapidaOdemeKKFiyati = $kapidaOdemeKKFiyati;
        return $this;
    }
    /**
     * Get KargoTutari value
     * @return float|null
     */
    public function getKargoTutari()
    {
        return $this->KargoTutari;
    }
    /**
     * Set KargoTutari value
     * @param float $kargoTutari
     * @return \StructType\WebKargoFirma
     */
    public function setKargoTutari($kargoTutari = null)
    {
        // validation for constraint: float
        if (!is_null($kargoTutari) && !(is_float($kargoTutari) || is_numeric($kargoTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kargoTutari, true), gettype($kargoTutari)), __LINE__);
        }
        $this->KargoTutari = $kargoTutari;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\WebKargoFirma
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebKargoFirma
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
