<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebKargoPaket StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WebKargoPaket
 * @subpackage Structs
 */
class WebKargoPaket extends AbstractStructBase
{
    /**
     * The EklenmeTarihi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EklenmeTarihi;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The KargoEntegrasyonID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KargoEntegrasyonID;
    /**
     * The KargoEntegrasyonTanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoEntegrasyonTanim;
    /**
     * The KargoTakipNumarasi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoTakipNumarasi;
    /**
     * The SiparisDurum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisDurum;
    /**
     * The SiparisID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The SiparisUrunDurumID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisUrunDurumID;
    /**
     * The SiparisUrunDurumTanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisUrunDurumTanim;
    /**
     * The Urun_Liste
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSiparisKargoPaketUrun
     */
    public $Urun_Liste;
    /**
     * The Urunler
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $Urunler;
    /**
     * Constructor method for WebKargoPaket
     * @uses WebKargoPaket::setEklenmeTarihi()
     * @uses WebKargoPaket::setID()
     * @uses WebKargoPaket::setKargoEntegrasyonID()
     * @uses WebKargoPaket::setKargoEntegrasyonTanim()
     * @uses WebKargoPaket::setKargoTakipNumarasi()
     * @uses WebKargoPaket::setSiparisDurum()
     * @uses WebKargoPaket::setSiparisID()
     * @uses WebKargoPaket::setSiparisUrunDurumID()
     * @uses WebKargoPaket::setSiparisUrunDurumTanim()
     * @uses WebKargoPaket::setUrun_Liste()
     * @uses WebKargoPaket::setUrunler()
     * @param string $eklenmeTarihi
     * @param int $iD
     * @param int $kargoEntegrasyonID
     * @param string $kargoEntegrasyonTanim
     * @param string $kargoTakipNumarasi
     * @param int $siparisDurum
     * @param int $siparisID
     * @param int $siparisUrunDurumID
     * @param string $siparisUrunDurumTanim
     * @param \ArrayType\ArrayOfSiparisKargoPaketUrun $urun_Liste
     * @param \ArrayType\ArrayOfint $urunler
     */
    public function __construct($eklenmeTarihi = null, $iD = null, $kargoEntegrasyonID = null, $kargoEntegrasyonTanim = null, $kargoTakipNumarasi = null, $siparisDurum = null, $siparisID = null, $siparisUrunDurumID = null, $siparisUrunDurumTanim = null, \ArrayType\ArrayOfSiparisKargoPaketUrun $urun_Liste = null, \ArrayType\ArrayOfint $urunler = null)
    {
        $this
            ->setEklenmeTarihi($eklenmeTarihi)
            ->setID($iD)
            ->setKargoEntegrasyonID($kargoEntegrasyonID)
            ->setKargoEntegrasyonTanim($kargoEntegrasyonTanim)
            ->setKargoTakipNumarasi($kargoTakipNumarasi)
            ->setSiparisDurum($siparisDurum)
            ->setSiparisID($siparisID)
            ->setSiparisUrunDurumID($siparisUrunDurumID)
            ->setSiparisUrunDurumTanim($siparisUrunDurumTanim)
            ->setUrun_Liste($urun_Liste)
            ->setUrunler($urunler);
    }
    /**
     * Get EklenmeTarihi value
     * @return string|null
     */
    public function getEklenmeTarihi()
    {
        return $this->EklenmeTarihi;
    }
    /**
     * Set EklenmeTarihi value
     * @param string $eklenmeTarihi
     * @return \StructType\WebKargoPaket
     */
    public function setEklenmeTarihi($eklenmeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($eklenmeTarihi) && !is_string($eklenmeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eklenmeTarihi)), __LINE__);
        }
        $this->EklenmeTarihi = $eklenmeTarihi;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WebKargoPaket
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get KargoEntegrasyonID value
     * @return int|null
     */
    public function getKargoEntegrasyonID()
    {
        return $this->KargoEntegrasyonID;
    }
    /**
     * Set KargoEntegrasyonID value
     * @param int $kargoEntegrasyonID
     * @return \StructType\WebKargoPaket
     */
    public function setKargoEntegrasyonID($kargoEntegrasyonID = null)
    {
        // validation for constraint: int
        if (!is_null($kargoEntegrasyonID) && !is_numeric($kargoEntegrasyonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kargoEntegrasyonID)), __LINE__);
        }
        $this->KargoEntegrasyonID = $kargoEntegrasyonID;
        return $this;
    }
    /**
     * Get KargoEntegrasyonTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoEntegrasyonTanim()
    {
        return isset($this->KargoEntegrasyonTanim) ? $this->KargoEntegrasyonTanim : null;
    }
    /**
     * Set KargoEntegrasyonTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoEntegrasyonTanim
     * @return \StructType\WebKargoPaket
     */
    public function setKargoEntegrasyonTanim($kargoEntegrasyonTanim = null)
    {
        // validation for constraint: string
        if (!is_null($kargoEntegrasyonTanim) && !is_string($kargoEntegrasyonTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kargoEntegrasyonTanim)), __LINE__);
        }
        if (is_null($kargoEntegrasyonTanim) || (is_array($kargoEntegrasyonTanim) && empty($kargoEntegrasyonTanim))) {
            unset($this->KargoEntegrasyonTanim);
        } else {
            $this->KargoEntegrasyonTanim = $kargoEntegrasyonTanim;
        }
        return $this;
    }
    /**
     * Get KargoTakipNumarasi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoTakipNumarasi()
    {
        return isset($this->KargoTakipNumarasi) ? $this->KargoTakipNumarasi : null;
    }
    /**
     * Set KargoTakipNumarasi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoTakipNumarasi
     * @return \StructType\WebKargoPaket
     */
    public function setKargoTakipNumarasi($kargoTakipNumarasi = null)
    {
        // validation for constraint: string
        if (!is_null($kargoTakipNumarasi) && !is_string($kargoTakipNumarasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kargoTakipNumarasi)), __LINE__);
        }
        if (is_null($kargoTakipNumarasi) || (is_array($kargoTakipNumarasi) && empty($kargoTakipNumarasi))) {
            unset($this->KargoTakipNumarasi);
        } else {
            $this->KargoTakipNumarasi = $kargoTakipNumarasi;
        }
        return $this;
    }
    /**
     * Get SiparisDurum value
     * @return int|null
     */
    public function getSiparisDurum()
    {
        return $this->SiparisDurum;
    }
    /**
     * Set SiparisDurum value
     * @param int $siparisDurum
     * @return \StructType\WebKargoPaket
     */
    public function setSiparisDurum($siparisDurum = null)
    {
        // validation for constraint: int
        if (!is_null($siparisDurum) && !is_numeric($siparisDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siparisDurum)), __LINE__);
        }
        $this->SiparisDurum = $siparisDurum;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\WebKargoPaket
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !is_numeric($siparisID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get SiparisUrunDurumID value
     * @return int|null
     */
    public function getSiparisUrunDurumID()
    {
        return $this->SiparisUrunDurumID;
    }
    /**
     * Set SiparisUrunDurumID value
     * @param int $siparisUrunDurumID
     * @return \StructType\WebKargoPaket
     */
    public function setSiparisUrunDurumID($siparisUrunDurumID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisUrunDurumID) && !is_numeric($siparisUrunDurumID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siparisUrunDurumID)), __LINE__);
        }
        $this->SiparisUrunDurumID = $siparisUrunDurumID;
        return $this;
    }
    /**
     * Get SiparisUrunDurumTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisUrunDurumTanim()
    {
        return isset($this->SiparisUrunDurumTanim) ? $this->SiparisUrunDurumTanim : null;
    }
    /**
     * Set SiparisUrunDurumTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisUrunDurumTanim
     * @return \StructType\WebKargoPaket
     */
    public function setSiparisUrunDurumTanim($siparisUrunDurumTanim = null)
    {
        // validation for constraint: string
        if (!is_null($siparisUrunDurumTanim) && !is_string($siparisUrunDurumTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siparisUrunDurumTanim)), __LINE__);
        }
        if (is_null($siparisUrunDurumTanim) || (is_array($siparisUrunDurumTanim) && empty($siparisUrunDurumTanim))) {
            unset($this->SiparisUrunDurumTanim);
        } else {
            $this->SiparisUrunDurumTanim = $siparisUrunDurumTanim;
        }
        return $this;
    }
    /**
     * Get Urun_Liste value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSiparisKargoPaketUrun|null
     */
    public function getUrun_Liste()
    {
        return isset($this->Urun_Liste) ? $this->Urun_Liste : null;
    }
    /**
     * Set Urun_Liste value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSiparisKargoPaketUrun $urun_Liste
     * @return \StructType\WebKargoPaket
     */
    public function setUrun_Liste(\ArrayType\ArrayOfSiparisKargoPaketUrun $urun_Liste = null)
    {
        if (is_null($urun_Liste) || (is_array($urun_Liste) && empty($urun_Liste))) {
            unset($this->Urun_Liste);
        } else {
            $this->Urun_Liste = $urun_Liste;
        }
        return $this;
    }
    /**
     * Get Urunler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getUrunler()
    {
        return isset($this->Urunler) ? $this->Urunler : null;
    }
    /**
     * Set Urunler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $urunler
     * @return \StructType\WebKargoPaket
     */
    public function setUrunler(\ArrayType\ArrayOfint $urunler = null)
    {
        if (is_null($urunler) || (is_array($urunler) && empty($urunler))) {
            unset($this->Urunler);
        } else {
            $this->Urunler = $urunler;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebKargoPaket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
