<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BLKargoFirma StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BLKargoFirma
 * @subpackage Structs
 */
class BLKargoFirma extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The EIhracatServis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EIhracatServis;
    /**
     * The EntegrasyonKodu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntegrasyonKodu;
    /**
     * The FirmaLogo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirmaLogo;
    /**
     * The FirmaTelefon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirmaTelefon;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The KapidaOdemeAciklama
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KapidaOdemeAciklama;
    /**
     * The KapidaOdemeFiyati
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KapidaOdemeFiyati;
    /**
     * The KapidaOdemeKKFiyati
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KapidaOdemeKKFiyati;
    /**
     * The KapidaOdemePosVar
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KapidaOdemePosVar;
    /**
     * The KapidaOdemeVar
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KapidaOdemeVar;
    /**
     * The MagazaKuryeAktif
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MagazaKuryeAktif;
    /**
     * The Sira
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sira;
    /**
     * The Tanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * The TeslimatTarihiGoster
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TeslimatTarihiGoster;
    /**
     * The TeslimatTarihiGosterimGunSayisi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TeslimatTarihiGosterimGunSayisi;
    /**
     * The TeslimatTarihiGunSiniri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TeslimatTarihiGunSiniri;
    /**
     * The TeslimatTarihiTasarim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TeslimatTarihiTasarim;
    /**
     * The Tip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * Constructor method for BLKargoFirma
     * @uses BLKargoFirma::setAktif()
     * @uses BLKargoFirma::setEIhracatServis()
     * @uses BLKargoFirma::setEntegrasyonKodu()
     * @uses BLKargoFirma::setFirmaLogo()
     * @uses BLKargoFirma::setFirmaTelefon()
     * @uses BLKargoFirma::setID()
     * @uses BLKargoFirma::setKapidaOdemeAciklama()
     * @uses BLKargoFirma::setKapidaOdemeFiyati()
     * @uses BLKargoFirma::setKapidaOdemeKKFiyati()
     * @uses BLKargoFirma::setKapidaOdemePosVar()
     * @uses BLKargoFirma::setKapidaOdemeVar()
     * @uses BLKargoFirma::setMagazaKuryeAktif()
     * @uses BLKargoFirma::setSira()
     * @uses BLKargoFirma::setTanim()
     * @uses BLKargoFirma::setTeslimatTarihiGoster()
     * @uses BLKargoFirma::setTeslimatTarihiGosterimGunSayisi()
     * @uses BLKargoFirma::setTeslimatTarihiGunSiniri()
     * @uses BLKargoFirma::setTeslimatTarihiTasarim()
     * @uses BLKargoFirma::setTip()
     * @param bool $aktif
     * @param int $eIhracatServis
     * @param string $entegrasyonKodu
     * @param string $firmaLogo
     * @param string $firmaTelefon
     * @param int $iD
     * @param string $kapidaOdemeAciklama
     * @param float $kapidaOdemeFiyati
     * @param float $kapidaOdemeKKFiyati
     * @param bool $kapidaOdemePosVar
     * @param bool $kapidaOdemeVar
     * @param bool $magazaKuryeAktif
     * @param int $sira
     * @param string $tanim
     * @param bool $teslimatTarihiGoster
     * @param int $teslimatTarihiGosterimGunSayisi
     * @param int $teslimatTarihiGunSiniri
     * @param int $teslimatTarihiTasarim
     * @param int $tip
     */
    public function __construct($aktif = null, $eIhracatServis = null, $entegrasyonKodu = null, $firmaLogo = null, $firmaTelefon = null, $iD = null, $kapidaOdemeAciklama = null, $kapidaOdemeFiyati = null, $kapidaOdemeKKFiyati = null, $kapidaOdemePosVar = null, $kapidaOdemeVar = null, $magazaKuryeAktif = null, $sira = null, $tanim = null, $teslimatTarihiGoster = null, $teslimatTarihiGosterimGunSayisi = null, $teslimatTarihiGunSiniri = null, $teslimatTarihiTasarim = null, $tip = null)
    {
        $this
            ->setAktif($aktif)
            ->setEIhracatServis($eIhracatServis)
            ->setEntegrasyonKodu($entegrasyonKodu)
            ->setFirmaLogo($firmaLogo)
            ->setFirmaTelefon($firmaTelefon)
            ->setID($iD)
            ->setKapidaOdemeAciklama($kapidaOdemeAciklama)
            ->setKapidaOdemeFiyati($kapidaOdemeFiyati)
            ->setKapidaOdemeKKFiyati($kapidaOdemeKKFiyati)
            ->setKapidaOdemePosVar($kapidaOdemePosVar)
            ->setKapidaOdemeVar($kapidaOdemeVar)
            ->setMagazaKuryeAktif($magazaKuryeAktif)
            ->setSira($sira)
            ->setTanim($tanim)
            ->setTeslimatTarihiGoster($teslimatTarihiGoster)
            ->setTeslimatTarihiGosterimGunSayisi($teslimatTarihiGosterimGunSayisi)
            ->setTeslimatTarihiGunSiniri($teslimatTarihiGunSiniri)
            ->setTeslimatTarihiTasarim($teslimatTarihiTasarim)
            ->setTip($tip);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\BLKargoFirma
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get EIhracatServis value
     * @return int|null
     */
    public function getEIhracatServis()
    {
        return $this->EIhracatServis;
    }
    /**
     * Set EIhracatServis value
     * @param int $eIhracatServis
     * @return \StructType\BLKargoFirma
     */
    public function setEIhracatServis($eIhracatServis = null)
    {
        // validation for constraint: int
        if (!is_null($eIhracatServis) && !is_numeric($eIhracatServis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eIhracatServis)), __LINE__);
        }
        $this->EIhracatServis = $eIhracatServis;
        return $this;
    }
    /**
     * Get EntegrasyonKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntegrasyonKodu()
    {
        return isset($this->EntegrasyonKodu) ? $this->EntegrasyonKodu : null;
    }
    /**
     * Set EntegrasyonKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entegrasyonKodu
     * @return \StructType\BLKargoFirma
     */
    public function setEntegrasyonKodu($entegrasyonKodu = null)
    {
        // validation for constraint: string
        if (!is_null($entegrasyonKodu) && !is_string($entegrasyonKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entegrasyonKodu)), __LINE__);
        }
        if (is_null($entegrasyonKodu) || (is_array($entegrasyonKodu) && empty($entegrasyonKodu))) {
            unset($this->EntegrasyonKodu);
        } else {
            $this->EntegrasyonKodu = $entegrasyonKodu;
        }
        return $this;
    }
    /**
     * Get FirmaLogo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirmaLogo()
    {
        return isset($this->FirmaLogo) ? $this->FirmaLogo : null;
    }
    /**
     * Set FirmaLogo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firmaLogo
     * @return \StructType\BLKargoFirma
     */
    public function setFirmaLogo($firmaLogo = null)
    {
        // validation for constraint: string
        if (!is_null($firmaLogo) && !is_string($firmaLogo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firmaLogo)), __LINE__);
        }
        if (is_null($firmaLogo) || (is_array($firmaLogo) && empty($firmaLogo))) {
            unset($this->FirmaLogo);
        } else {
            $this->FirmaLogo = $firmaLogo;
        }
        return $this;
    }
    /**
     * Get FirmaTelefon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirmaTelefon()
    {
        return isset($this->FirmaTelefon) ? $this->FirmaTelefon : null;
    }
    /**
     * Set FirmaTelefon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firmaTelefon
     * @return \StructType\BLKargoFirma
     */
    public function setFirmaTelefon($firmaTelefon = null)
    {
        // validation for constraint: string
        if (!is_null($firmaTelefon) && !is_string($firmaTelefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firmaTelefon)), __LINE__);
        }
        if (is_null($firmaTelefon) || (is_array($firmaTelefon) && empty($firmaTelefon))) {
            unset($this->FirmaTelefon);
        } else {
            $this->FirmaTelefon = $firmaTelefon;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\BLKargoFirma
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get KapidaOdemeAciklama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKapidaOdemeAciklama()
    {
        return isset($this->KapidaOdemeAciklama) ? $this->KapidaOdemeAciklama : null;
    }
    /**
     * Set KapidaOdemeAciklama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kapidaOdemeAciklama
     * @return \StructType\BLKargoFirma
     */
    public function setKapidaOdemeAciklama($kapidaOdemeAciklama = null)
    {
        // validation for constraint: string
        if (!is_null($kapidaOdemeAciklama) && !is_string($kapidaOdemeAciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kapidaOdemeAciklama)), __LINE__);
        }
        if (is_null($kapidaOdemeAciklama) || (is_array($kapidaOdemeAciklama) && empty($kapidaOdemeAciklama))) {
            unset($this->KapidaOdemeAciklama);
        } else {
            $this->KapidaOdemeAciklama = $kapidaOdemeAciklama;
        }
        return $this;
    }
    /**
     * Get KapidaOdemeFiyati value
     * @return float|null
     */
    public function getKapidaOdemeFiyati()
    {
        return $this->KapidaOdemeFiyati;
    }
    /**
     * Set KapidaOdemeFiyati value
     * @param float $kapidaOdemeFiyati
     * @return \StructType\BLKargoFirma
     */
    public function setKapidaOdemeFiyati($kapidaOdemeFiyati = null)
    {
        $this->KapidaOdemeFiyati = $kapidaOdemeFiyati;
        return $this;
    }
    /**
     * Get KapidaOdemeKKFiyati value
     * @return float|null
     */
    public function getKapidaOdemeKKFiyati()
    {
        return $this->KapidaOdemeKKFiyati;
    }
    /**
     * Set KapidaOdemeKKFiyati value
     * @param float $kapidaOdemeKKFiyati
     * @return \StructType\BLKargoFirma
     */
    public function setKapidaOdemeKKFiyati($kapidaOdemeKKFiyati = null)
    {
        $this->KapidaOdemeKKFiyati = $kapidaOdemeKKFiyati;
        return $this;
    }
    /**
     * Get KapidaOdemePosVar value
     * @return bool|null
     */
    public function getKapidaOdemePosVar()
    {
        return $this->KapidaOdemePosVar;
    }
    /**
     * Set KapidaOdemePosVar value
     * @param bool $kapidaOdemePosVar
     * @return \StructType\BLKargoFirma
     */
    public function setKapidaOdemePosVar($kapidaOdemePosVar = null)
    {
        // validation for constraint: boolean
        if (!is_null($kapidaOdemePosVar) && !is_bool($kapidaOdemePosVar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($kapidaOdemePosVar)), __LINE__);
        }
        $this->KapidaOdemePosVar = $kapidaOdemePosVar;
        return $this;
    }
    /**
     * Get KapidaOdemeVar value
     * @return bool|null
     */
    public function getKapidaOdemeVar()
    {
        return $this->KapidaOdemeVar;
    }
    /**
     * Set KapidaOdemeVar value
     * @param bool $kapidaOdemeVar
     * @return \StructType\BLKargoFirma
     */
    public function setKapidaOdemeVar($kapidaOdemeVar = null)
    {
        // validation for constraint: boolean
        if (!is_null($kapidaOdemeVar) && !is_bool($kapidaOdemeVar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($kapidaOdemeVar)), __LINE__);
        }
        $this->KapidaOdemeVar = $kapidaOdemeVar;
        return $this;
    }
    /**
     * Get MagazaKuryeAktif value
     * @return bool|null
     */
    public function getMagazaKuryeAktif()
    {
        return $this->MagazaKuryeAktif;
    }
    /**
     * Set MagazaKuryeAktif value
     * @param bool $magazaKuryeAktif
     * @return \StructType\BLKargoFirma
     */
    public function setMagazaKuryeAktif($magazaKuryeAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($magazaKuryeAktif) && !is_bool($magazaKuryeAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($magazaKuryeAktif)), __LINE__);
        }
        $this->MagazaKuryeAktif = $magazaKuryeAktif;
        return $this;
    }
    /**
     * Get Sira value
     * @return int|null
     */
    public function getSira()
    {
        return $this->Sira;
    }
    /**
     * Set Sira value
     * @param int $sira
     * @return \StructType\BLKargoFirma
     */
    public function setSira($sira = null)
    {
        // validation for constraint: int
        if (!is_null($sira) && !is_numeric($sira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sira)), __LINE__);
        }
        $this->Sira = $sira;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\BLKargoFirma
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Get TeslimatTarihiGoster value
     * @return bool|null
     */
    public function getTeslimatTarihiGoster()
    {
        return $this->TeslimatTarihiGoster;
    }
    /**
     * Set TeslimatTarihiGoster value
     * @param bool $teslimatTarihiGoster
     * @return \StructType\BLKargoFirma
     */
    public function setTeslimatTarihiGoster($teslimatTarihiGoster = null)
    {
        // validation for constraint: boolean
        if (!is_null($teslimatTarihiGoster) && !is_bool($teslimatTarihiGoster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($teslimatTarihiGoster)), __LINE__);
        }
        $this->TeslimatTarihiGoster = $teslimatTarihiGoster;
        return $this;
    }
    /**
     * Get TeslimatTarihiGosterimGunSayisi value
     * @return int|null
     */
    public function getTeslimatTarihiGosterimGunSayisi()
    {
        return $this->TeslimatTarihiGosterimGunSayisi;
    }
    /**
     * Set TeslimatTarihiGosterimGunSayisi value
     * @param int $teslimatTarihiGosterimGunSayisi
     * @return \StructType\BLKargoFirma
     */
    public function setTeslimatTarihiGosterimGunSayisi($teslimatTarihiGosterimGunSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($teslimatTarihiGosterimGunSayisi) && !is_numeric($teslimatTarihiGosterimGunSayisi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($teslimatTarihiGosterimGunSayisi)), __LINE__);
        }
        $this->TeslimatTarihiGosterimGunSayisi = $teslimatTarihiGosterimGunSayisi;
        return $this;
    }
    /**
     * Get TeslimatTarihiGunSiniri value
     * @return int|null
     */
    public function getTeslimatTarihiGunSiniri()
    {
        return $this->TeslimatTarihiGunSiniri;
    }
    /**
     * Set TeslimatTarihiGunSiniri value
     * @param int $teslimatTarihiGunSiniri
     * @return \StructType\BLKargoFirma
     */
    public function setTeslimatTarihiGunSiniri($teslimatTarihiGunSiniri = null)
    {
        // validation for constraint: int
        if (!is_null($teslimatTarihiGunSiniri) && !is_numeric($teslimatTarihiGunSiniri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($teslimatTarihiGunSiniri)), __LINE__);
        }
        $this->TeslimatTarihiGunSiniri = $teslimatTarihiGunSiniri;
        return $this;
    }
    /**
     * Get TeslimatTarihiTasarim value
     * @return int|null
     */
    public function getTeslimatTarihiTasarim()
    {
        return $this->TeslimatTarihiTasarim;
    }
    /**
     * Set TeslimatTarihiTasarim value
     * @param int $teslimatTarihiTasarim
     * @return \StructType\BLKargoFirma
     */
    public function setTeslimatTarihiTasarim($teslimatTarihiTasarim = null)
    {
        // validation for constraint: int
        if (!is_null($teslimatTarihiTasarim) && !is_numeric($teslimatTarihiTasarim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($teslimatTarihiTasarim)), __LINE__);
        }
        $this->TeslimatTarihiTasarim = $teslimatTarihiTasarim;
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\BLKargoFirma
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !is_numeric($tip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BLKargoFirma
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
