<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.dbonline.no/webservices/wsdl/v2/ForetakInfo.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.dbonline.no/webservices/wsdl/v2/ForetakInfo.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Sok ServiceType
 */
$sok = new \ServiceType\Sok($options);
$sok->setSoapHeaderBrukerAutorisasjon(new \StructType\BrukerAutorisasjon());
/**
 * Sample call for sokForetak operation/method
 */
if ($sok->sokForetak(new \StructType\ForetakSok()) !== false) {
    print_r($sok->getResult());
} else {
    print_r($sok->getLastError());
}
/**
 * Samples for Oppdater ServiceType
 */
$oppdater = new \ServiceType\Oppdater($options);
$oppdater->setSoapHeaderBrukerAutorisasjon(new \StructType\BrukerAutorisasjon());
/**
 * Sample call for oppdaterOvervakningsportefolje operation/method
 */
if ($oppdater->oppdaterOvervakningsportefolje(new \StructType\OppdaterOvervakningPortefolje()) !== false) {
    print_r($oppdater->getResult());
} else {
    print_r($oppdater->getLastError());
}
/**
 * Samples for Hent ServiceType
 */
$hent = new \ServiceType\Hent($options);
$hent->setSoapHeaderBrukerAutorisasjon(new \StructType\BrukerAutorisasjon());
/**
 * Sample call for hentOvervakningInfo operation/method
 */
if ($hent->hentOvervakningInfo(new \StructType\HentOvervakningEndringer()) !== false) {
    print_r($hent->getResult());
} else {
    print_r($hent->getLastError());
}
/**
 * Sample call for hentForetakinfo operation/method
 */
if ($hent->hentForetakinfo(new \StructType\HentForetak()) !== false) {
    print_r($hent->getResult());
} else {
    print_r($hent->getLastError());
}
/**
 * Sample call for hentArsrapportListe operation/method
 */
if ($hent->hentArsrapportListe(new \StructType\HentArsrapportListe()) !== false) {
    print_r($hent->getResult());
} else {
    print_r($hent->getLastError());
}
/**
 * Sample call for hentArsrapport operation/method
 */
if ($hent->hentArsrapport(new \StructType\HentArsrapport()) !== false) {
    print_r($hent->getResult());
} else {
    print_r($hent->getLastError());
}
