<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Scoring StructType
 * @subpackage Structs
 */
class Scoring extends AbstractStructBase
{
    /**
     * The Beslutning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Beslutning;
    /**
     * The ArsaksData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ArsaksData[]
     */
    public $ArsaksData;
    /**
     * The Score
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Score;
    /**
     * The GrenseAvslag
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $GrenseAvslag;
    /**
     * The GrenseGodkjent
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $GrenseGodkjent;
    /**
     * The Scorevariabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Scorevariabel[]
     */
    public $Scorevariabel;
    /**
     * The Raascore
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Raascore;
    /**
     * The Risikoklasse
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Risikoklasse;
    /**
     * The PD
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PD;
    /**
     * The Undermodell
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Undermodell;
    /**
     * The Limit
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Limit;
    /**
     * Constructor method for Scoring
     * @uses Scoring::setBeslutning()
     * @uses Scoring::setArsaksData()
     * @uses Scoring::setScore()
     * @uses Scoring::setGrenseAvslag()
     * @uses Scoring::setGrenseGodkjent()
     * @uses Scoring::setScorevariabel()
     * @uses Scoring::setRaascore()
     * @uses Scoring::setRisikoklasse()
     * @uses Scoring::setPD()
     * @uses Scoring::setUndermodell()
     * @uses Scoring::setLimit()
     * @param string $beslutning
     * @param \StructType\ArsaksData[] $arsaksData
     * @param int $score
     * @param int $grenseAvslag
     * @param int $grenseGodkjent
     * @param \StructType\Scorevariabel[] $scorevariabel
     * @param int $raascore
     * @param string $risikoklasse
     * @param float $pD
     * @param string $undermodell
     * @param int $limit
     */
    public function __construct($beslutning = null, array $arsaksData = array(), $score = 0, $grenseAvslag = 0, $grenseGodkjent = 0, array $scorevariabel = array(), $raascore = 0, $risikoklasse = '0', $pD = 0, $undermodell = '0', $limit = 0)
    {
        $this
            ->setBeslutning($beslutning)
            ->setArsaksData($arsaksData)
            ->setScore($score)
            ->setGrenseAvslag($grenseAvslag)
            ->setGrenseGodkjent($grenseGodkjent)
            ->setScorevariabel($scorevariabel)
            ->setRaascore($raascore)
            ->setRisikoklasse($risikoklasse)
            ->setPD($pD)
            ->setUndermodell($undermodell)
            ->setLimit($limit);
    }
    /**
     * Get Beslutning value
     * @return string|null
     */
    public function getBeslutning()
    {
        return $this->Beslutning;
    }
    /**
     * Set Beslutning value
     * @param string $beslutning
     * @return \StructType\Scoring
     */
    public function setBeslutning($beslutning = null)
    {
        // validation for constraint: string
        if (!is_null($beslutning) && !is_string($beslutning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beslutning)), __LINE__);
        }
        $this->Beslutning = $beslutning;
        return $this;
    }
    /**
     * Get ArsaksData value
     * @return \StructType\ArsaksData[]|null
     */
    public function getArsaksData()
    {
        return $this->ArsaksData;
    }
    /**
     * Set ArsaksData value
     * @throws \InvalidArgumentException
     * @param \StructType\ArsaksData[] $arsaksData
     * @return \StructType\Scoring
     */
    public function setArsaksData(array $arsaksData = array())
    {
        foreach ($arsaksData as $scoringArsaksDataItem) {
            // validation for constraint: itemType
            if (!$scoringArsaksDataItem instanceof \StructType\ArsaksData) {
                throw new \InvalidArgumentException(sprintf('The ArsaksData property can only contain items of \StructType\ArsaksData, "%s" given', is_object($scoringArsaksDataItem) ? get_class($scoringArsaksDataItem) : gettype($scoringArsaksDataItem)), __LINE__);
            }
        }
        $this->ArsaksData = $arsaksData;
        return $this;
    }
    /**
     * Add item to ArsaksData value
     * @throws \InvalidArgumentException
     * @param \StructType\ArsaksData $item
     * @return \StructType\Scoring
     */
    public function addToArsaksData(\StructType\ArsaksData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArsaksData) {
            throw new \InvalidArgumentException(sprintf('The ArsaksData property can only contain items of \StructType\ArsaksData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArsaksData[] = $item;
        return $this;
    }
    /**
     * Get Score value
     * @return int|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param int $score
     * @return \StructType\Scoring
     */
    public function setScore($score = 0)
    {
        // validation for constraint: int
        if (!is_null($score) && !is_numeric($score)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($score)), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
    /**
     * Get GrenseAvslag value
     * @return int|null
     */
    public function getGrenseAvslag()
    {
        return $this->GrenseAvslag;
    }
    /**
     * Set GrenseAvslag value
     * @param int $grenseAvslag
     * @return \StructType\Scoring
     */
    public function setGrenseAvslag($grenseAvslag = 0)
    {
        // validation for constraint: int
        if (!is_null($grenseAvslag) && !is_numeric($grenseAvslag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($grenseAvslag)), __LINE__);
        }
        $this->GrenseAvslag = $grenseAvslag;
        return $this;
    }
    /**
     * Get GrenseGodkjent value
     * @return int|null
     */
    public function getGrenseGodkjent()
    {
        return $this->GrenseGodkjent;
    }
    /**
     * Set GrenseGodkjent value
     * @param int $grenseGodkjent
     * @return \StructType\Scoring
     */
    public function setGrenseGodkjent($grenseGodkjent = 0)
    {
        // validation for constraint: int
        if (!is_null($grenseGodkjent) && !is_numeric($grenseGodkjent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($grenseGodkjent)), __LINE__);
        }
        $this->GrenseGodkjent = $grenseGodkjent;
        return $this;
    }
    /**
     * Get Scorevariabel value
     * @return \StructType\Scorevariabel[]|null
     */
    public function getScorevariabel()
    {
        return $this->Scorevariabel;
    }
    /**
     * Set Scorevariabel value
     * @throws \InvalidArgumentException
     * @param \StructType\Scorevariabel[] $scorevariabel
     * @return \StructType\Scoring
     */
    public function setScorevariabel(array $scorevariabel = array())
    {
        foreach ($scorevariabel as $scoringScorevariabelItem) {
            // validation for constraint: itemType
            if (!$scoringScorevariabelItem instanceof \StructType\Scorevariabel) {
                throw new \InvalidArgumentException(sprintf('The Scorevariabel property can only contain items of \StructType\Scorevariabel, "%s" given', is_object($scoringScorevariabelItem) ? get_class($scoringScorevariabelItem) : gettype($scoringScorevariabelItem)), __LINE__);
            }
        }
        $this->Scorevariabel = $scorevariabel;
        return $this;
    }
    /**
     * Add item to Scorevariabel value
     * @throws \InvalidArgumentException
     * @param \StructType\Scorevariabel $item
     * @return \StructType\Scoring
     */
    public function addToScorevariabel(\StructType\Scorevariabel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Scorevariabel) {
            throw new \InvalidArgumentException(sprintf('The Scorevariabel property can only contain items of \StructType\Scorevariabel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Scorevariabel[] = $item;
        return $this;
    }
    /**
     * Get Raascore value
     * @return int|null
     */
    public function getRaascore()
    {
        return $this->Raascore;
    }
    /**
     * Set Raascore value
     * @param int $raascore
     * @return \StructType\Scoring
     */
    public function setRaascore($raascore = 0)
    {
        // validation for constraint: int
        if (!is_null($raascore) && !is_numeric($raascore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($raascore)), __LINE__);
        }
        $this->Raascore = $raascore;
        return $this;
    }
    /**
     * Get Risikoklasse value
     * @return string|null
     */
    public function getRisikoklasse()
    {
        return $this->Risikoklasse;
    }
    /**
     * Set Risikoklasse value
     * @param string $risikoklasse
     * @return \StructType\Scoring
     */
    public function setRisikoklasse($risikoklasse = '0')
    {
        // validation for constraint: string
        if (!is_null($risikoklasse) && !is_string($risikoklasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($risikoklasse)), __LINE__);
        }
        $this->Risikoklasse = $risikoklasse;
        return $this;
    }
    /**
     * Get PD value
     * @return float|null
     */
    public function getPD()
    {
        return $this->PD;
    }
    /**
     * Set PD value
     * @param float $pD
     * @return \StructType\Scoring
     */
    public function setPD($pD = 0)
    {
        $this->PD = $pD;
        return $this;
    }
    /**
     * Get Undermodell value
     * @return string|null
     */
    public function getUndermodell()
    {
        return $this->Undermodell;
    }
    /**
     * Set Undermodell value
     * @param string $undermodell
     * @return \StructType\Scoring
     */
    public function setUndermodell($undermodell = '0')
    {
        // validation for constraint: string
        if (!is_null($undermodell) && !is_string($undermodell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($undermodell)), __LINE__);
        }
        $this->Undermodell = $undermodell;
        return $this;
    }
    /**
     * Get Limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimit()
    {
        return isset($this->Limit) ? $this->Limit : null;
    }
    /**
     * Set Limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limit
     * @return \StructType\Scoring
     */
    public function setLimit($limit = 0)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        if (is_null($limit) || (is_array($limit) && empty($limit))) {
            unset($this->Limit);
        } else {
            $this->Limit = $limit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Scoring
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
