<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rating StructType
 * @subpackage Structs
 */
class Rating extends AbstractStructBase
{
    /**
     * The Rating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Rating;
    /**
     * The RatingBeskrivelse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RatingBeskrivelse;
    /**
     * The Limit
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Limit;
    /**
     * The AktuellHendelse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AktuellHendelse;
    /**
     * The DelbGrunnfakta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DelbGrunnfakta;
    /**
     * The DelbEierJurdisk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DelbEierJurdisk;
    /**
     * The DelbOkonomi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DelbOkonomi;
    /**
     * The DelbBetalingserfaring
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DelbBetalingserfaring;
    /**
     * Constructor method for Rating
     * @uses Rating::setRating()
     * @uses Rating::setRatingBeskrivelse()
     * @uses Rating::setLimit()
     * @uses Rating::setAktuellHendelse()
     * @uses Rating::setDelbGrunnfakta()
     * @uses Rating::setDelbEierJurdisk()
     * @uses Rating::setDelbOkonomi()
     * @uses Rating::setDelbBetalingserfaring()
     * @param string $rating
     * @param string $ratingBeskrivelse
     * @param int $limit
     * @param string $aktuellHendelse
     * @param string $delbGrunnfakta
     * @param string $delbEierJurdisk
     * @param string $delbOkonomi
     * @param string $delbBetalingserfaring
     */
    public function __construct($rating = null, $ratingBeskrivelse = null, $limit = 0, $aktuellHendelse = null, $delbGrunnfakta = null, $delbEierJurdisk = null, $delbOkonomi = null, $delbBetalingserfaring = null)
    {
        $this
            ->setRating($rating)
            ->setRatingBeskrivelse($ratingBeskrivelse)
            ->setLimit($limit)
            ->setAktuellHendelse($aktuellHendelse)
            ->setDelbGrunnfakta($delbGrunnfakta)
            ->setDelbEierJurdisk($delbEierJurdisk)
            ->setDelbOkonomi($delbOkonomi)
            ->setDelbBetalingserfaring($delbBetalingserfaring);
    }
    /**
     * Get Rating value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRating()
    {
        return isset($this->Rating) ? $this->Rating : null;
    }
    /**
     * Set Rating value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rating
     * @return \StructType\Rating
     */
    public function setRating($rating = null)
    {
        // validation for constraint: string
        if (!is_null($rating) && !is_string($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rating)), __LINE__);
        }
        if (is_null($rating) || (is_array($rating) && empty($rating))) {
            unset($this->Rating);
        } else {
            $this->Rating = $rating;
        }
        return $this;
    }
    /**
     * Get RatingBeskrivelse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRatingBeskrivelse()
    {
        return isset($this->RatingBeskrivelse) ? $this->RatingBeskrivelse : null;
    }
    /**
     * Set RatingBeskrivelse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ratingBeskrivelse
     * @return \StructType\Rating
     */
    public function setRatingBeskrivelse($ratingBeskrivelse = null)
    {
        // validation for constraint: string
        if (!is_null($ratingBeskrivelse) && !is_string($ratingBeskrivelse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratingBeskrivelse)), __LINE__);
        }
        if (is_null($ratingBeskrivelse) || (is_array($ratingBeskrivelse) && empty($ratingBeskrivelse))) {
            unset($this->RatingBeskrivelse);
        } else {
            $this->RatingBeskrivelse = $ratingBeskrivelse;
        }
        return $this;
    }
    /**
     * Get Limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimit()
    {
        return isset($this->Limit) ? $this->Limit : null;
    }
    /**
     * Set Limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limit
     * @return \StructType\Rating
     */
    public function setLimit($limit = 0)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        if (is_null($limit) || (is_array($limit) && empty($limit))) {
            unset($this->Limit);
        } else {
            $this->Limit = $limit;
        }
        return $this;
    }
    /**
     * Get AktuellHendelse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAktuellHendelse()
    {
        return isset($this->AktuellHendelse) ? $this->AktuellHendelse : null;
    }
    /**
     * Set AktuellHendelse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aktuellHendelse
     * @return \StructType\Rating
     */
    public function setAktuellHendelse($aktuellHendelse = null)
    {
        // validation for constraint: string
        if (!is_null($aktuellHendelse) && !is_string($aktuellHendelse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aktuellHendelse)), __LINE__);
        }
        if (is_null($aktuellHendelse) || (is_array($aktuellHendelse) && empty($aktuellHendelse))) {
            unset($this->AktuellHendelse);
        } else {
            $this->AktuellHendelse = $aktuellHendelse;
        }
        return $this;
    }
    /**
     * Get DelbGrunnfakta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelbGrunnfakta()
    {
        return isset($this->DelbGrunnfakta) ? $this->DelbGrunnfakta : null;
    }
    /**
     * Set DelbGrunnfakta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $delbGrunnfakta
     * @return \StructType\Rating
     */
    public function setDelbGrunnfakta($delbGrunnfakta = null)
    {
        // validation for constraint: string
        if (!is_null($delbGrunnfakta) && !is_string($delbGrunnfakta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delbGrunnfakta)), __LINE__);
        }
        if (is_null($delbGrunnfakta) || (is_array($delbGrunnfakta) && empty($delbGrunnfakta))) {
            unset($this->DelbGrunnfakta);
        } else {
            $this->DelbGrunnfakta = $delbGrunnfakta;
        }
        return $this;
    }
    /**
     * Get DelbEierJurdisk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelbEierJurdisk()
    {
        return isset($this->DelbEierJurdisk) ? $this->DelbEierJurdisk : null;
    }
    /**
     * Set DelbEierJurdisk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $delbEierJurdisk
     * @return \StructType\Rating
     */
    public function setDelbEierJurdisk($delbEierJurdisk = null)
    {
        // validation for constraint: string
        if (!is_null($delbEierJurdisk) && !is_string($delbEierJurdisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delbEierJurdisk)), __LINE__);
        }
        if (is_null($delbEierJurdisk) || (is_array($delbEierJurdisk) && empty($delbEierJurdisk))) {
            unset($this->DelbEierJurdisk);
        } else {
            $this->DelbEierJurdisk = $delbEierJurdisk;
        }
        return $this;
    }
    /**
     * Get DelbOkonomi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelbOkonomi()
    {
        return isset($this->DelbOkonomi) ? $this->DelbOkonomi : null;
    }
    /**
     * Set DelbOkonomi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $delbOkonomi
     * @return \StructType\Rating
     */
    public function setDelbOkonomi($delbOkonomi = null)
    {
        // validation for constraint: string
        if (!is_null($delbOkonomi) && !is_string($delbOkonomi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delbOkonomi)), __LINE__);
        }
        if (is_null($delbOkonomi) || (is_array($delbOkonomi) && empty($delbOkonomi))) {
            unset($this->DelbOkonomi);
        } else {
            $this->DelbOkonomi = $delbOkonomi;
        }
        return $this;
    }
    /**
     * Get DelbBetalingserfaring value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelbBetalingserfaring()
    {
        return isset($this->DelbBetalingserfaring) ? $this->DelbBetalingserfaring : null;
    }
    /**
     * Set DelbBetalingserfaring value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $delbBetalingserfaring
     * @return \StructType\Rating
     */
    public function setDelbBetalingserfaring($delbBetalingserfaring = null)
    {
        // validation for constraint: string
        if (!is_null($delbBetalingserfaring) && !is_string($delbBetalingserfaring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delbBetalingserfaring)), __LINE__);
        }
        if (is_null($delbBetalingserfaring) || (is_array($delbBetalingserfaring) && empty($delbBetalingserfaring))) {
            unset($this->DelbBetalingserfaring);
        } else {
            $this->DelbBetalingserfaring = $delbBetalingserfaring;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rating
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
