<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HentForetakResponse StructType
 * @subpackage Structs
 */
class HentForetakResponse extends AbstractStructBase
{
    /**
     * The Identifikasjon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifikasjon
     */
    public $Identifikasjon;
    /**
     * The NavnAdresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NavnAdresse
     */
    public $NavnAdresse;
    /**
     * The Rating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Rating
     */
    public $Rating;
    /**
     * The HistRating
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HistoriskRating[]
     */
    public $HistRating;
    /**
     * The Grunnfakta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Grunnfakta
     */
    public $Grunnfakta;
    /**
     * The Juridisk
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Juridisk[]
     */
    public $Juridisk;
    /**
     * The Verv
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Verv[]
     */
    public $Verv;
    /**
     * The Aksjonar
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Aksjonar[]
     */
    public $Aksjonar;
    /**
     * The Datterselskap
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Datterselskap[]
     */
    public $Datterselskap;
    /**
     * The OkonomiEnk
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OkonomiEnk[]
     */
    public $OkonomiEnk;
    /**
     * The NokkeltallForetak
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NokkeltallForetak[]
     */
    public $NokkeltallForetak;
    /**
     * The NokkeltallBransje
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NokkeltallBransje[]
     */
    public $NokkeltallBransje;
    /**
     * The NokkeltallKonsern
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NokkeltallKonsern[]
     */
    public $NokkeltallKonsern;
    /**
     * The BetaSammendrag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BetaSammendrag
     */
    public $BetaSammendrag;
    /**
     * The BetaDetaljer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BetaDetaljer[]
     */
    public $BetaDetaljer;
    /**
     * The Losore
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Losore[]
     */
    public $Losore;
    /**
     * The EiendomNorge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EiendomNorge
     */
    public $EiendomNorge;
    /**
     * The KonsernLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KonsernLink[]
     */
    public $KonsernLink;
    /**
     * The Scoring
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Scoring
     */
    public $Scoring;
    /**
     * The OkonomiSammendragForetak
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OkonomiSammendragForetak[]
     */
    public $OkonomiSammendragForetak;
    /**
     * The OkonomiSammendragKonsern
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OkonomiSammendragKonsern[]
     */
    public $OkonomiSammendragKonsern;
    /**
     * The OkonomiDetaljerForetak
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OkonomiDetaljerForetak[]
     */
    public $OkonomiDetaljerForetak;
    /**
     * The OkonomiDetaljerKonsern
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OkonomiDetaljerKonsern[]
     */
    public $OkonomiDetaljerKonsern;
    /**
     * The EiendelerForetak
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EiendelerForetak[]
     */
    public $EiendelerForetak;
    /**
     * The EiendelerKonsern
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EiendelerKonsern[]
     */
    public $EiendelerKonsern;
    /**
     * The GjeldEgenkapitalForetak
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GjeldEgenkapitalForetak[]
     */
    public $GjeldEgenkapitalForetak;
    /**
     * The GjeldEgenkapitalKonsern
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GjeldEgenkapitalKonsern[]
     */
    public $GjeldEgenkapitalKonsern;
    /**
     * The Revisoranmerkninger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Revisoranmerkning[]
     */
    public $Revisoranmerkninger;
    /**
     * The AvdelingData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AvdelingData
     */
    public $AvdelingData;
    /**
     * The Rettighetshavere
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Rettighetshavere[]
     */
    public $Rettighetshavere;
    /**
     * The EiendomNorgeListe
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EiendomNorgeListe[]
     */
    public $EiendomNorgeListe;
    /**
     * The FullmaktForetak
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FullmaktForetak[]
     */
    public $FullmaktForetak;
    /**
     * The GjenpartData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GjenpartData
     */
    public $GjenpartData;
    /**
     * The Testinfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Testinfo
     */
    public $Testinfo;
    /**
     * The Meldinger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Meldinger[]
     */
    public $Meldinger;
    /**
     * Constructor method for HentForetakResponse
     * @uses HentForetakResponse::setIdentifikasjon()
     * @uses HentForetakResponse::setNavnAdresse()
     * @uses HentForetakResponse::setRating()
     * @uses HentForetakResponse::setHistRating()
     * @uses HentForetakResponse::setGrunnfakta()
     * @uses HentForetakResponse::setJuridisk()
     * @uses HentForetakResponse::setVerv()
     * @uses HentForetakResponse::setAksjonar()
     * @uses HentForetakResponse::setDatterselskap()
     * @uses HentForetakResponse::setOkonomiEnk()
     * @uses HentForetakResponse::setNokkeltallForetak()
     * @uses HentForetakResponse::setNokkeltallBransje()
     * @uses HentForetakResponse::setNokkeltallKonsern()
     * @uses HentForetakResponse::setBetaSammendrag()
     * @uses HentForetakResponse::setBetaDetaljer()
     * @uses HentForetakResponse::setLosore()
     * @uses HentForetakResponse::setEiendomNorge()
     * @uses HentForetakResponse::setKonsernLink()
     * @uses HentForetakResponse::setScoring()
     * @uses HentForetakResponse::setOkonomiSammendragForetak()
     * @uses HentForetakResponse::setOkonomiSammendragKonsern()
     * @uses HentForetakResponse::setOkonomiDetaljerForetak()
     * @uses HentForetakResponse::setOkonomiDetaljerKonsern()
     * @uses HentForetakResponse::setEiendelerForetak()
     * @uses HentForetakResponse::setEiendelerKonsern()
     * @uses HentForetakResponse::setGjeldEgenkapitalForetak()
     * @uses HentForetakResponse::setGjeldEgenkapitalKonsern()
     * @uses HentForetakResponse::setRevisoranmerkninger()
     * @uses HentForetakResponse::setAvdelingData()
     * @uses HentForetakResponse::setRettighetshavere()
     * @uses HentForetakResponse::setEiendomNorgeListe()
     * @uses HentForetakResponse::setFullmaktForetak()
     * @uses HentForetakResponse::setGjenpartData()
     * @uses HentForetakResponse::setTestinfo()
     * @uses HentForetakResponse::setMeldinger()
     * @param \StructType\Identifikasjon $identifikasjon
     * @param \StructType\NavnAdresse $navnAdresse
     * @param \StructType\Rating $rating
     * @param \StructType\HistoriskRating[] $histRating
     * @param \StructType\Grunnfakta $grunnfakta
     * @param \StructType\Juridisk[] $juridisk
     * @param \StructType\Verv[] $verv
     * @param \StructType\Aksjonar[] $aksjonar
     * @param \StructType\Datterselskap[] $datterselskap
     * @param \StructType\OkonomiEnk[] $okonomiEnk
     * @param \StructType\NokkeltallForetak[] $nokkeltallForetak
     * @param \StructType\NokkeltallBransje[] $nokkeltallBransje
     * @param \StructType\NokkeltallKonsern[] $nokkeltallKonsern
     * @param \StructType\BetaSammendrag $betaSammendrag
     * @param \StructType\BetaDetaljer[] $betaDetaljer
     * @param \StructType\Losore[] $losore
     * @param \StructType\EiendomNorge $eiendomNorge
     * @param \StructType\KonsernLink[] $konsernLink
     * @param \StructType\Scoring $scoring
     * @param \StructType\OkonomiSammendragForetak[] $okonomiSammendragForetak
     * @param \StructType\OkonomiSammendragKonsern[] $okonomiSammendragKonsern
     * @param \StructType\OkonomiDetaljerForetak[] $okonomiDetaljerForetak
     * @param \StructType\OkonomiDetaljerKonsern[] $okonomiDetaljerKonsern
     * @param \StructType\EiendelerForetak[] $eiendelerForetak
     * @param \StructType\EiendelerKonsern[] $eiendelerKonsern
     * @param \StructType\GjeldEgenkapitalForetak[] $gjeldEgenkapitalForetak
     * @param \StructType\GjeldEgenkapitalKonsern[] $gjeldEgenkapitalKonsern
     * @param \StructType\Revisoranmerkning[] $revisoranmerkninger
     * @param \StructType\AvdelingData $avdelingData
     * @param \StructType\Rettighetshavere[] $rettighetshavere
     * @param \StructType\EiendomNorgeListe[] $eiendomNorgeListe
     * @param \StructType\FullmaktForetak[] $fullmaktForetak
     * @param \StructType\GjenpartData $gjenpartData
     * @param \StructType\Testinfo $testinfo
     * @param \StructType\Meldinger[] $meldinger
     */
    public function __construct(\StructType\Identifikasjon $identifikasjon = null, \StructType\NavnAdresse $navnAdresse = null, \StructType\Rating $rating = null, array $histRating = array(), \StructType\Grunnfakta $grunnfakta = null, array $juridisk = array(), array $verv = array(), array $aksjonar = array(), array $datterselskap = array(), array $okonomiEnk = array(), array $nokkeltallForetak = array(), array $nokkeltallBransje = array(), array $nokkeltallKonsern = array(), \StructType\BetaSammendrag $betaSammendrag = null, array $betaDetaljer = array(), array $losore = array(), \StructType\EiendomNorge $eiendomNorge = null, array $konsernLink = array(), \StructType\Scoring $scoring = null, array $okonomiSammendragForetak = array(), array $okonomiSammendragKonsern = array(), array $okonomiDetaljerForetak = array(), array $okonomiDetaljerKonsern = array(), array $eiendelerForetak = array(), array $eiendelerKonsern = array(), array $gjeldEgenkapitalForetak = array(), array $gjeldEgenkapitalKonsern = array(), array $revisoranmerkninger = array(), \StructType\AvdelingData $avdelingData = null, array $rettighetshavere = array(), array $eiendomNorgeListe = array(), array $fullmaktForetak = array(), \StructType\GjenpartData $gjenpartData = null, \StructType\Testinfo $testinfo = null, array $meldinger = array())
    {
        $this
            ->setIdentifikasjon($identifikasjon)
            ->setNavnAdresse($navnAdresse)
            ->setRating($rating)
            ->setHistRating($histRating)
            ->setGrunnfakta($grunnfakta)
            ->setJuridisk($juridisk)
            ->setVerv($verv)
            ->setAksjonar($aksjonar)
            ->setDatterselskap($datterselskap)
            ->setOkonomiEnk($okonomiEnk)
            ->setNokkeltallForetak($nokkeltallForetak)
            ->setNokkeltallBransje($nokkeltallBransje)
            ->setNokkeltallKonsern($nokkeltallKonsern)
            ->setBetaSammendrag($betaSammendrag)
            ->setBetaDetaljer($betaDetaljer)
            ->setLosore($losore)
            ->setEiendomNorge($eiendomNorge)
            ->setKonsernLink($konsernLink)
            ->setScoring($scoring)
            ->setOkonomiSammendragForetak($okonomiSammendragForetak)
            ->setOkonomiSammendragKonsern($okonomiSammendragKonsern)
            ->setOkonomiDetaljerForetak($okonomiDetaljerForetak)
            ->setOkonomiDetaljerKonsern($okonomiDetaljerKonsern)
            ->setEiendelerForetak($eiendelerForetak)
            ->setEiendelerKonsern($eiendelerKonsern)
            ->setGjeldEgenkapitalForetak($gjeldEgenkapitalForetak)
            ->setGjeldEgenkapitalKonsern($gjeldEgenkapitalKonsern)
            ->setRevisoranmerkninger($revisoranmerkninger)
            ->setAvdelingData($avdelingData)
            ->setRettighetshavere($rettighetshavere)
            ->setEiendomNorgeListe($eiendomNorgeListe)
            ->setFullmaktForetak($fullmaktForetak)
            ->setGjenpartData($gjenpartData)
            ->setTestinfo($testinfo)
            ->setMeldinger($meldinger);
    }
    /**
     * Get Identifikasjon value
     * @return \StructType\Identifikasjon|null
     */
    public function getIdentifikasjon()
    {
        return $this->Identifikasjon;
    }
    /**
     * Set Identifikasjon value
     * @param \StructType\Identifikasjon $identifikasjon
     * @return \StructType\HentForetakResponse
     */
    public function setIdentifikasjon(\StructType\Identifikasjon $identifikasjon = null)
    {
        $this->Identifikasjon = $identifikasjon;
        return $this;
    }
    /**
     * Get NavnAdresse value
     * @return \StructType\NavnAdresse|null
     */
    public function getNavnAdresse()
    {
        return $this->NavnAdresse;
    }
    /**
     * Set NavnAdresse value
     * @param \StructType\NavnAdresse $navnAdresse
     * @return \StructType\HentForetakResponse
     */
    public function setNavnAdresse(\StructType\NavnAdresse $navnAdresse = null)
    {
        $this->NavnAdresse = $navnAdresse;
        return $this;
    }
    /**
     * Get Rating value
     * @return \StructType\Rating|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param \StructType\Rating $rating
     * @return \StructType\HentForetakResponse
     */
    public function setRating(\StructType\Rating $rating = null)
    {
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get HistRating value
     * @return \StructType\HistoriskRating[]|null
     */
    public function getHistRating()
    {
        return $this->HistRating;
    }
    /**
     * Set HistRating value
     * @throws \InvalidArgumentException
     * @param \StructType\HistoriskRating[] $histRating
     * @return \StructType\HentForetakResponse
     */
    public function setHistRating(array $histRating = array())
    {
        foreach ($histRating as $hentForetakResponseHistRatingItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseHistRatingItem instanceof \StructType\HistoriskRating) {
                throw new \InvalidArgumentException(sprintf('The HistRating property can only contain items of \StructType\HistoriskRating, "%s" given', is_object($hentForetakResponseHistRatingItem) ? get_class($hentForetakResponseHistRatingItem) : gettype($hentForetakResponseHistRatingItem)), __LINE__);
            }
        }
        $this->HistRating = $histRating;
        return $this;
    }
    /**
     * Add item to HistRating value
     * @throws \InvalidArgumentException
     * @param \StructType\HistoriskRating $item
     * @return \StructType\HentForetakResponse
     */
    public function addToHistRating(\StructType\HistoriskRating $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HistoriskRating) {
            throw new \InvalidArgumentException(sprintf('The HistRating property can only contain items of \StructType\HistoriskRating, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HistRating[] = $item;
        return $this;
    }
    /**
     * Get Grunnfakta value
     * @return \StructType\Grunnfakta|null
     */
    public function getGrunnfakta()
    {
        return $this->Grunnfakta;
    }
    /**
     * Set Grunnfakta value
     * @param \StructType\Grunnfakta $grunnfakta
     * @return \StructType\HentForetakResponse
     */
    public function setGrunnfakta(\StructType\Grunnfakta $grunnfakta = null)
    {
        $this->Grunnfakta = $grunnfakta;
        return $this;
    }
    /**
     * Get Juridisk value
     * @return \StructType\Juridisk[]|null
     */
    public function getJuridisk()
    {
        return $this->Juridisk;
    }
    /**
     * Set Juridisk value
     * @throws \InvalidArgumentException
     * @param \StructType\Juridisk[] $juridisk
     * @return \StructType\HentForetakResponse
     */
    public function setJuridisk(array $juridisk = array())
    {
        foreach ($juridisk as $hentForetakResponseJuridiskItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseJuridiskItem instanceof \StructType\Juridisk) {
                throw new \InvalidArgumentException(sprintf('The Juridisk property can only contain items of \StructType\Juridisk, "%s" given', is_object($hentForetakResponseJuridiskItem) ? get_class($hentForetakResponseJuridiskItem) : gettype($hentForetakResponseJuridiskItem)), __LINE__);
            }
        }
        $this->Juridisk = $juridisk;
        return $this;
    }
    /**
     * Add item to Juridisk value
     * @throws \InvalidArgumentException
     * @param \StructType\Juridisk $item
     * @return \StructType\HentForetakResponse
     */
    public function addToJuridisk(\StructType\Juridisk $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Juridisk) {
            throw new \InvalidArgumentException(sprintf('The Juridisk property can only contain items of \StructType\Juridisk, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Juridisk[] = $item;
        return $this;
    }
    /**
     * Get Verv value
     * @return \StructType\Verv[]|null
     */
    public function getVerv()
    {
        return $this->Verv;
    }
    /**
     * Set Verv value
     * @throws \InvalidArgumentException
     * @param \StructType\Verv[] $verv
     * @return \StructType\HentForetakResponse
     */
    public function setVerv(array $verv = array())
    {
        foreach ($verv as $hentForetakResponseVervItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseVervItem instanceof \StructType\Verv) {
                throw new \InvalidArgumentException(sprintf('The Verv property can only contain items of \StructType\Verv, "%s" given', is_object($hentForetakResponseVervItem) ? get_class($hentForetakResponseVervItem) : gettype($hentForetakResponseVervItem)), __LINE__);
            }
        }
        $this->Verv = $verv;
        return $this;
    }
    /**
     * Add item to Verv value
     * @throws \InvalidArgumentException
     * @param \StructType\Verv $item
     * @return \StructType\HentForetakResponse
     */
    public function addToVerv(\StructType\Verv $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Verv) {
            throw new \InvalidArgumentException(sprintf('The Verv property can only contain items of \StructType\Verv, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Verv[] = $item;
        return $this;
    }
    /**
     * Get Aksjonar value
     * @return \StructType\Aksjonar[]|null
     */
    public function getAksjonar()
    {
        return $this->Aksjonar;
    }
    /**
     * Set Aksjonar value
     * @throws \InvalidArgumentException
     * @param \StructType\Aksjonar[] $aksjonar
     * @return \StructType\HentForetakResponse
     */
    public function setAksjonar(array $aksjonar = array())
    {
        foreach ($aksjonar as $hentForetakResponseAksjonarItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseAksjonarItem instanceof \StructType\Aksjonar) {
                throw new \InvalidArgumentException(sprintf('The Aksjonar property can only contain items of \StructType\Aksjonar, "%s" given', is_object($hentForetakResponseAksjonarItem) ? get_class($hentForetakResponseAksjonarItem) : gettype($hentForetakResponseAksjonarItem)), __LINE__);
            }
        }
        $this->Aksjonar = $aksjonar;
        return $this;
    }
    /**
     * Add item to Aksjonar value
     * @throws \InvalidArgumentException
     * @param \StructType\Aksjonar $item
     * @return \StructType\HentForetakResponse
     */
    public function addToAksjonar(\StructType\Aksjonar $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Aksjonar) {
            throw new \InvalidArgumentException(sprintf('The Aksjonar property can only contain items of \StructType\Aksjonar, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Aksjonar[] = $item;
        return $this;
    }
    /**
     * Get Datterselskap value
     * @return \StructType\Datterselskap[]|null
     */
    public function getDatterselskap()
    {
        return $this->Datterselskap;
    }
    /**
     * Set Datterselskap value
     * @throws \InvalidArgumentException
     * @param \StructType\Datterselskap[] $datterselskap
     * @return \StructType\HentForetakResponse
     */
    public function setDatterselskap(array $datterselskap = array())
    {
        foreach ($datterselskap as $hentForetakResponseDatterselskapItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseDatterselskapItem instanceof \StructType\Datterselskap) {
                throw new \InvalidArgumentException(sprintf('The Datterselskap property can only contain items of \StructType\Datterselskap, "%s" given', is_object($hentForetakResponseDatterselskapItem) ? get_class($hentForetakResponseDatterselskapItem) : gettype($hentForetakResponseDatterselskapItem)), __LINE__);
            }
        }
        $this->Datterselskap = $datterselskap;
        return $this;
    }
    /**
     * Add item to Datterselskap value
     * @throws \InvalidArgumentException
     * @param \StructType\Datterselskap $item
     * @return \StructType\HentForetakResponse
     */
    public function addToDatterselskap(\StructType\Datterselskap $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Datterselskap) {
            throw new \InvalidArgumentException(sprintf('The Datterselskap property can only contain items of \StructType\Datterselskap, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Datterselskap[] = $item;
        return $this;
    }
    /**
     * Get OkonomiEnk value
     * @return \StructType\OkonomiEnk[]|null
     */
    public function getOkonomiEnk()
    {
        return $this->OkonomiEnk;
    }
    /**
     * Set OkonomiEnk value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiEnk[] $okonomiEnk
     * @return \StructType\HentForetakResponse
     */
    public function setOkonomiEnk(array $okonomiEnk = array())
    {
        foreach ($okonomiEnk as $hentForetakResponseOkonomiEnkItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseOkonomiEnkItem instanceof \StructType\OkonomiEnk) {
                throw new \InvalidArgumentException(sprintf('The OkonomiEnk property can only contain items of \StructType\OkonomiEnk, "%s" given', is_object($hentForetakResponseOkonomiEnkItem) ? get_class($hentForetakResponseOkonomiEnkItem) : gettype($hentForetakResponseOkonomiEnkItem)), __LINE__);
            }
        }
        $this->OkonomiEnk = $okonomiEnk;
        return $this;
    }
    /**
     * Add item to OkonomiEnk value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiEnk $item
     * @return \StructType\HentForetakResponse
     */
    public function addToOkonomiEnk(\StructType\OkonomiEnk $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OkonomiEnk) {
            throw new \InvalidArgumentException(sprintf('The OkonomiEnk property can only contain items of \StructType\OkonomiEnk, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OkonomiEnk[] = $item;
        return $this;
    }
    /**
     * Get NokkeltallForetak value
     * @return \StructType\NokkeltallForetak[]|null
     */
    public function getNokkeltallForetak()
    {
        return $this->NokkeltallForetak;
    }
    /**
     * Set NokkeltallForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\NokkeltallForetak[] $nokkeltallForetak
     * @return \StructType\HentForetakResponse
     */
    public function setNokkeltallForetak(array $nokkeltallForetak = array())
    {
        foreach ($nokkeltallForetak as $hentForetakResponseNokkeltallForetakItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseNokkeltallForetakItem instanceof \StructType\NokkeltallForetak) {
                throw new \InvalidArgumentException(sprintf('The NokkeltallForetak property can only contain items of \StructType\NokkeltallForetak, "%s" given', is_object($hentForetakResponseNokkeltallForetakItem) ? get_class($hentForetakResponseNokkeltallForetakItem) : gettype($hentForetakResponseNokkeltallForetakItem)), __LINE__);
            }
        }
        $this->NokkeltallForetak = $nokkeltallForetak;
        return $this;
    }
    /**
     * Add item to NokkeltallForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\NokkeltallForetak $item
     * @return \StructType\HentForetakResponse
     */
    public function addToNokkeltallForetak(\StructType\NokkeltallForetak $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NokkeltallForetak) {
            throw new \InvalidArgumentException(sprintf('The NokkeltallForetak property can only contain items of \StructType\NokkeltallForetak, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NokkeltallForetak[] = $item;
        return $this;
    }
    /**
     * Get NokkeltallBransje value
     * @return \StructType\NokkeltallBransje[]|null
     */
    public function getNokkeltallBransje()
    {
        return $this->NokkeltallBransje;
    }
    /**
     * Set NokkeltallBransje value
     * @throws \InvalidArgumentException
     * @param \StructType\NokkeltallBransje[] $nokkeltallBransje
     * @return \StructType\HentForetakResponse
     */
    public function setNokkeltallBransje(array $nokkeltallBransje = array())
    {
        foreach ($nokkeltallBransje as $hentForetakResponseNokkeltallBransjeItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseNokkeltallBransjeItem instanceof \StructType\NokkeltallBransje) {
                throw new \InvalidArgumentException(sprintf('The NokkeltallBransje property can only contain items of \StructType\NokkeltallBransje, "%s" given', is_object($hentForetakResponseNokkeltallBransjeItem) ? get_class($hentForetakResponseNokkeltallBransjeItem) : gettype($hentForetakResponseNokkeltallBransjeItem)), __LINE__);
            }
        }
        $this->NokkeltallBransje = $nokkeltallBransje;
        return $this;
    }
    /**
     * Add item to NokkeltallBransje value
     * @throws \InvalidArgumentException
     * @param \StructType\NokkeltallBransje $item
     * @return \StructType\HentForetakResponse
     */
    public function addToNokkeltallBransje(\StructType\NokkeltallBransje $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NokkeltallBransje) {
            throw new \InvalidArgumentException(sprintf('The NokkeltallBransje property can only contain items of \StructType\NokkeltallBransje, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NokkeltallBransje[] = $item;
        return $this;
    }
    /**
     * Get NokkeltallKonsern value
     * @return \StructType\NokkeltallKonsern[]|null
     */
    public function getNokkeltallKonsern()
    {
        return $this->NokkeltallKonsern;
    }
    /**
     * Set NokkeltallKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\NokkeltallKonsern[] $nokkeltallKonsern
     * @return \StructType\HentForetakResponse
     */
    public function setNokkeltallKonsern(array $nokkeltallKonsern = array())
    {
        foreach ($nokkeltallKonsern as $hentForetakResponseNokkeltallKonsernItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseNokkeltallKonsernItem instanceof \StructType\NokkeltallKonsern) {
                throw new \InvalidArgumentException(sprintf('The NokkeltallKonsern property can only contain items of \StructType\NokkeltallKonsern, "%s" given', is_object($hentForetakResponseNokkeltallKonsernItem) ? get_class($hentForetakResponseNokkeltallKonsernItem) : gettype($hentForetakResponseNokkeltallKonsernItem)), __LINE__);
            }
        }
        $this->NokkeltallKonsern = $nokkeltallKonsern;
        return $this;
    }
    /**
     * Add item to NokkeltallKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\NokkeltallKonsern $item
     * @return \StructType\HentForetakResponse
     */
    public function addToNokkeltallKonsern(\StructType\NokkeltallKonsern $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NokkeltallKonsern) {
            throw new \InvalidArgumentException(sprintf('The NokkeltallKonsern property can only contain items of \StructType\NokkeltallKonsern, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NokkeltallKonsern[] = $item;
        return $this;
    }
    /**
     * Get BetaSammendrag value
     * @return \StructType\BetaSammendrag|null
     */
    public function getBetaSammendrag()
    {
        return $this->BetaSammendrag;
    }
    /**
     * Set BetaSammendrag value
     * @param \StructType\BetaSammendrag $betaSammendrag
     * @return \StructType\HentForetakResponse
     */
    public function setBetaSammendrag(\StructType\BetaSammendrag $betaSammendrag = null)
    {
        $this->BetaSammendrag = $betaSammendrag;
        return $this;
    }
    /**
     * Get BetaDetaljer value
     * @return \StructType\BetaDetaljer[]|null
     */
    public function getBetaDetaljer()
    {
        return $this->BetaDetaljer;
    }
    /**
     * Set BetaDetaljer value
     * @throws \InvalidArgumentException
     * @param \StructType\BetaDetaljer[] $betaDetaljer
     * @return \StructType\HentForetakResponse
     */
    public function setBetaDetaljer(array $betaDetaljer = array())
    {
        foreach ($betaDetaljer as $hentForetakResponseBetaDetaljerItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseBetaDetaljerItem instanceof \StructType\BetaDetaljer) {
                throw new \InvalidArgumentException(sprintf('The BetaDetaljer property can only contain items of \StructType\BetaDetaljer, "%s" given', is_object($hentForetakResponseBetaDetaljerItem) ? get_class($hentForetakResponseBetaDetaljerItem) : gettype($hentForetakResponseBetaDetaljerItem)), __LINE__);
            }
        }
        $this->BetaDetaljer = $betaDetaljer;
        return $this;
    }
    /**
     * Add item to BetaDetaljer value
     * @throws \InvalidArgumentException
     * @param \StructType\BetaDetaljer $item
     * @return \StructType\HentForetakResponse
     */
    public function addToBetaDetaljer(\StructType\BetaDetaljer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BetaDetaljer) {
            throw new \InvalidArgumentException(sprintf('The BetaDetaljer property can only contain items of \StructType\BetaDetaljer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BetaDetaljer[] = $item;
        return $this;
    }
    /**
     * Get Losore value
     * @return \StructType\Losore[]|null
     */
    public function getLosore()
    {
        return $this->Losore;
    }
    /**
     * Set Losore value
     * @throws \InvalidArgumentException
     * @param \StructType\Losore[] $losore
     * @return \StructType\HentForetakResponse
     */
    public function setLosore(array $losore = array())
    {
        foreach ($losore as $hentForetakResponseLosoreItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseLosoreItem instanceof \StructType\Losore) {
                throw new \InvalidArgumentException(sprintf('The Losore property can only contain items of \StructType\Losore, "%s" given', is_object($hentForetakResponseLosoreItem) ? get_class($hentForetakResponseLosoreItem) : gettype($hentForetakResponseLosoreItem)), __LINE__);
            }
        }
        $this->Losore = $losore;
        return $this;
    }
    /**
     * Add item to Losore value
     * @throws \InvalidArgumentException
     * @param \StructType\Losore $item
     * @return \StructType\HentForetakResponse
     */
    public function addToLosore(\StructType\Losore $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Losore) {
            throw new \InvalidArgumentException(sprintf('The Losore property can only contain items of \StructType\Losore, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Losore[] = $item;
        return $this;
    }
    /**
     * Get EiendomNorge value
     * @return \StructType\EiendomNorge|null
     */
    public function getEiendomNorge()
    {
        return $this->EiendomNorge;
    }
    /**
     * Set EiendomNorge value
     * @param \StructType\EiendomNorge $eiendomNorge
     * @return \StructType\HentForetakResponse
     */
    public function setEiendomNorge(\StructType\EiendomNorge $eiendomNorge = null)
    {
        $this->EiendomNorge = $eiendomNorge;
        return $this;
    }
    /**
     * Get KonsernLink value
     * @return \StructType\KonsernLink[]|null
     */
    public function getKonsernLink()
    {
        return $this->KonsernLink;
    }
    /**
     * Set KonsernLink value
     * @throws \InvalidArgumentException
     * @param \StructType\KonsernLink[] $konsernLink
     * @return \StructType\HentForetakResponse
     */
    public function setKonsernLink(array $konsernLink = array())
    {
        foreach ($konsernLink as $hentForetakResponseKonsernLinkItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseKonsernLinkItem instanceof \StructType\KonsernLink) {
                throw new \InvalidArgumentException(sprintf('The KonsernLink property can only contain items of \StructType\KonsernLink, "%s" given', is_object($hentForetakResponseKonsernLinkItem) ? get_class($hentForetakResponseKonsernLinkItem) : gettype($hentForetakResponseKonsernLinkItem)), __LINE__);
            }
        }
        $this->KonsernLink = $konsernLink;
        return $this;
    }
    /**
     * Add item to KonsernLink value
     * @throws \InvalidArgumentException
     * @param \StructType\KonsernLink $item
     * @return \StructType\HentForetakResponse
     */
    public function addToKonsernLink(\StructType\KonsernLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KonsernLink) {
            throw new \InvalidArgumentException(sprintf('The KonsernLink property can only contain items of \StructType\KonsernLink, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KonsernLink[] = $item;
        return $this;
    }
    /**
     * Get Scoring value
     * @return \StructType\Scoring|null
     */
    public function getScoring()
    {
        return $this->Scoring;
    }
    /**
     * Set Scoring value
     * @param \StructType\Scoring $scoring
     * @return \StructType\HentForetakResponse
     */
    public function setScoring(\StructType\Scoring $scoring = null)
    {
        $this->Scoring = $scoring;
        return $this;
    }
    /**
     * Get OkonomiSammendragForetak value
     * @return \StructType\OkonomiSammendragForetak[]|null
     */
    public function getOkonomiSammendragForetak()
    {
        return $this->OkonomiSammendragForetak;
    }
    /**
     * Set OkonomiSammendragForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiSammendragForetak[] $okonomiSammendragForetak
     * @return \StructType\HentForetakResponse
     */
    public function setOkonomiSammendragForetak(array $okonomiSammendragForetak = array())
    {
        foreach ($okonomiSammendragForetak as $hentForetakResponseOkonomiSammendragForetakItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseOkonomiSammendragForetakItem instanceof \StructType\OkonomiSammendragForetak) {
                throw new \InvalidArgumentException(sprintf('The OkonomiSammendragForetak property can only contain items of \StructType\OkonomiSammendragForetak, "%s" given', is_object($hentForetakResponseOkonomiSammendragForetakItem) ? get_class($hentForetakResponseOkonomiSammendragForetakItem) : gettype($hentForetakResponseOkonomiSammendragForetakItem)), __LINE__);
            }
        }
        $this->OkonomiSammendragForetak = $okonomiSammendragForetak;
        return $this;
    }
    /**
     * Add item to OkonomiSammendragForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiSammendragForetak $item
     * @return \StructType\HentForetakResponse
     */
    public function addToOkonomiSammendragForetak(\StructType\OkonomiSammendragForetak $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OkonomiSammendragForetak) {
            throw new \InvalidArgumentException(sprintf('The OkonomiSammendragForetak property can only contain items of \StructType\OkonomiSammendragForetak, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OkonomiSammendragForetak[] = $item;
        return $this;
    }
    /**
     * Get OkonomiSammendragKonsern value
     * @return \StructType\OkonomiSammendragKonsern[]|null
     */
    public function getOkonomiSammendragKonsern()
    {
        return $this->OkonomiSammendragKonsern;
    }
    /**
     * Set OkonomiSammendragKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiSammendragKonsern[] $okonomiSammendragKonsern
     * @return \StructType\HentForetakResponse
     */
    public function setOkonomiSammendragKonsern(array $okonomiSammendragKonsern = array())
    {
        foreach ($okonomiSammendragKonsern as $hentForetakResponseOkonomiSammendragKonsernItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseOkonomiSammendragKonsernItem instanceof \StructType\OkonomiSammendragKonsern) {
                throw new \InvalidArgumentException(sprintf('The OkonomiSammendragKonsern property can only contain items of \StructType\OkonomiSammendragKonsern, "%s" given', is_object($hentForetakResponseOkonomiSammendragKonsernItem) ? get_class($hentForetakResponseOkonomiSammendragKonsernItem) : gettype($hentForetakResponseOkonomiSammendragKonsernItem)), __LINE__);
            }
        }
        $this->OkonomiSammendragKonsern = $okonomiSammendragKonsern;
        return $this;
    }
    /**
     * Add item to OkonomiSammendragKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiSammendragKonsern $item
     * @return \StructType\HentForetakResponse
     */
    public function addToOkonomiSammendragKonsern(\StructType\OkonomiSammendragKonsern $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OkonomiSammendragKonsern) {
            throw new \InvalidArgumentException(sprintf('The OkonomiSammendragKonsern property can only contain items of \StructType\OkonomiSammendragKonsern, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OkonomiSammendragKonsern[] = $item;
        return $this;
    }
    /**
     * Get OkonomiDetaljerForetak value
     * @return \StructType\OkonomiDetaljerForetak[]|null
     */
    public function getOkonomiDetaljerForetak()
    {
        return $this->OkonomiDetaljerForetak;
    }
    /**
     * Set OkonomiDetaljerForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiDetaljerForetak[] $okonomiDetaljerForetak
     * @return \StructType\HentForetakResponse
     */
    public function setOkonomiDetaljerForetak(array $okonomiDetaljerForetak = array())
    {
        foreach ($okonomiDetaljerForetak as $hentForetakResponseOkonomiDetaljerForetakItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseOkonomiDetaljerForetakItem instanceof \StructType\OkonomiDetaljerForetak) {
                throw new \InvalidArgumentException(sprintf('The OkonomiDetaljerForetak property can only contain items of \StructType\OkonomiDetaljerForetak, "%s" given', is_object($hentForetakResponseOkonomiDetaljerForetakItem) ? get_class($hentForetakResponseOkonomiDetaljerForetakItem) : gettype($hentForetakResponseOkonomiDetaljerForetakItem)), __LINE__);
            }
        }
        $this->OkonomiDetaljerForetak = $okonomiDetaljerForetak;
        return $this;
    }
    /**
     * Add item to OkonomiDetaljerForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiDetaljerForetak $item
     * @return \StructType\HentForetakResponse
     */
    public function addToOkonomiDetaljerForetak(\StructType\OkonomiDetaljerForetak $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OkonomiDetaljerForetak) {
            throw new \InvalidArgumentException(sprintf('The OkonomiDetaljerForetak property can only contain items of \StructType\OkonomiDetaljerForetak, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OkonomiDetaljerForetak[] = $item;
        return $this;
    }
    /**
     * Get OkonomiDetaljerKonsern value
     * @return \StructType\OkonomiDetaljerKonsern[]|null
     */
    public function getOkonomiDetaljerKonsern()
    {
        return $this->OkonomiDetaljerKonsern;
    }
    /**
     * Set OkonomiDetaljerKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiDetaljerKonsern[] $okonomiDetaljerKonsern
     * @return \StructType\HentForetakResponse
     */
    public function setOkonomiDetaljerKonsern(array $okonomiDetaljerKonsern = array())
    {
        foreach ($okonomiDetaljerKonsern as $hentForetakResponseOkonomiDetaljerKonsernItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseOkonomiDetaljerKonsernItem instanceof \StructType\OkonomiDetaljerKonsern) {
                throw new \InvalidArgumentException(sprintf('The OkonomiDetaljerKonsern property can only contain items of \StructType\OkonomiDetaljerKonsern, "%s" given', is_object($hentForetakResponseOkonomiDetaljerKonsernItem) ? get_class($hentForetakResponseOkonomiDetaljerKonsernItem) : gettype($hentForetakResponseOkonomiDetaljerKonsernItem)), __LINE__);
            }
        }
        $this->OkonomiDetaljerKonsern = $okonomiDetaljerKonsern;
        return $this;
    }
    /**
     * Add item to OkonomiDetaljerKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\OkonomiDetaljerKonsern $item
     * @return \StructType\HentForetakResponse
     */
    public function addToOkonomiDetaljerKonsern(\StructType\OkonomiDetaljerKonsern $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OkonomiDetaljerKonsern) {
            throw new \InvalidArgumentException(sprintf('The OkonomiDetaljerKonsern property can only contain items of \StructType\OkonomiDetaljerKonsern, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OkonomiDetaljerKonsern[] = $item;
        return $this;
    }
    /**
     * Get EiendelerForetak value
     * @return \StructType\EiendelerForetak[]|null
     */
    public function getEiendelerForetak()
    {
        return $this->EiendelerForetak;
    }
    /**
     * Set EiendelerForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\EiendelerForetak[] $eiendelerForetak
     * @return \StructType\HentForetakResponse
     */
    public function setEiendelerForetak(array $eiendelerForetak = array())
    {
        foreach ($eiendelerForetak as $hentForetakResponseEiendelerForetakItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseEiendelerForetakItem instanceof \StructType\EiendelerForetak) {
                throw new \InvalidArgumentException(sprintf('The EiendelerForetak property can only contain items of \StructType\EiendelerForetak, "%s" given', is_object($hentForetakResponseEiendelerForetakItem) ? get_class($hentForetakResponseEiendelerForetakItem) : gettype($hentForetakResponseEiendelerForetakItem)), __LINE__);
            }
        }
        $this->EiendelerForetak = $eiendelerForetak;
        return $this;
    }
    /**
     * Add item to EiendelerForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\EiendelerForetak $item
     * @return \StructType\HentForetakResponse
     */
    public function addToEiendelerForetak(\StructType\EiendelerForetak $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EiendelerForetak) {
            throw new \InvalidArgumentException(sprintf('The EiendelerForetak property can only contain items of \StructType\EiendelerForetak, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EiendelerForetak[] = $item;
        return $this;
    }
    /**
     * Get EiendelerKonsern value
     * @return \StructType\EiendelerKonsern[]|null
     */
    public function getEiendelerKonsern()
    {
        return $this->EiendelerKonsern;
    }
    /**
     * Set EiendelerKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\EiendelerKonsern[] $eiendelerKonsern
     * @return \StructType\HentForetakResponse
     */
    public function setEiendelerKonsern(array $eiendelerKonsern = array())
    {
        foreach ($eiendelerKonsern as $hentForetakResponseEiendelerKonsernItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseEiendelerKonsernItem instanceof \StructType\EiendelerKonsern) {
                throw new \InvalidArgumentException(sprintf('The EiendelerKonsern property can only contain items of \StructType\EiendelerKonsern, "%s" given', is_object($hentForetakResponseEiendelerKonsernItem) ? get_class($hentForetakResponseEiendelerKonsernItem) : gettype($hentForetakResponseEiendelerKonsernItem)), __LINE__);
            }
        }
        $this->EiendelerKonsern = $eiendelerKonsern;
        return $this;
    }
    /**
     * Add item to EiendelerKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\EiendelerKonsern $item
     * @return \StructType\HentForetakResponse
     */
    public function addToEiendelerKonsern(\StructType\EiendelerKonsern $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EiendelerKonsern) {
            throw new \InvalidArgumentException(sprintf('The EiendelerKonsern property can only contain items of \StructType\EiendelerKonsern, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EiendelerKonsern[] = $item;
        return $this;
    }
    /**
     * Get GjeldEgenkapitalForetak value
     * @return \StructType\GjeldEgenkapitalForetak[]|null
     */
    public function getGjeldEgenkapitalForetak()
    {
        return $this->GjeldEgenkapitalForetak;
    }
    /**
     * Set GjeldEgenkapitalForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\GjeldEgenkapitalForetak[] $gjeldEgenkapitalForetak
     * @return \StructType\HentForetakResponse
     */
    public function setGjeldEgenkapitalForetak(array $gjeldEgenkapitalForetak = array())
    {
        foreach ($gjeldEgenkapitalForetak as $hentForetakResponseGjeldEgenkapitalForetakItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseGjeldEgenkapitalForetakItem instanceof \StructType\GjeldEgenkapitalForetak) {
                throw new \InvalidArgumentException(sprintf('The GjeldEgenkapitalForetak property can only contain items of \StructType\GjeldEgenkapitalForetak, "%s" given', is_object($hentForetakResponseGjeldEgenkapitalForetakItem) ? get_class($hentForetakResponseGjeldEgenkapitalForetakItem) : gettype($hentForetakResponseGjeldEgenkapitalForetakItem)), __LINE__);
            }
        }
        $this->GjeldEgenkapitalForetak = $gjeldEgenkapitalForetak;
        return $this;
    }
    /**
     * Add item to GjeldEgenkapitalForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\GjeldEgenkapitalForetak $item
     * @return \StructType\HentForetakResponse
     */
    public function addToGjeldEgenkapitalForetak(\StructType\GjeldEgenkapitalForetak $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GjeldEgenkapitalForetak) {
            throw new \InvalidArgumentException(sprintf('The GjeldEgenkapitalForetak property can only contain items of \StructType\GjeldEgenkapitalForetak, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GjeldEgenkapitalForetak[] = $item;
        return $this;
    }
    /**
     * Get GjeldEgenkapitalKonsern value
     * @return \StructType\GjeldEgenkapitalKonsern[]|null
     */
    public function getGjeldEgenkapitalKonsern()
    {
        return $this->GjeldEgenkapitalKonsern;
    }
    /**
     * Set GjeldEgenkapitalKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\GjeldEgenkapitalKonsern[] $gjeldEgenkapitalKonsern
     * @return \StructType\HentForetakResponse
     */
    public function setGjeldEgenkapitalKonsern(array $gjeldEgenkapitalKonsern = array())
    {
        foreach ($gjeldEgenkapitalKonsern as $hentForetakResponseGjeldEgenkapitalKonsernItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseGjeldEgenkapitalKonsernItem instanceof \StructType\GjeldEgenkapitalKonsern) {
                throw new \InvalidArgumentException(sprintf('The GjeldEgenkapitalKonsern property can only contain items of \StructType\GjeldEgenkapitalKonsern, "%s" given', is_object($hentForetakResponseGjeldEgenkapitalKonsernItem) ? get_class($hentForetakResponseGjeldEgenkapitalKonsernItem) : gettype($hentForetakResponseGjeldEgenkapitalKonsernItem)), __LINE__);
            }
        }
        $this->GjeldEgenkapitalKonsern = $gjeldEgenkapitalKonsern;
        return $this;
    }
    /**
     * Add item to GjeldEgenkapitalKonsern value
     * @throws \InvalidArgumentException
     * @param \StructType\GjeldEgenkapitalKonsern $item
     * @return \StructType\HentForetakResponse
     */
    public function addToGjeldEgenkapitalKonsern(\StructType\GjeldEgenkapitalKonsern $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GjeldEgenkapitalKonsern) {
            throw new \InvalidArgumentException(sprintf('The GjeldEgenkapitalKonsern property can only contain items of \StructType\GjeldEgenkapitalKonsern, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GjeldEgenkapitalKonsern[] = $item;
        return $this;
    }
    /**
     * Get Revisoranmerkninger value
     * @return \StructType\Revisoranmerkning[]|null
     */
    public function getRevisoranmerkninger()
    {
        return $this->Revisoranmerkninger;
    }
    /**
     * Set Revisoranmerkninger value
     * @throws \InvalidArgumentException
     * @param \StructType\Revisoranmerkning[] $revisoranmerkninger
     * @return \StructType\HentForetakResponse
     */
    public function setRevisoranmerkninger(array $revisoranmerkninger = array())
    {
        foreach ($revisoranmerkninger as $hentForetakResponseRevisoranmerkningerItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseRevisoranmerkningerItem instanceof \StructType\Revisoranmerkning) {
                throw new \InvalidArgumentException(sprintf('The Revisoranmerkninger property can only contain items of \StructType\Revisoranmerkning, "%s" given', is_object($hentForetakResponseRevisoranmerkningerItem) ? get_class($hentForetakResponseRevisoranmerkningerItem) : gettype($hentForetakResponseRevisoranmerkningerItem)), __LINE__);
            }
        }
        $this->Revisoranmerkninger = $revisoranmerkninger;
        return $this;
    }
    /**
     * Add item to Revisoranmerkninger value
     * @throws \InvalidArgumentException
     * @param \StructType\Revisoranmerkning $item
     * @return \StructType\HentForetakResponse
     */
    public function addToRevisoranmerkninger(\StructType\Revisoranmerkning $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Revisoranmerkning) {
            throw new \InvalidArgumentException(sprintf('The Revisoranmerkninger property can only contain items of \StructType\Revisoranmerkning, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Revisoranmerkninger[] = $item;
        return $this;
    }
    /**
     * Get AvdelingData value
     * @return \StructType\AvdelingData|null
     */
    public function getAvdelingData()
    {
        return $this->AvdelingData;
    }
    /**
     * Set AvdelingData value
     * @param \StructType\AvdelingData $avdelingData
     * @return \StructType\HentForetakResponse
     */
    public function setAvdelingData(\StructType\AvdelingData $avdelingData = null)
    {
        $this->AvdelingData = $avdelingData;
        return $this;
    }
    /**
     * Get Rettighetshavere value
     * @return \StructType\Rettighetshavere[]|null
     */
    public function getRettighetshavere()
    {
        return $this->Rettighetshavere;
    }
    /**
     * Set Rettighetshavere value
     * @throws \InvalidArgumentException
     * @param \StructType\Rettighetshavere[] $rettighetshavere
     * @return \StructType\HentForetakResponse
     */
    public function setRettighetshavere(array $rettighetshavere = array())
    {
        foreach ($rettighetshavere as $hentForetakResponseRettighetshavereItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseRettighetshavereItem instanceof \StructType\Rettighetshavere) {
                throw new \InvalidArgumentException(sprintf('The Rettighetshavere property can only contain items of \StructType\Rettighetshavere, "%s" given', is_object($hentForetakResponseRettighetshavereItem) ? get_class($hentForetakResponseRettighetshavereItem) : gettype($hentForetakResponseRettighetshavereItem)), __LINE__);
            }
        }
        $this->Rettighetshavere = $rettighetshavere;
        return $this;
    }
    /**
     * Add item to Rettighetshavere value
     * @throws \InvalidArgumentException
     * @param \StructType\Rettighetshavere $item
     * @return \StructType\HentForetakResponse
     */
    public function addToRettighetshavere(\StructType\Rettighetshavere $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rettighetshavere) {
            throw new \InvalidArgumentException(sprintf('The Rettighetshavere property can only contain items of \StructType\Rettighetshavere, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Rettighetshavere[] = $item;
        return $this;
    }
    /**
     * Get EiendomNorgeListe value
     * @return \StructType\EiendomNorgeListe[]|null
     */
    public function getEiendomNorgeListe()
    {
        return $this->EiendomNorgeListe;
    }
    /**
     * Set EiendomNorgeListe value
     * @throws \InvalidArgumentException
     * @param \StructType\EiendomNorgeListe[] $eiendomNorgeListe
     * @return \StructType\HentForetakResponse
     */
    public function setEiendomNorgeListe(array $eiendomNorgeListe = array())
    {
        foreach ($eiendomNorgeListe as $hentForetakResponseEiendomNorgeListeItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseEiendomNorgeListeItem instanceof \StructType\EiendomNorgeListe) {
                throw new \InvalidArgumentException(sprintf('The EiendomNorgeListe property can only contain items of \StructType\EiendomNorgeListe, "%s" given', is_object($hentForetakResponseEiendomNorgeListeItem) ? get_class($hentForetakResponseEiendomNorgeListeItem) : gettype($hentForetakResponseEiendomNorgeListeItem)), __LINE__);
            }
        }
        $this->EiendomNorgeListe = $eiendomNorgeListe;
        return $this;
    }
    /**
     * Add item to EiendomNorgeListe value
     * @throws \InvalidArgumentException
     * @param \StructType\EiendomNorgeListe $item
     * @return \StructType\HentForetakResponse
     */
    public function addToEiendomNorgeListe(\StructType\EiendomNorgeListe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EiendomNorgeListe) {
            throw new \InvalidArgumentException(sprintf('The EiendomNorgeListe property can only contain items of \StructType\EiendomNorgeListe, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EiendomNorgeListe[] = $item;
        return $this;
    }
    /**
     * Get FullmaktForetak value
     * @return \StructType\FullmaktForetak[]|null
     */
    public function getFullmaktForetak()
    {
        return $this->FullmaktForetak;
    }
    /**
     * Set FullmaktForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\FullmaktForetak[] $fullmaktForetak
     * @return \StructType\HentForetakResponse
     */
    public function setFullmaktForetak(array $fullmaktForetak = array())
    {
        foreach ($fullmaktForetak as $hentForetakResponseFullmaktForetakItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseFullmaktForetakItem instanceof \StructType\FullmaktForetak) {
                throw new \InvalidArgumentException(sprintf('The FullmaktForetak property can only contain items of \StructType\FullmaktForetak, "%s" given', is_object($hentForetakResponseFullmaktForetakItem) ? get_class($hentForetakResponseFullmaktForetakItem) : gettype($hentForetakResponseFullmaktForetakItem)), __LINE__);
            }
        }
        $this->FullmaktForetak = $fullmaktForetak;
        return $this;
    }
    /**
     * Add item to FullmaktForetak value
     * @throws \InvalidArgumentException
     * @param \StructType\FullmaktForetak $item
     * @return \StructType\HentForetakResponse
     */
    public function addToFullmaktForetak(\StructType\FullmaktForetak $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FullmaktForetak) {
            throw new \InvalidArgumentException(sprintf('The FullmaktForetak property can only contain items of \StructType\FullmaktForetak, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FullmaktForetak[] = $item;
        return $this;
    }
    /**
     * Get GjenpartData value
     * @return \StructType\GjenpartData|null
     */
    public function getGjenpartData()
    {
        return $this->GjenpartData;
    }
    /**
     * Set GjenpartData value
     * @param \StructType\GjenpartData $gjenpartData
     * @return \StructType\HentForetakResponse
     */
    public function setGjenpartData(\StructType\GjenpartData $gjenpartData = null)
    {
        $this->GjenpartData = $gjenpartData;
        return $this;
    }
    /**
     * Get Testinfo value
     * @return \StructType\Testinfo|null
     */
    public function getTestinfo()
    {
        return $this->Testinfo;
    }
    /**
     * Set Testinfo value
     * @param \StructType\Testinfo $testinfo
     * @return \StructType\HentForetakResponse
     */
    public function setTestinfo(\StructType\Testinfo $testinfo = null)
    {
        $this->Testinfo = $testinfo;
        return $this;
    }
    /**
     * Get Meldinger value
     * @return \StructType\Meldinger[]|null
     */
    public function getMeldinger()
    {
        return $this->Meldinger;
    }
    /**
     * Set Meldinger value
     * @throws \InvalidArgumentException
     * @param \StructType\Meldinger[] $meldinger
     * @return \StructType\HentForetakResponse
     */
    public function setMeldinger(array $meldinger = array())
    {
        foreach ($meldinger as $hentForetakResponseMeldingerItem) {
            // validation for constraint: itemType
            if (!$hentForetakResponseMeldingerItem instanceof \StructType\Meldinger) {
                throw new \InvalidArgumentException(sprintf('The Meldinger property can only contain items of \StructType\Meldinger, "%s" given', is_object($hentForetakResponseMeldingerItem) ? get_class($hentForetakResponseMeldingerItem) : gettype($hentForetakResponseMeldingerItem)), __LINE__);
            }
        }
        $this->Meldinger = $meldinger;
        return $this;
    }
    /**
     * Add item to Meldinger value
     * @throws \InvalidArgumentException
     * @param \StructType\Meldinger $item
     * @return \StructType\HentForetakResponse
     */
    public function addToMeldinger(\StructType\Meldinger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Meldinger) {
            throw new \InvalidArgumentException(sprintf('The Meldinger property can only contain items of \StructType\Meldinger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Meldinger[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HentForetakResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
