<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HentForetak StructType
 * @subpackage Structs
 */
class HentForetak extends AbstractStructBase
{
    /**
     * The Dunsnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Dunsnr;
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Orgnr;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Navn;
    /**
     * The NavnAdresse
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NavnAdresse;
    /**
     * The Rapport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rapport;
    /**
     * The Scoremodell
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Scoremodell;
    /**
     * The EgenData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $EgenData;
    /**
     * The JuridiskVerv
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $JuridiskVerv;
    /**
     * The Grunnfakta
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Grunnfakta;
    /**
     * The AksjonarDatter
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AksjonarDatter;
    /**
     * The ReelleRettighetshavere
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ReelleRettighetshavere;
    /**
     * The Beta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Beta;
    /**
     * The OkonomiDetaljer
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OkonomiDetaljer;
    /**
     * The KonsernLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KonsernLink;
    /**
     * The Losore
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Losore;
    /**
     * The Eiendom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Eiendom;
    /**
     * The Fullmakt
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Fullmakt;
    /**
     * The TelefonVerv
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TelefonVerv;
    /**
     * The Testinfo
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Testinfo;
    /**
     * Constructor method for HentForetak
     * @uses HentForetak::setDunsnr()
     * @uses HentForetak::setOrgnr()
     * @uses HentForetak::setNavn()
     * @uses HentForetak::setNavnAdresse()
     * @uses HentForetak::setRapport()
     * @uses HentForetak::setScoremodell()
     * @uses HentForetak::setEgenData()
     * @uses HentForetak::setJuridiskVerv()
     * @uses HentForetak::setGrunnfakta()
     * @uses HentForetak::setAksjonarDatter()
     * @uses HentForetak::setReelleRettighetshavere()
     * @uses HentForetak::setBeta()
     * @uses HentForetak::setOkonomiDetaljer()
     * @uses HentForetak::setKonsernLink()
     * @uses HentForetak::setLosore()
     * @uses HentForetak::setEiendom()
     * @uses HentForetak::setFullmakt()
     * @uses HentForetak::setTelefonVerv()
     * @uses HentForetak::setTestinfo()
     * @param int $dunsnr
     * @param int $orgnr
     * @param string $navn
     * @param bool $navnAdresse
     * @param string $rapport
     * @param int $scoremodell
     * @param int[] $egenData
     * @param bool $juridiskVerv
     * @param bool $grunnfakta
     * @param bool $aksjonarDatter
     * @param bool $reelleRettighetshavere
     * @param string $beta
     * @param int $okonomiDetaljer
     * @param string $konsernLink
     * @param bool $losore
     * @param string $eiendom
     * @param bool $fullmakt
     * @param bool $telefonVerv
     * @param bool $testinfo
     */
    public function __construct($dunsnr = 0, $orgnr = 0, $navn = null, $navnAdresse = false, $rapport = null, $scoremodell = 0, array $egenData = array(), $juridiskVerv = false, $grunnfakta = false, $aksjonarDatter = false, $reelleRettighetshavere = false, $beta = null, $okonomiDetaljer = 0, $konsernLink = null, $losore = false, $eiendom = null, $fullmakt = false, $telefonVerv = false, $testinfo = false)
    {
        $this
            ->setDunsnr($dunsnr)
            ->setOrgnr($orgnr)
            ->setNavn($navn)
            ->setNavnAdresse($navnAdresse)
            ->setRapport($rapport)
            ->setScoremodell($scoremodell)
            ->setEgenData($egenData)
            ->setJuridiskVerv($juridiskVerv)
            ->setGrunnfakta($grunnfakta)
            ->setAksjonarDatter($aksjonarDatter)
            ->setReelleRettighetshavere($reelleRettighetshavere)
            ->setBeta($beta)
            ->setOkonomiDetaljer($okonomiDetaljer)
            ->setKonsernLink($konsernLink)
            ->setLosore($losore)
            ->setEiendom($eiendom)
            ->setFullmakt($fullmakt)
            ->setTelefonVerv($telefonVerv)
            ->setTestinfo($testinfo);
    }
    /**
     * Get Dunsnr value
     * @return int|null
     */
    public function getDunsnr()
    {
        return $this->Dunsnr;
    }
    /**
     * Set Dunsnr value
     * @param int $dunsnr
     * @return \StructType\HentForetak
     */
    public function setDunsnr($dunsnr = 0)
    {
        // validation for constraint: int
        if (!is_null($dunsnr) && !is_numeric($dunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunsnr)), __LINE__);
        }
        $this->Dunsnr = $dunsnr;
        return $this;
    }
    /**
     * Get Orgnr value
     * @return int|null
     */
    public function getOrgnr()
    {
        return $this->Orgnr;
    }
    /**
     * Set Orgnr value
     * @param int $orgnr
     * @return \StructType\HentForetak
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        $this->Orgnr = $orgnr;
        return $this;
    }
    /**
     * Get Navn value
     * @return string|null
     */
    public function getNavn()
    {
        return $this->Navn;
    }
    /**
     * Set Navn value
     * @param string $navn
     * @return \StructType\HentForetak
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        $this->Navn = $navn;
        return $this;
    }
    /**
     * Get NavnAdresse value
     * @return bool|null
     */
    public function getNavnAdresse()
    {
        return $this->NavnAdresse;
    }
    /**
     * Set NavnAdresse value
     * @param bool $navnAdresse
     * @return \StructType\HentForetak
     */
    public function setNavnAdresse($navnAdresse = false)
    {
        // validation for constraint: boolean
        if (!is_null($navnAdresse) && !is_bool($navnAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($navnAdresse)), __LINE__);
        }
        $this->NavnAdresse = $navnAdresse;
        return $this;
    }
    /**
     * Get Rapport value
     * @return string|null
     */
    public function getRapport()
    {
        return $this->Rapport;
    }
    /**
     * Set Rapport value
     * @uses \EnumType\RapportVerdier::valueIsValid()
     * @uses \EnumType\RapportVerdier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rapport
     * @return \StructType\HentForetak
     */
    public function setRapport($rapport = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RapportVerdier::valueIsValid($rapport)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rapport, implode(', ', \EnumType\RapportVerdier::getValidValues())), __LINE__);
        }
        $this->Rapport = $rapport;
        return $this;
    }
    /**
     * Get Scoremodell value
     * @return int|null
     */
    public function getScoremodell()
    {
        return $this->Scoremodell;
    }
    /**
     * Set Scoremodell value
     * @param int $scoremodell
     * @return \StructType\HentForetak
     */
    public function setScoremodell($scoremodell = 0)
    {
        // validation for constraint: int
        if (!is_null($scoremodell) && !is_numeric($scoremodell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scoremodell)), __LINE__);
        }
        $this->Scoremodell = $scoremodell;
        return $this;
    }
    /**
     * Get EgenData value
     * @return int[]|null
     */
    public function getEgenData()
    {
        return $this->EgenData;
    }
    /**
     * Set EgenData value
     * @throws \InvalidArgumentException
     * @param int[] $egenData
     * @return \StructType\HentForetak
     */
    public function setEgenData(array $egenData = array())
    {
        foreach ($egenData as $hentForetakEgenDataItem) {
            // validation for constraint: itemType
            if (!is_numeric($hentForetakEgenDataItem)) {
                throw new \InvalidArgumentException(sprintf('The EgenData property can only contain items of int, "%s" given', is_object($hentForetakEgenDataItem) ? get_class($hentForetakEgenDataItem) : gettype($hentForetakEgenDataItem)), __LINE__);
            }
        }
        $this->EgenData = $egenData;
        return $this;
    }
    /**
     * Add item to EgenData value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\HentForetak
     */
    public function addToEgenData($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The EgenData property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EgenData[] = $item;
        return $this;
    }
    /**
     * Get JuridiskVerv value
     * @return bool|null
     */
    public function getJuridiskVerv()
    {
        return $this->JuridiskVerv;
    }
    /**
     * Set JuridiskVerv value
     * @param bool $juridiskVerv
     * @return \StructType\HentForetak
     */
    public function setJuridiskVerv($juridiskVerv = false)
    {
        // validation for constraint: boolean
        if (!is_null($juridiskVerv) && !is_bool($juridiskVerv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($juridiskVerv)), __LINE__);
        }
        $this->JuridiskVerv = $juridiskVerv;
        return $this;
    }
    /**
     * Get Grunnfakta value
     * @return bool|null
     */
    public function getGrunnfakta()
    {
        return $this->Grunnfakta;
    }
    /**
     * Set Grunnfakta value
     * @param bool $grunnfakta
     * @return \StructType\HentForetak
     */
    public function setGrunnfakta($grunnfakta = false)
    {
        // validation for constraint: boolean
        if (!is_null($grunnfakta) && !is_bool($grunnfakta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($grunnfakta)), __LINE__);
        }
        $this->Grunnfakta = $grunnfakta;
        return $this;
    }
    /**
     * Get AksjonarDatter value
     * @return bool|null
     */
    public function getAksjonarDatter()
    {
        return $this->AksjonarDatter;
    }
    /**
     * Set AksjonarDatter value
     * @param bool $aksjonarDatter
     * @return \StructType\HentForetak
     */
    public function setAksjonarDatter($aksjonarDatter = false)
    {
        // validation for constraint: boolean
        if (!is_null($aksjonarDatter) && !is_bool($aksjonarDatter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aksjonarDatter)), __LINE__);
        }
        $this->AksjonarDatter = $aksjonarDatter;
        return $this;
    }
    /**
     * Get ReelleRettighetshavere value
     * @return bool|null
     */
    public function getReelleRettighetshavere()
    {
        return $this->ReelleRettighetshavere;
    }
    /**
     * Set ReelleRettighetshavere value
     * @param bool $reelleRettighetshavere
     * @return \StructType\HentForetak
     */
    public function setReelleRettighetshavere($reelleRettighetshavere = false)
    {
        // validation for constraint: boolean
        if (!is_null($reelleRettighetshavere) && !is_bool($reelleRettighetshavere)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reelleRettighetshavere)), __LINE__);
        }
        $this->ReelleRettighetshavere = $reelleRettighetshavere;
        return $this;
    }
    /**
     * Get Beta value
     * @return string|null
     */
    public function getBeta()
    {
        return $this->Beta;
    }
    /**
     * Set Beta value
     * @uses \EnumType\BetaVerdier::valueIsValid()
     * @uses \EnumType\BetaVerdier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $beta
     * @return \StructType\HentForetak
     */
    public function setBeta($beta = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BetaVerdier::valueIsValid($beta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $beta, implode(', ', \EnumType\BetaVerdier::getValidValues())), __LINE__);
        }
        $this->Beta = $beta;
        return $this;
    }
    /**
     * Get OkonomiDetaljer value
     * @return int|null
     */
    public function getOkonomiDetaljer()
    {
        return $this->OkonomiDetaljer;
    }
    /**
     * Set OkonomiDetaljer value
     * @param int $okonomiDetaljer
     * @return \StructType\HentForetak
     */
    public function setOkonomiDetaljer($okonomiDetaljer = 0)
    {
        // validation for constraint: int
        if (!is_null($okonomiDetaljer) && !is_numeric($okonomiDetaljer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($okonomiDetaljer)), __LINE__);
        }
        $this->OkonomiDetaljer = $okonomiDetaljer;
        return $this;
    }
    /**
     * Get KonsernLink value
     * @return string|null
     */
    public function getKonsernLink()
    {
        return $this->KonsernLink;
    }
    /**
     * Set KonsernLink value
     * @uses \EnumType\KonsernlinkType::valueIsValid()
     * @uses \EnumType\KonsernlinkType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $konsernLink
     * @return \StructType\HentForetak
     */
    public function setKonsernLink($konsernLink = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KonsernlinkType::valueIsValid($konsernLink)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $konsernLink, implode(', ', \EnumType\KonsernlinkType::getValidValues())), __LINE__);
        }
        $this->KonsernLink = $konsernLink;
        return $this;
    }
    /**
     * Get Losore value
     * @return bool|null
     */
    public function getLosore()
    {
        return $this->Losore;
    }
    /**
     * Set Losore value
     * @param bool $losore
     * @return \StructType\HentForetak
     */
    public function setLosore($losore = false)
    {
        // validation for constraint: boolean
        if (!is_null($losore) && !is_bool($losore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($losore)), __LINE__);
        }
        $this->Losore = $losore;
        return $this;
    }
    /**
     * Get Eiendom value
     * @return string|null
     */
    public function getEiendom()
    {
        return $this->Eiendom;
    }
    /**
     * Set Eiendom value
     * @uses \EnumType\EiendomVerdier::valueIsValid()
     * @uses \EnumType\EiendomVerdier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eiendom
     * @return \StructType\HentForetak
     */
    public function setEiendom($eiendom = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EiendomVerdier::valueIsValid($eiendom)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eiendom, implode(', ', \EnumType\EiendomVerdier::getValidValues())), __LINE__);
        }
        $this->Eiendom = $eiendom;
        return $this;
    }
    /**
     * Get Fullmakt value
     * @return bool|null
     */
    public function getFullmakt()
    {
        return $this->Fullmakt;
    }
    /**
     * Set Fullmakt value
     * @param bool $fullmakt
     * @return \StructType\HentForetak
     */
    public function setFullmakt($fullmakt = false)
    {
        // validation for constraint: boolean
        if (!is_null($fullmakt) && !is_bool($fullmakt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fullmakt)), __LINE__);
        }
        $this->Fullmakt = $fullmakt;
        return $this;
    }
    /**
     * Get TelefonVerv value
     * @return bool|null
     */
    public function getTelefonVerv()
    {
        return $this->TelefonVerv;
    }
    /**
     * Set TelefonVerv value
     * @param bool $telefonVerv
     * @return \StructType\HentForetak
     */
    public function setTelefonVerv($telefonVerv = false)
    {
        // validation for constraint: boolean
        if (!is_null($telefonVerv) && !is_bool($telefonVerv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($telefonVerv)), __LINE__);
        }
        $this->TelefonVerv = $telefonVerv;
        return $this;
    }
    /**
     * Get Testinfo value
     * @return bool|null
     */
    public function getTestinfo()
    {
        return $this->Testinfo;
    }
    /**
     * Set Testinfo value
     * @param bool $testinfo
     * @return \StructType\HentForetak
     */
    public function setTestinfo($testinfo = false)
    {
        // validation for constraint: boolean
        if (!is_null($testinfo) && !is_bool($testinfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($testinfo)), __LINE__);
        }
        $this->Testinfo = $testinfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HentForetak
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
