<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FullmaktPerson StructType
 * @subpackage Structs
 */
class FullmaktPerson extends AbstractStructBase
{
    /**
     * The Internreferanse
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Internreferanse;
    /**
     * The FodtDato
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FodtDato;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Navn;
    /**
     * The Adresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Postnr;
    /**
     * The Poststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Poststed;
    /**
     * The FullmaktTypeKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullmaktTypeKode;
    /**
     * The FullmaktTypeTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullmaktTypeTekst;
    /**
     * The FullmaktKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullmaktKode;
    /**
     * The FullmaktTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullmaktTekst;
    /**
     * The Prioritet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Prioritet;
    /**
     * The Antall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Antall;
    /**
     * The Obligatorisk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Obligatorisk;
    /**
     * The Verv
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VervData[]
     */
    public $Verv;
    /**
     * Constructor method for FullmaktPerson
     * @uses FullmaktPerson::setInternreferanse()
     * @uses FullmaktPerson::setFodtDato()
     * @uses FullmaktPerson::setNavn()
     * @uses FullmaktPerson::setAdresse()
     * @uses FullmaktPerson::setPostnr()
     * @uses FullmaktPerson::setPoststed()
     * @uses FullmaktPerson::setFullmaktTypeKode()
     * @uses FullmaktPerson::setFullmaktTypeTekst()
     * @uses FullmaktPerson::setFullmaktKode()
     * @uses FullmaktPerson::setFullmaktTekst()
     * @uses FullmaktPerson::setPrioritet()
     * @uses FullmaktPerson::setAntall()
     * @uses FullmaktPerson::setObligatorisk()
     * @uses FullmaktPerson::setVerv()
     * @param int $internreferanse
     * @param string $fodtDato
     * @param string $navn
     * @param string $adresse
     * @param int $postnr
     * @param string $poststed
     * @param string $fullmaktTypeKode
     * @param string $fullmaktTypeTekst
     * @param string $fullmaktKode
     * @param string $fullmaktTekst
     * @param int $prioritet
     * @param int $antall
     * @param bool $obligatorisk
     * @param \StructType\VervData[] $verv
     */
    public function __construct($internreferanse = 0, $fodtDato = null, $navn = null, $adresse = null, $postnr = 0, $poststed = null, $fullmaktTypeKode = null, $fullmaktTypeTekst = null, $fullmaktKode = null, $fullmaktTekst = null, $prioritet = null, $antall = null, $obligatorisk = null, array $verv = array())
    {
        $this
            ->setInternreferanse($internreferanse)
            ->setFodtDato($fodtDato)
            ->setNavn($navn)
            ->setAdresse($adresse)
            ->setPostnr($postnr)
            ->setPoststed($poststed)
            ->setFullmaktTypeKode($fullmaktTypeKode)
            ->setFullmaktTypeTekst($fullmaktTypeTekst)
            ->setFullmaktKode($fullmaktKode)
            ->setFullmaktTekst($fullmaktTekst)
            ->setPrioritet($prioritet)
            ->setAntall($antall)
            ->setObligatorisk($obligatorisk)
            ->setVerv($verv);
    }
    /**
     * Get Internreferanse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInternreferanse()
    {
        return isset($this->Internreferanse) ? $this->Internreferanse : null;
    }
    /**
     * Set Internreferanse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $internreferanse
     * @return \StructType\FullmaktPerson
     */
    public function setInternreferanse($internreferanse = 0)
    {
        // validation for constraint: int
        if (!is_null($internreferanse) && !is_numeric($internreferanse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internreferanse)), __LINE__);
        }
        if (is_null($internreferanse) || (is_array($internreferanse) && empty($internreferanse))) {
            unset($this->Internreferanse);
        } else {
            $this->Internreferanse = $internreferanse;
        }
        return $this;
    }
    /**
     * Get FodtDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFodtDato()
    {
        return isset($this->FodtDato) ? $this->FodtDato : null;
    }
    /**
     * Set FodtDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fodtDato
     * @return \StructType\FullmaktPerson
     */
    public function setFodtDato($fodtDato = null)
    {
        // validation for constraint: string
        if (!is_null($fodtDato) && !is_string($fodtDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fodtDato)), __LINE__);
        }
        if (is_null($fodtDato) || (is_array($fodtDato) && empty($fodtDato))) {
            unset($this->FodtDato);
        } else {
            $this->FodtDato = $fodtDato;
        }
        return $this;
    }
    /**
     * Get Navn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->Navn) ? $this->Navn : null;
    }
    /**
     * Set Navn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navn
     * @return \StructType\FullmaktPerson
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->Navn);
        } else {
            $this->Navn = $navn;
        }
        return $this;
    }
    /**
     * Get Adresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdresse()
    {
        return isset($this->Adresse) ? $this->Adresse : null;
    }
    /**
     * Set Adresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adresse
     * @return \StructType\FullmaktPerson
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresse)), __LINE__);
        }
        if (is_null($adresse) || (is_array($adresse) && empty($adresse))) {
            unset($this->Adresse);
        } else {
            $this->Adresse = $adresse;
        }
        return $this;
    }
    /**
     * Get Postnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostnr()
    {
        return isset($this->Postnr) ? $this->Postnr : null;
    }
    /**
     * Set Postnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postnr
     * @return \StructType\FullmaktPerson
     */
    public function setPostnr($postnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postnr) && !is_numeric($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postnr)), __LINE__);
        }
        if (is_null($postnr) || (is_array($postnr) && empty($postnr))) {
            unset($this->Postnr);
        } else {
            $this->Postnr = $postnr;
        }
        return $this;
    }
    /**
     * Get Poststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPoststed()
    {
        return isset($this->Poststed) ? $this->Poststed : null;
    }
    /**
     * Set Poststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $poststed
     * @return \StructType\FullmaktPerson
     */
    public function setPoststed($poststed = null)
    {
        // validation for constraint: string
        if (!is_null($poststed) && !is_string($poststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poststed)), __LINE__);
        }
        if (is_null($poststed) || (is_array($poststed) && empty($poststed))) {
            unset($this->Poststed);
        } else {
            $this->Poststed = $poststed;
        }
        return $this;
    }
    /**
     * Get FullmaktTypeKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullmaktTypeKode()
    {
        return isset($this->FullmaktTypeKode) ? $this->FullmaktTypeKode : null;
    }
    /**
     * Set FullmaktTypeKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullmaktTypeKode
     * @return \StructType\FullmaktPerson
     */
    public function setFullmaktTypeKode($fullmaktTypeKode = null)
    {
        // validation for constraint: string
        if (!is_null($fullmaktTypeKode) && !is_string($fullmaktTypeKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullmaktTypeKode)), __LINE__);
        }
        if (is_null($fullmaktTypeKode) || (is_array($fullmaktTypeKode) && empty($fullmaktTypeKode))) {
            unset($this->FullmaktTypeKode);
        } else {
            $this->FullmaktTypeKode = $fullmaktTypeKode;
        }
        return $this;
    }
    /**
     * Get FullmaktTypeTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullmaktTypeTekst()
    {
        return isset($this->FullmaktTypeTekst) ? $this->FullmaktTypeTekst : null;
    }
    /**
     * Set FullmaktTypeTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullmaktTypeTekst
     * @return \StructType\FullmaktPerson
     */
    public function setFullmaktTypeTekst($fullmaktTypeTekst = null)
    {
        // validation for constraint: string
        if (!is_null($fullmaktTypeTekst) && !is_string($fullmaktTypeTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullmaktTypeTekst)), __LINE__);
        }
        if (is_null($fullmaktTypeTekst) || (is_array($fullmaktTypeTekst) && empty($fullmaktTypeTekst))) {
            unset($this->FullmaktTypeTekst);
        } else {
            $this->FullmaktTypeTekst = $fullmaktTypeTekst;
        }
        return $this;
    }
    /**
     * Get FullmaktKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullmaktKode()
    {
        return isset($this->FullmaktKode) ? $this->FullmaktKode : null;
    }
    /**
     * Set FullmaktKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullmaktKode
     * @return \StructType\FullmaktPerson
     */
    public function setFullmaktKode($fullmaktKode = null)
    {
        // validation for constraint: string
        if (!is_null($fullmaktKode) && !is_string($fullmaktKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullmaktKode)), __LINE__);
        }
        if (is_null($fullmaktKode) || (is_array($fullmaktKode) && empty($fullmaktKode))) {
            unset($this->FullmaktKode);
        } else {
            $this->FullmaktKode = $fullmaktKode;
        }
        return $this;
    }
    /**
     * Get FullmaktTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullmaktTekst()
    {
        return isset($this->FullmaktTekst) ? $this->FullmaktTekst : null;
    }
    /**
     * Set FullmaktTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullmaktTekst
     * @return \StructType\FullmaktPerson
     */
    public function setFullmaktTekst($fullmaktTekst = null)
    {
        // validation for constraint: string
        if (!is_null($fullmaktTekst) && !is_string($fullmaktTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullmaktTekst)), __LINE__);
        }
        if (is_null($fullmaktTekst) || (is_array($fullmaktTekst) && empty($fullmaktTekst))) {
            unset($this->FullmaktTekst);
        } else {
            $this->FullmaktTekst = $fullmaktTekst;
        }
        return $this;
    }
    /**
     * Get Prioritet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrioritet()
    {
        return isset($this->Prioritet) ? $this->Prioritet : null;
    }
    /**
     * Set Prioritet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prioritet
     * @return \StructType\FullmaktPerson
     */
    public function setPrioritet($prioritet = null)
    {
        // validation for constraint: int
        if (!is_null($prioritet) && !is_numeric($prioritet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prioritet)), __LINE__);
        }
        if (is_null($prioritet) || (is_array($prioritet) && empty($prioritet))) {
            unset($this->Prioritet);
        } else {
            $this->Prioritet = $prioritet;
        }
        return $this;
    }
    /**
     * Get Antall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAntall()
    {
        return isset($this->Antall) ? $this->Antall : null;
    }
    /**
     * Set Antall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $antall
     * @return \StructType\FullmaktPerson
     */
    public function setAntall($antall = null)
    {
        // validation for constraint: int
        if (!is_null($antall) && !is_numeric($antall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($antall)), __LINE__);
        }
        if (is_null($antall) || (is_array($antall) && empty($antall))) {
            unset($this->Antall);
        } else {
            $this->Antall = $antall;
        }
        return $this;
    }
    /**
     * Get Obligatorisk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getObligatorisk()
    {
        return isset($this->Obligatorisk) ? $this->Obligatorisk : null;
    }
    /**
     * Set Obligatorisk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $obligatorisk
     * @return \StructType\FullmaktPerson
     */
    public function setObligatorisk($obligatorisk = null)
    {
        // validation for constraint: boolean
        if (!is_null($obligatorisk) && !is_bool($obligatorisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($obligatorisk)), __LINE__);
        }
        if (is_null($obligatorisk) || (is_array($obligatorisk) && empty($obligatorisk))) {
            unset($this->Obligatorisk);
        } else {
            $this->Obligatorisk = $obligatorisk;
        }
        return $this;
    }
    /**
     * Get Verv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VervData[]|null
     */
    public function getVerv()
    {
        return isset($this->Verv) ? $this->Verv : null;
    }
    /**
     * Set Verv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VervData[] $verv
     * @return \StructType\FullmaktPerson
     */
    public function setVerv(array $verv = array())
    {
        foreach ($verv as $fullmaktPersonVervItem) {
            // validation for constraint: itemType
            if (!$fullmaktPersonVervItem instanceof \StructType\VervData) {
                throw new \InvalidArgumentException(sprintf('The Verv property can only contain items of \StructType\VervData, "%s" given', is_object($fullmaktPersonVervItem) ? get_class($fullmaktPersonVervItem) : gettype($fullmaktPersonVervItem)), __LINE__);
            }
        }
        if (is_null($verv) || (is_array($verv) && empty($verv))) {
            unset($this->Verv);
        } else {
            $this->Verv = $verv;
        }
        return $this;
    }
    /**
     * Add item to Verv value
     * @throws \InvalidArgumentException
     * @param \StructType\VervData $item
     * @return \StructType\FullmaktPerson
     */
    public function addToVerv(\StructType\VervData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VervData) {
            throw new \InvalidArgumentException(sprintf('The Verv property can only contain items of \StructType\VervData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Verv[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FullmaktPerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
