<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrukerAutorisasjon StructType
 * @subpackage Structs
 */
class BrukerAutorisasjon extends AbstractStructBase
{
    /**
     * The BrukerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BrukerID;
    /**
     * The Passord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Passord;
    /**
     * The Versjon
     * Meta informations extracted from the WSDL
     * - fixed: v2-1-4
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Versjon;
    /**
     * The SluttBruker
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SluttBruker;
    /**
     * The Referanse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referanse;
    /**
     * The ProduserElektroniskGjenpart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProduserElektroniskGjenpart;
    /**
     * The Gjenpart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Gjenpart
     */
    public $Gjenpart;
    /**
     * Constructor method for BrukerAutorisasjon
     * @uses BrukerAutorisasjon::setBrukerID()
     * @uses BrukerAutorisasjon::setPassord()
     * @uses BrukerAutorisasjon::setVersjon()
     * @uses BrukerAutorisasjon::setSluttBruker()
     * @uses BrukerAutorisasjon::setReferanse()
     * @uses BrukerAutorisasjon::setProduserElektroniskGjenpart()
     * @uses BrukerAutorisasjon::setGjenpart()
     * @param string $brukerID
     * @param string $passord
     * @param string $versjon
     * @param string $sluttBruker
     * @param string $referanse
     * @param string $produserElektroniskGjenpart
     * @param \StructType\Gjenpart $gjenpart
     */
    public function __construct($brukerID = null, $passord = null, $versjon = null, $sluttBruker = null, $referanse = null, $produserElektroniskGjenpart = null, \StructType\Gjenpart $gjenpart = null)
    {
        $this
            ->setBrukerID($brukerID)
            ->setPassord($passord)
            ->setVersjon($versjon)
            ->setSluttBruker($sluttBruker)
            ->setReferanse($referanse)
            ->setProduserElektroniskGjenpart($produserElektroniskGjenpart)
            ->setGjenpart($gjenpart);
    }
    /**
     * Get BrukerID value
     * @return string
     */
    public function getBrukerID()
    {
        return $this->BrukerID;
    }
    /**
     * Set BrukerID value
     * @param string $brukerID
     * @return \StructType\BrukerAutorisasjon
     */
    public function setBrukerID($brukerID = null)
    {
        // validation for constraint: string
        if (!is_null($brukerID) && !is_string($brukerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brukerID)), __LINE__);
        }
        $this->BrukerID = $brukerID;
        return $this;
    }
    /**
     * Get Passord value
     * @return string
     */
    public function getPassord()
    {
        return $this->Passord;
    }
    /**
     * Set Passord value
     * @param string $passord
     * @return \StructType\BrukerAutorisasjon
     */
    public function setPassord($passord = null)
    {
        // validation for constraint: string
        if (!is_null($passord) && !is_string($passord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passord)), __LINE__);
        }
        $this->Passord = $passord;
        return $this;
    }
    /**
     * Get Versjon value
     * @return string
     */
    public function getVersjon()
    {
        return $this->Versjon;
    }
    /**
     * Set Versjon value
     * @param string $versjon
     * @return \StructType\BrukerAutorisasjon
     */
    public function setVersjon($versjon = null)
    {
        // validation for constraint: string
        if (!is_null($versjon) && !is_string($versjon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versjon)), __LINE__);
        }
        $this->Versjon = $versjon;
        return $this;
    }
    /**
     * Get SluttBruker value
     * @return string|null
     */
    public function getSluttBruker()
    {
        return $this->SluttBruker;
    }
    /**
     * Set SluttBruker value
     * @param string $sluttBruker
     * @return \StructType\BrukerAutorisasjon
     */
    public function setSluttBruker($sluttBruker = null)
    {
        // validation for constraint: string
        if (!is_null($sluttBruker) && !is_string($sluttBruker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sluttBruker)), __LINE__);
        }
        $this->SluttBruker = $sluttBruker;
        return $this;
    }
    /**
     * Get Referanse value
     * @return string|null
     */
    public function getReferanse()
    {
        return $this->Referanse;
    }
    /**
     * Set Referanse value
     * @param string $referanse
     * @return \StructType\BrukerAutorisasjon
     */
    public function setReferanse($referanse = null)
    {
        // validation for constraint: string
        if (!is_null($referanse) && !is_string($referanse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referanse)), __LINE__);
        }
        $this->Referanse = $referanse;
        return $this;
    }
    /**
     * Get ProduserElektroniskGjenpart value
     * @return string|null
     */
    public function getProduserElektroniskGjenpart()
    {
        return $this->ProduserElektroniskGjenpart;
    }
    /**
     * Set ProduserElektroniskGjenpart value
     * @uses \EnumType\ProduserElektroniskGjenpartVerdier::valueIsValid()
     * @uses \EnumType\ProduserElektroniskGjenpartVerdier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $produserElektroniskGjenpart
     * @return \StructType\BrukerAutorisasjon
     */
    public function setProduserElektroniskGjenpart($produserElektroniskGjenpart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProduserElektroniskGjenpartVerdier::valueIsValid($produserElektroniskGjenpart)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $produserElektroniskGjenpart, implode(', ', \EnumType\ProduserElektroniskGjenpartVerdier::getValidValues())), __LINE__);
        }
        $this->ProduserElektroniskGjenpart = $produserElektroniskGjenpart;
        return $this;
    }
    /**
     * Get Gjenpart value
     * @return \StructType\Gjenpart|null
     */
    public function getGjenpart()
    {
        return $this->Gjenpart;
    }
    /**
     * Set Gjenpart value
     * @param \StructType\Gjenpart $gjenpart
     * @return \StructType\BrukerAutorisasjon
     */
    public function setGjenpart(\StructType\Gjenpart $gjenpart = null)
    {
        $this->Gjenpart = $gjenpart;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BrukerAutorisasjon
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
