<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BransjeData StructType
 * @subpackage Structs
 */
class BransjeData extends AbstractStructBase
{
    /**
     * The BransjeKode
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BransjeKode;
    /**
     * The BransjeTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BransjeTekst;
    /**
     * Constructor method for BransjeData
     * @uses BransjeData::setBransjeKode()
     * @uses BransjeData::setBransjeTekst()
     * @param int $bransjeKode
     * @param string $bransjeTekst
     */
    public function __construct($bransjeKode = 0, $bransjeTekst = null)
    {
        $this
            ->setBransjeKode($bransjeKode)
            ->setBransjeTekst($bransjeTekst);
    }
    /**
     * Get BransjeKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBransjeKode()
    {
        return isset($this->BransjeKode) ? $this->BransjeKode : null;
    }
    /**
     * Set BransjeKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bransjeKode
     * @return \StructType\BransjeData
     */
    public function setBransjeKode($bransjeKode = 0)
    {
        // validation for constraint: int
        if (!is_null($bransjeKode) && !is_numeric($bransjeKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bransjeKode)), __LINE__);
        }
        if (is_null($bransjeKode) || (is_array($bransjeKode) && empty($bransjeKode))) {
            unset($this->BransjeKode);
        } else {
            $this->BransjeKode = $bransjeKode;
        }
        return $this;
    }
    /**
     * Get BransjeTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBransjeTekst()
    {
        return isset($this->BransjeTekst) ? $this->BransjeTekst : null;
    }
    /**
     * Set BransjeTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bransjeTekst
     * @return \StructType\BransjeData
     */
    public function setBransjeTekst($bransjeTekst = null)
    {
        // validation for constraint: string
        if (!is_null($bransjeTekst) && !is_string($bransjeTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bransjeTekst)), __LINE__);
        }
        if (is_null($bransjeTekst) || (is_array($bransjeTekst) && empty($bransjeTekst))) {
            unset($this->BransjeTekst);
        } else {
            $this->BransjeTekst = $bransjeTekst;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BransjeData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
