<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Oppdater ServiceType
 * @subpackage Services
 */
class Oppdater extends AbstractSoapClientBase
{
    /**
     * Sets the BrukerAutorisasjon SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\BrukerAutorisasjon $brukerAutorisasjon
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderBrukerAutorisasjon(\StructType\BrukerAutorisasjon $brukerAutorisasjon, $nameSpace = 'http://dbonline.no/webservices/xsd/Autorisasjon', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'BrukerAutorisasjon', $brukerAutorisasjon, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named oppdaterOvervakningsportefolje
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: BrukerAutorisasjon
     * - SOAPHeaderNamespaces: http://dbonline.no/webservices/xsd/Autorisasjon
     * - SOAPHeaderTypes: \StructType\BrukerAutorisasjon
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OppdaterOvervakningPortefolje $oppdaterOvervakningsportefoljeReq
     * @return \StructType\OppdaterOvervakningPortefoljeResponse|bool
     */
    public function oppdaterOvervakningsportefolje(\StructType\OppdaterOvervakningPortefolje $oppdaterOvervakningsportefoljeReq)
    {
        try {
            $this->setResult(self::getSoapClient()->oppdaterOvervakningsportefolje($oppdaterOvervakningsportefoljeReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OppdaterOvervakningPortefoljeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
