<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hent ServiceType
 * @subpackage Services
 */
class Hent extends AbstractSoapClientBase
{
    /**
     * Sets the BrukerAutorisasjon SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\BrukerAutorisasjon $brukerAutorisasjon
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderBrukerAutorisasjon(\StructType\BrukerAutorisasjon $brukerAutorisasjon, $nameSpace = 'http://dbonline.no/webservices/xsd/Autorisasjon', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'BrukerAutorisasjon', $brukerAutorisasjon, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named hentOvervakningInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: BrukerAutorisasjon
     * - SOAPHeaderNamespaces: http://dbonline.no/webservices/xsd/Autorisasjon
     * - SOAPHeaderTypes: \StructType\BrukerAutorisasjon
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HentOvervakningEndringer $hentOvervakningInfoReq
     * @return \StructType\HentOvervakningEndringerResponse|bool
     */
    public function hentOvervakningInfo(\StructType\HentOvervakningEndringer $hentOvervakningInfoReq)
    {
        try {
            $this->setResult(self::getSoapClient()->hentOvervakningInfo($hentOvervakningInfoReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hentForetakinfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: BrukerAutorisasjon
     * - SOAPHeaderNamespaces: http://dbonline.no/webservices/xsd/Autorisasjon
     * - SOAPHeaderTypes: \StructType\BrukerAutorisasjon
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HentForetak $hentForetakReq
     * @return \StructType\HentForetakResponse|bool
     */
    public function hentForetakinfo(\StructType\HentForetak $hentForetakReq)
    {
        try {
            $this->setResult(self::getSoapClient()->hentForetakinfo($hentForetakReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hentArsrapportListe
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: BrukerAutorisasjon
     * - SOAPHeaderNamespaces: http://dbonline.no/webservices/xsd/Autorisasjon
     * - SOAPHeaderTypes: \StructType\BrukerAutorisasjon
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HentArsrapportListe $hentArsrapportListeReq
     * @return \StructType\HentArsrapportListeResponse|bool
     */
    public function hentArsrapportListe(\StructType\HentArsrapportListe $hentArsrapportListeReq)
    {
        try {
            $this->setResult(self::getSoapClient()->hentArsrapportListe($hentArsrapportListeReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hentArsrapport
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: BrukerAutorisasjon
     * - SOAPHeaderNamespaces: http://dbonline.no/webservices/xsd/Autorisasjon
     * - SOAPHeaderTypes: \StructType\BrukerAutorisasjon
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HentArsrapport $hentArsrapportReq
     * @return \StructType\HentArsrapportResponse|bool
     */
    public function hentArsrapport(\StructType\HentArsrapport $hentArsrapportReq)
    {
        try {
            $this->setResult(self::getSoapClient()->hentArsrapport($hentArsrapportReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HentArsrapportListeResponse|\StructType\HentArsrapportResponse|\StructType\HentForetakResponse|\StructType\HentOvervakningEndringerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
