<?php

namespace EnumType;

/**
 * This class stands for RapportVerdier EnumType
 * @subpackage Enumerations
 */
class RapportVerdier
{
    /**
     * Constant for value 'Rating'
     * @return string 'Rating'
     */
    const VALUE_RATING = 'Rating';
    /**
     * Constant for value 'Kompakt'
     * @return string 'Kompakt'
     */
    const VALUE_KOMPAKT = 'Kompakt';
    /**
     * Constant for value 'Total'
     * @return string 'Total'
     */
    const VALUE_TOTAL = 'Total';
    /**
     * Constant for value 'Avdeling'
     * @return string 'Avdeling'
     */
    const VALUE_AVDELING = 'Avdeling';
    /**
     * Constant for value 'Grunnrapport'
     * @return string 'Grunnrapport'
     */
    const VALUE_GRUNNRAPPORT = 'Grunnrapport';
    /**
     * Constant for value 'Firmaattest'
     * @return string 'Firmaattest'
     */
    const VALUE_FIRMAATTEST = 'Firmaattest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RATING
     * @uses self::VALUE_KOMPAKT
     * @uses self::VALUE_TOTAL
     * @uses self::VALUE_AVDELING
     * @uses self::VALUE_GRUNNRAPPORT
     * @uses self::VALUE_FIRMAATTEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RATING,
            self::VALUE_KOMPAKT,
            self::VALUE_TOTAL,
            self::VALUE_AVDELING,
            self::VALUE_GRUNNRAPPORT,
            self::VALUE_FIRMAATTEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
