<?php

namespace EnumType;

/**
 * This class stands for OvervakningOperasjon EnumType
 * @subpackage Enumerations
 */
class OvervakningOperasjon
{
    /**
     * Constant for value 'Innmelding'
     * @return string 'Innmelding'
     */
    const VALUE_INNMELDING = 'Innmelding';
    /**
     * Constant for value 'Utmelding'
     * @return string 'Utmelding'
     */
    const VALUE_UTMELDING = 'Utmelding';
    /**
     * Constant for value 'Liste'
     * @return string 'Liste'
     */
    const VALUE_LISTE = 'Liste';
    /**
     * Constant for value 'Endre'
     * @return string 'Endre'
     */
    const VALUE_ENDRE = 'Endre';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INNMELDING
     * @uses self::VALUE_UTMELDING
     * @uses self::VALUE_LISTE
     * @uses self::VALUE_ENDRE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INNMELDING,
            self::VALUE_UTMELDING,
            self::VALUE_LISTE,
            self::VALUE_ENDRE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
