<?php

namespace EnumType;

/**
 * This class stands for BetaVerdier EnumType
 * @subpackage Enumerations
 */
class BetaVerdier
{
    /**
     * Constant for value 'Detaljer'
     * @return string 'Detaljer'
     */
    const VALUE_DETALJER = 'Detaljer';
    /**
     * Constant for value 'Sammendrag'
     * @return string 'Sammendrag'
     */
    const VALUE_SAMMENDRAG = 'Sammendrag';
    /**
     * Constant for value 'DetaljerSammendrag'
     * @return string 'DetaljerSammendrag'
     */
    const VALUE_DETALJER_SAMMENDRAG = 'DetaljerSammendrag';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DETALJER
     * @uses self::VALUE_SAMMENDRAG
     * @uses self::VALUE_DETALJER_SAMMENDRAG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DETALJER,
            self::VALUE_SAMMENDRAG,
            self::VALUE_DETALJER_SAMMENDRAG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
