<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OvervakningListe StructType
 * @subpackage Structs
 */
class OvervakningListe extends AbstractStructBase
{
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Orgnr;
    /**
     * The Dunsnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Dunsnr;
    /**
     * The KodeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KodeType;
    /**
     * The KodeTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KodeTekst;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Navn;
    /**
     * The Adresse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Postnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Postnr;
    /**
     * The Poststed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Poststed;
    /**
     * The Telefon
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Telefon;
    /**
     * The Kunderef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kunderef;
    /**
     * The Avdnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Avdnr;
    /**
     * The TypeKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeKode;
    /**
     * The TypeTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeTekst;
    /**
     * Constructor method for OvervakningListe
     * @uses OvervakningListe::setOrgnr()
     * @uses OvervakningListe::setDunsnr()
     * @uses OvervakningListe::setKodeType()
     * @uses OvervakningListe::setKodeTekst()
     * @uses OvervakningListe::setNavn()
     * @uses OvervakningListe::setAdresse()
     * @uses OvervakningListe::setPostnr()
     * @uses OvervakningListe::setPoststed()
     * @uses OvervakningListe::setTelefon()
     * @uses OvervakningListe::setKunderef()
     * @uses OvervakningListe::setAvdnr()
     * @uses OvervakningListe::setTypeKode()
     * @uses OvervakningListe::setTypeTekst()
     * @param int $orgnr
     * @param int $dunsnr
     * @param string $kodeType
     * @param string $kodeTekst
     * @param string $navn
     * @param string $adresse
     * @param int $postnr
     * @param string $poststed
     * @param int $telefon
     * @param string $kunderef
     * @param string $avdnr
     * @param string $typeKode
     * @param string $typeTekst
     */
    public function __construct($orgnr = 0, $dunsnr = 0, $kodeType = null, $kodeTekst = null, $navn = null, $adresse = null, $postnr = 0, $poststed = null, $telefon = 0, $kunderef = null, $avdnr = '0', $typeKode = null, $typeTekst = null)
    {
        $this
            ->setOrgnr($orgnr)
            ->setDunsnr($dunsnr)
            ->setKodeType($kodeType)
            ->setKodeTekst($kodeTekst)
            ->setNavn($navn)
            ->setAdresse($adresse)
            ->setPostnr($postnr)
            ->setPoststed($poststed)
            ->setTelefon($telefon)
            ->setKunderef($kunderef)
            ->setAvdnr($avdnr)
            ->setTypeKode($typeKode)
            ->setTypeTekst($typeTekst);
    }
    /**
     * Get Orgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrgnr()
    {
        return isset($this->Orgnr) ? $this->Orgnr : null;
    }
    /**
     * Set Orgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orgnr
     * @return \StructType\OvervakningListe
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        if (is_null($orgnr) || (is_array($orgnr) && empty($orgnr))) {
            unset($this->Orgnr);
        } else {
            $this->Orgnr = $orgnr;
        }
        return $this;
    }
    /**
     * Get Dunsnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDunsnr()
    {
        return isset($this->Dunsnr) ? $this->Dunsnr : null;
    }
    /**
     * Set Dunsnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dunsnr
     * @return \StructType\OvervakningListe
     */
    public function setDunsnr($dunsnr = 0)
    {
        // validation for constraint: int
        if (!is_null($dunsnr) && !is_numeric($dunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunsnr)), __LINE__);
        }
        if (is_null($dunsnr) || (is_array($dunsnr) && empty($dunsnr))) {
            unset($this->Dunsnr);
        } else {
            $this->Dunsnr = $dunsnr;
        }
        return $this;
    }
    /**
     * Get KodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKodeType()
    {
        return isset($this->KodeType) ? $this->KodeType : null;
    }
    /**
     * Set KodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kodeType
     * @return \StructType\OvervakningListe
     */
    public function setKodeType($kodeType = null)
    {
        // validation for constraint: string
        if (!is_null($kodeType) && !is_string($kodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodeType)), __LINE__);
        }
        if (is_null($kodeType) || (is_array($kodeType) && empty($kodeType))) {
            unset($this->KodeType);
        } else {
            $this->KodeType = $kodeType;
        }
        return $this;
    }
    /**
     * Get KodeTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKodeTekst()
    {
        return isset($this->KodeTekst) ? $this->KodeTekst : null;
    }
    /**
     * Set KodeTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kodeTekst
     * @return \StructType\OvervakningListe
     */
    public function setKodeTekst($kodeTekst = null)
    {
        // validation for constraint: string
        if (!is_null($kodeTekst) && !is_string($kodeTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodeTekst)), __LINE__);
        }
        if (is_null($kodeTekst) || (is_array($kodeTekst) && empty($kodeTekst))) {
            unset($this->KodeTekst);
        } else {
            $this->KodeTekst = $kodeTekst;
        }
        return $this;
    }
    /**
     * Get Navn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNavn()
    {
        return isset($this->Navn) ? $this->Navn : null;
    }
    /**
     * Set Navn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $navn
     * @return \StructType\OvervakningListe
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        if (is_null($navn) || (is_array($navn) && empty($navn))) {
            unset($this->Navn);
        } else {
            $this->Navn = $navn;
        }
        return $this;
    }
    /**
     * Get Adresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdresse()
    {
        return isset($this->Adresse) ? $this->Adresse : null;
    }
    /**
     * Set Adresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adresse
     * @return \StructType\OvervakningListe
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresse)), __LINE__);
        }
        if (is_null($adresse) || (is_array($adresse) && empty($adresse))) {
            unset($this->Adresse);
        } else {
            $this->Adresse = $adresse;
        }
        return $this;
    }
    /**
     * Get Postnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostnr()
    {
        return isset($this->Postnr) ? $this->Postnr : null;
    }
    /**
     * Set Postnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postnr
     * @return \StructType\OvervakningListe
     */
    public function setPostnr($postnr = 0)
    {
        // validation for constraint: int
        if (!is_null($postnr) && !is_numeric($postnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postnr)), __LINE__);
        }
        if (is_null($postnr) || (is_array($postnr) && empty($postnr))) {
            unset($this->Postnr);
        } else {
            $this->Postnr = $postnr;
        }
        return $this;
    }
    /**
     * Get Poststed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPoststed()
    {
        return isset($this->Poststed) ? $this->Poststed : null;
    }
    /**
     * Set Poststed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $poststed
     * @return \StructType\OvervakningListe
     */
    public function setPoststed($poststed = null)
    {
        // validation for constraint: string
        if (!is_null($poststed) && !is_string($poststed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poststed)), __LINE__);
        }
        if (is_null($poststed) || (is_array($poststed) && empty($poststed))) {
            unset($this->Poststed);
        } else {
            $this->Poststed = $poststed;
        }
        return $this;
    }
    /**
     * Get Telefon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTelefon()
    {
        return isset($this->Telefon) ? $this->Telefon : null;
    }
    /**
     * Set Telefon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $telefon
     * @return \StructType\OvervakningListe
     */
    public function setTelefon($telefon = 0)
    {
        // validation for constraint: int
        if (!is_null($telefon) && !is_numeric($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($telefon)), __LINE__);
        }
        if (is_null($telefon) || (is_array($telefon) && empty($telefon))) {
            unset($this->Telefon);
        } else {
            $this->Telefon = $telefon;
        }
        return $this;
    }
    /**
     * Get Kunderef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKunderef()
    {
        return isset($this->Kunderef) ? $this->Kunderef : null;
    }
    /**
     * Set Kunderef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kunderef
     * @return \StructType\OvervakningListe
     */
    public function setKunderef($kunderef = null)
    {
        // validation for constraint: string
        if (!is_null($kunderef) && !is_string($kunderef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kunderef)), __LINE__);
        }
        if (is_null($kunderef) || (is_array($kunderef) && empty($kunderef))) {
            unset($this->Kunderef);
        } else {
            $this->Kunderef = $kunderef;
        }
        return $this;
    }
    /**
     * Get Avdnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvdnr()
    {
        return isset($this->Avdnr) ? $this->Avdnr : null;
    }
    /**
     * Set Avdnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $avdnr
     * @return \StructType\OvervakningListe
     */
    public function setAvdnr($avdnr = '0')
    {
        // validation for constraint: string
        if (!is_null($avdnr) && !is_string($avdnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($avdnr)), __LINE__);
        }
        if (is_null($avdnr) || (is_array($avdnr) && empty($avdnr))) {
            unset($this->Avdnr);
        } else {
            $this->Avdnr = $avdnr;
        }
        return $this;
    }
    /**
     * Get TypeKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeKode()
    {
        return isset($this->TypeKode) ? $this->TypeKode : null;
    }
    /**
     * Set TypeKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeKode
     * @return \StructType\OvervakningListe
     */
    public function setTypeKode($typeKode = null)
    {
        // validation for constraint: string
        if (!is_null($typeKode) && !is_string($typeKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeKode)), __LINE__);
        }
        if (is_null($typeKode) || (is_array($typeKode) && empty($typeKode))) {
            unset($this->TypeKode);
        } else {
            $this->TypeKode = $typeKode;
        }
        return $this;
    }
    /**
     * Get TypeTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeTekst()
    {
        return isset($this->TypeTekst) ? $this->TypeTekst : null;
    }
    /**
     * Set TypeTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeTekst
     * @return \StructType\OvervakningListe
     */
    public function setTypeTekst($typeTekst = null)
    {
        // validation for constraint: string
        if (!is_null($typeTekst) && !is_string($typeTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeTekst)), __LINE__);
        }
        if (is_null($typeTekst) || (is_array($typeTekst) && empty($typeTekst))) {
            unset($this->TypeTekst);
        } else {
            $this->TypeTekst = $typeTekst;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OvervakningListe
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
