<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OppdaterOvervakningPortefolje StructType
 * @subpackage Structs
 */
class OppdaterOvervakningPortefolje extends AbstractStructBase
{
    /**
     * The RecordType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RecordType;
    /**
     * The Kunderef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Kunderef;
    /**
     * The NyKunderef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NyKunderef;
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Orgnr;
    /**
     * The Dunsnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Dunsnr;
    /**
     * The Kundekode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Kundekode;
    /**
     * The Overvakningstype
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Overvakningstype;
    /**
     * The Avdnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Avdnr;
    /**
     * Constructor method for OppdaterOvervakningPortefolje
     * @uses OppdaterOvervakningPortefolje::setRecordType()
     * @uses OppdaterOvervakningPortefolje::setKunderef()
     * @uses OppdaterOvervakningPortefolje::setNyKunderef()
     * @uses OppdaterOvervakningPortefolje::setOrgnr()
     * @uses OppdaterOvervakningPortefolje::setDunsnr()
     * @uses OppdaterOvervakningPortefolje::setKundekode()
     * @uses OppdaterOvervakningPortefolje::setOvervakningstype()
     * @uses OppdaterOvervakningPortefolje::setAvdnr()
     * @param string $recordType
     * @param string $kunderef
     * @param string $nyKunderef
     * @param int $orgnr
     * @param string $dunsnr
     * @param string $kundekode
     * @param string $overvakningstype
     * @param string $avdnr
     */
    public function __construct($recordType = null, $kunderef = null, $nyKunderef = null, $orgnr = null, $dunsnr = null, $kundekode = null, $overvakningstype = null, $avdnr = null)
    {
        $this
            ->setRecordType($recordType)
            ->setKunderef($kunderef)
            ->setNyKunderef($nyKunderef)
            ->setOrgnr($orgnr)
            ->setDunsnr($dunsnr)
            ->setKundekode($kundekode)
            ->setOvervakningstype($overvakningstype)
            ->setAvdnr($avdnr);
    }
    /**
     * Get RecordType value
     * @return string
     */
    public function getRecordType()
    {
        return $this->RecordType;
    }
    /**
     * Set RecordType value
     * @uses \EnumType\OvervakningOperasjon::valueIsValid()
     * @uses \EnumType\OvervakningOperasjon::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordType
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public function setRecordType($recordType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OvervakningOperasjon::valueIsValid($recordType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordType, implode(', ', \EnumType\OvervakningOperasjon::getValidValues())), __LINE__);
        }
        $this->RecordType = $recordType;
        return $this;
    }
    /**
     * Get Kunderef value
     * @return string
     */
    public function getKunderef()
    {
        return $this->Kunderef;
    }
    /**
     * Set Kunderef value
     * @param string $kunderef
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public function setKunderef($kunderef = null)
    {
        // validation for constraint: string
        if (!is_null($kunderef) && !is_string($kunderef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kunderef)), __LINE__);
        }
        $this->Kunderef = $kunderef;
        return $this;
    }
    /**
     * Get NyKunderef value
     * @return string
     */
    public function getNyKunderef()
    {
        return $this->NyKunderef;
    }
    /**
     * Set NyKunderef value
     * @param string $nyKunderef
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public function setNyKunderef($nyKunderef = null)
    {
        // validation for constraint: string
        if (!is_null($nyKunderef) && !is_string($nyKunderef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nyKunderef)), __LINE__);
        }
        $this->NyKunderef = $nyKunderef;
        return $this;
    }
    /**
     * Get Orgnr value
     * @return int
     */
    public function getOrgnr()
    {
        return $this->Orgnr;
    }
    /**
     * Set Orgnr value
     * @param int $orgnr
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public function setOrgnr($orgnr = null)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        $this->Orgnr = $orgnr;
        return $this;
    }
    /**
     * Get Dunsnr value
     * @return string
     */
    public function getDunsnr()
    {
        return $this->Dunsnr;
    }
    /**
     * Set Dunsnr value
     * @param string $dunsnr
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public function setDunsnr($dunsnr = null)
    {
        // validation for constraint: string
        if (!is_null($dunsnr) && !is_string($dunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dunsnr)), __LINE__);
        }
        $this->Dunsnr = $dunsnr;
        return $this;
    }
    /**
     * Get Kundekode value
     * @return string
     */
    public function getKundekode()
    {
        return $this->Kundekode;
    }
    /**
     * Set Kundekode value
     * @param string $kundekode
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public function setKundekode($kundekode = null)
    {
        // validation for constraint: string
        if (!is_null($kundekode) && !is_string($kundekode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kundekode)), __LINE__);
        }
        $this->Kundekode = $kundekode;
        return $this;
    }
    /**
     * Get Overvakningstype value
     * @return string
     */
    public function getOvervakningstype()
    {
        return $this->Overvakningstype;
    }
    /**
     * Set Overvakningstype value
     * @uses \EnumType\Overvakningstype::valueIsValid()
     * @uses \EnumType\Overvakningstype::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overvakningstype
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public function setOvervakningstype($overvakningstype = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Overvakningstype::valueIsValid($overvakningstype)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $overvakningstype, implode(', ', \EnumType\Overvakningstype::getValidValues())), __LINE__);
        }
        $this->Overvakningstype = $overvakningstype;
        return $this;
    }
    /**
     * Get Avdnr value
     * @return string|null
     */
    public function getAvdnr()
    {
        return $this->Avdnr;
    }
    /**
     * Set Avdnr value
     * @param string $avdnr
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public function setAvdnr($avdnr = null)
    {
        // validation for constraint: string
        if (!is_null($avdnr) && !is_string($avdnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($avdnr)), __LINE__);
        }
        $this->Avdnr = $avdnr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OppdaterOvervakningPortefolje
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
