<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NaringsInteresserGjenpart StructType
 * @subpackage Structs
 */
class NaringsInteresserGjenpart extends AbstractStructBase
{
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Orgnr;
    /**
     * The StatusKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusKode;
    /**
     * The StatusTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusTekst;
    /**
     * The StatusDato
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDato;
    /**
     * The Navn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Navn;
    /**
     * The SelskapsFormKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SelskapsFormKode;
    /**
     * The SelskapsFormTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SelskapsFormTekst;
    /**
     * The RolleKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RolleKode;
    /**
     * The RolleTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RolleTekst;
    /**
     * The Eierandel
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Eierandel;
    /**
     * The VervKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VervKode;
    /**
     * The VervTekst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VervTekst;
    /**
     * Constructor method for NaringsInteresserGjenpart
     * @uses NaringsInteresserGjenpart::setOrgnr()
     * @uses NaringsInteresserGjenpart::setStatusKode()
     * @uses NaringsInteresserGjenpart::setStatusTekst()
     * @uses NaringsInteresserGjenpart::setStatusDato()
     * @uses NaringsInteresserGjenpart::setNavn()
     * @uses NaringsInteresserGjenpart::setSelskapsFormKode()
     * @uses NaringsInteresserGjenpart::setSelskapsFormTekst()
     * @uses NaringsInteresserGjenpart::setRolleKode()
     * @uses NaringsInteresserGjenpart::setRolleTekst()
     * @uses NaringsInteresserGjenpart::setEierandel()
     * @uses NaringsInteresserGjenpart::setVervKode()
     * @uses NaringsInteresserGjenpart::setVervTekst()
     * @param int $orgnr
     * @param string $statusKode
     * @param string $statusTekst
     * @param string $statusDato
     * @param string $navn
     * @param string $selskapsFormKode
     * @param string $selskapsFormTekst
     * @param string $rolleKode
     * @param string $rolleTekst
     * @param float $eierandel
     * @param string $vervKode
     * @param string $vervTekst
     */
    public function __construct($orgnr = 0, $statusKode = null, $statusTekst = null, $statusDato = '0001-01-01', $navn = null, $selskapsFormKode = null, $selskapsFormTekst = null, $rolleKode = null, $rolleTekst = null, $eierandel = 0, $vervKode = null, $vervTekst = null)
    {
        $this
            ->setOrgnr($orgnr)
            ->setStatusKode($statusKode)
            ->setStatusTekst($statusTekst)
            ->setStatusDato($statusDato)
            ->setNavn($navn)
            ->setSelskapsFormKode($selskapsFormKode)
            ->setSelskapsFormTekst($selskapsFormTekst)
            ->setRolleKode($rolleKode)
            ->setRolleTekst($rolleTekst)
            ->setEierandel($eierandel)
            ->setVervKode($vervKode)
            ->setVervTekst($vervTekst);
    }
    /**
     * Get Orgnr value
     * @return int|null
     */
    public function getOrgnr()
    {
        return $this->Orgnr;
    }
    /**
     * Set Orgnr value
     * @param int $orgnr
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        $this->Orgnr = $orgnr;
        return $this;
    }
    /**
     * Get StatusKode value
     * @return string|null
     */
    public function getStatusKode()
    {
        return $this->StatusKode;
    }
    /**
     * Set StatusKode value
     * @param string $statusKode
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setStatusKode($statusKode = null)
    {
        // validation for constraint: string
        if (!is_null($statusKode) && !is_string($statusKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusKode)), __LINE__);
        }
        $this->StatusKode = $statusKode;
        return $this;
    }
    /**
     * Get StatusTekst value
     * @return string|null
     */
    public function getStatusTekst()
    {
        return $this->StatusTekst;
    }
    /**
     * Set StatusTekst value
     * @param string $statusTekst
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setStatusTekst($statusTekst = null)
    {
        // validation for constraint: string
        if (!is_null($statusTekst) && !is_string($statusTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusTekst)), __LINE__);
        }
        $this->StatusTekst = $statusTekst;
        return $this;
    }
    /**
     * Get StatusDato value
     * @return string|null
     */
    public function getStatusDato()
    {
        return $this->StatusDato;
    }
    /**
     * Set StatusDato value
     * @param string $statusDato
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setStatusDato($statusDato = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($statusDato) && !is_string($statusDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDato)), __LINE__);
        }
        $this->StatusDato = $statusDato;
        return $this;
    }
    /**
     * Get Navn value
     * @return string|null
     */
    public function getNavn()
    {
        return $this->Navn;
    }
    /**
     * Set Navn value
     * @param string $navn
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setNavn($navn = null)
    {
        // validation for constraint: string
        if (!is_null($navn) && !is_string($navn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navn)), __LINE__);
        }
        $this->Navn = $navn;
        return $this;
    }
    /**
     * Get SelskapsFormKode value
     * @return string|null
     */
    public function getSelskapsFormKode()
    {
        return $this->SelskapsFormKode;
    }
    /**
     * Set SelskapsFormKode value
     * @param string $selskapsFormKode
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setSelskapsFormKode($selskapsFormKode = null)
    {
        // validation for constraint: string
        if (!is_null($selskapsFormKode) && !is_string($selskapsFormKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selskapsFormKode)), __LINE__);
        }
        $this->SelskapsFormKode = $selskapsFormKode;
        return $this;
    }
    /**
     * Get SelskapsFormTekst value
     * @return string|null
     */
    public function getSelskapsFormTekst()
    {
        return $this->SelskapsFormTekst;
    }
    /**
     * Set SelskapsFormTekst value
     * @param string $selskapsFormTekst
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setSelskapsFormTekst($selskapsFormTekst = null)
    {
        // validation for constraint: string
        if (!is_null($selskapsFormTekst) && !is_string($selskapsFormTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selskapsFormTekst)), __LINE__);
        }
        $this->SelskapsFormTekst = $selskapsFormTekst;
        return $this;
    }
    /**
     * Get RolleKode value
     * @return string|null
     */
    public function getRolleKode()
    {
        return $this->RolleKode;
    }
    /**
     * Set RolleKode value
     * @param string $rolleKode
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setRolleKode($rolleKode = null)
    {
        // validation for constraint: string
        if (!is_null($rolleKode) && !is_string($rolleKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rolleKode)), __LINE__);
        }
        $this->RolleKode = $rolleKode;
        return $this;
    }
    /**
     * Get RolleTekst value
     * @return string|null
     */
    public function getRolleTekst()
    {
        return $this->RolleTekst;
    }
    /**
     * Set RolleTekst value
     * @param string $rolleTekst
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setRolleTekst($rolleTekst = null)
    {
        // validation for constraint: string
        if (!is_null($rolleTekst) && !is_string($rolleTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rolleTekst)), __LINE__);
        }
        $this->RolleTekst = $rolleTekst;
        return $this;
    }
    /**
     * Get Eierandel value
     * @return float|null
     */
    public function getEierandel()
    {
        return $this->Eierandel;
    }
    /**
     * Set Eierandel value
     * @param float $eierandel
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setEierandel($eierandel = 0)
    {
        $this->Eierandel = $eierandel;
        return $this;
    }
    /**
     * Get VervKode value
     * @return string|null
     */
    public function getVervKode()
    {
        return $this->VervKode;
    }
    /**
     * Set VervKode value
     * @param string $vervKode
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setVervKode($vervKode = null)
    {
        // validation for constraint: string
        if (!is_null($vervKode) && !is_string($vervKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vervKode)), __LINE__);
        }
        $this->VervKode = $vervKode;
        return $this;
    }
    /**
     * Get VervTekst value
     * @return string|null
     */
    public function getVervTekst()
    {
        return $this->VervTekst;
    }
    /**
     * Set VervTekst value
     * @param string $vervTekst
     * @return \StructType\NaringsInteresserGjenpart
     */
    public function setVervTekst($vervTekst = null)
    {
        // validation for constraint: string
        if (!is_null($vervTekst) && !is_string($vervTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vervTekst)), __LINE__);
        }
        $this->VervTekst = $vervTekst;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NaringsInteresserGjenpart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
