<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kreditorvarsel StructType
 * @subpackage Structs
 */
class Kreditorvarsel extends AbstractStructBase
{
    /**
     * The KreditorKode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KreditorKode;
    /**
     * The KreditorKodeBeskrivelse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KreditorKodeBeskrivelse;
    /**
     * The RegistrertDato
     * Meta informations extracted from the WSDL
     * - default: 0001-01-01
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrertDato;
    /**
     * The ReferanseOffnr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReferanseOffnr;
    /**
     * Constructor method for Kreditorvarsel
     * @uses Kreditorvarsel::setKreditorKode()
     * @uses Kreditorvarsel::setKreditorKodeBeskrivelse()
     * @uses Kreditorvarsel::setRegistrertDato()
     * @uses Kreditorvarsel::setReferanseOffnr()
     * @param string $kreditorKode
     * @param string $kreditorKodeBeskrivelse
     * @param string $registrertDato
     * @param int $referanseOffnr
     */
    public function __construct($kreditorKode = null, $kreditorKodeBeskrivelse = null, $registrertDato = '0001-01-01', $referanseOffnr = null)
    {
        $this
            ->setKreditorKode($kreditorKode)
            ->setKreditorKodeBeskrivelse($kreditorKodeBeskrivelse)
            ->setRegistrertDato($registrertDato)
            ->setReferanseOffnr($referanseOffnr);
    }
    /**
     * Get KreditorKode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreditorKode()
    {
        return isset($this->KreditorKode) ? $this->KreditorKode : null;
    }
    /**
     * Set KreditorKode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreditorKode
     * @return \StructType\Kreditorvarsel
     */
    public function setKreditorKode($kreditorKode = null)
    {
        // validation for constraint: string
        if (!is_null($kreditorKode) && !is_string($kreditorKode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kreditorKode)), __LINE__);
        }
        if (is_null($kreditorKode) || (is_array($kreditorKode) && empty($kreditorKode))) {
            unset($this->KreditorKode);
        } else {
            $this->KreditorKode = $kreditorKode;
        }
        return $this;
    }
    /**
     * Get KreditorKodeBeskrivelse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreditorKodeBeskrivelse()
    {
        return isset($this->KreditorKodeBeskrivelse) ? $this->KreditorKodeBeskrivelse : null;
    }
    /**
     * Set KreditorKodeBeskrivelse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreditorKodeBeskrivelse
     * @return \StructType\Kreditorvarsel
     */
    public function setKreditorKodeBeskrivelse($kreditorKodeBeskrivelse = null)
    {
        // validation for constraint: string
        if (!is_null($kreditorKodeBeskrivelse) && !is_string($kreditorKodeBeskrivelse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kreditorKodeBeskrivelse)), __LINE__);
        }
        if (is_null($kreditorKodeBeskrivelse) || (is_array($kreditorKodeBeskrivelse) && empty($kreditorKodeBeskrivelse))) {
            unset($this->KreditorKodeBeskrivelse);
        } else {
            $this->KreditorKodeBeskrivelse = $kreditorKodeBeskrivelse;
        }
        return $this;
    }
    /**
     * Get RegistrertDato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrertDato()
    {
        return isset($this->RegistrertDato) ? $this->RegistrertDato : null;
    }
    /**
     * Set RegistrertDato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrertDato
     * @return \StructType\Kreditorvarsel
     */
    public function setRegistrertDato($registrertDato = '0001-01-01')
    {
        // validation for constraint: string
        if (!is_null($registrertDato) && !is_string($registrertDato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrertDato)), __LINE__);
        }
        if (is_null($registrertDato) || (is_array($registrertDato) && empty($registrertDato))) {
            unset($this->RegistrertDato);
        } else {
            $this->RegistrertDato = $registrertDato;
        }
        return $this;
    }
    /**
     * Get ReferanseOffnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReferanseOffnr()
    {
        return isset($this->ReferanseOffnr) ? $this->ReferanseOffnr : null;
    }
    /**
     * Set ReferanseOffnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $referanseOffnr
     * @return \StructType\Kreditorvarsel
     */
    public function setReferanseOffnr($referanseOffnr = null)
    {
        // validation for constraint: int
        if (!is_null($referanseOffnr) && !is_numeric($referanseOffnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($referanseOffnr)), __LINE__);
        }
        if (is_null($referanseOffnr) || (is_array($referanseOffnr) && empty($referanseOffnr))) {
            unset($this->ReferanseOffnr);
        } else {
            $this->ReferanseOffnr = $referanseOffnr;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Kreditorvarsel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
