<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identifikasjon StructType
 * @subpackage Structs
 */
class Identifikasjon extends AbstractStructBase
{
    /**
     * The Orgnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Orgnr;
    /**
     * The Dunsnr
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Dunsnr;
    /**
     * Constructor method for Identifikasjon
     * @uses Identifikasjon::setOrgnr()
     * @uses Identifikasjon::setDunsnr()
     * @param int $orgnr
     * @param int $dunsnr
     */
    public function __construct($orgnr = 0, $dunsnr = 0)
    {
        $this
            ->setOrgnr($orgnr)
            ->setDunsnr($dunsnr);
    }
    /**
     * Get Orgnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrgnr()
    {
        return isset($this->Orgnr) ? $this->Orgnr : null;
    }
    /**
     * Set Orgnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orgnr
     * @return \StructType\Identifikasjon
     */
    public function setOrgnr($orgnr = 0)
    {
        // validation for constraint: int
        if (!is_null($orgnr) && !is_numeric($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgnr)), __LINE__);
        }
        if (is_null($orgnr) || (is_array($orgnr) && empty($orgnr))) {
            unset($this->Orgnr);
        } else {
            $this->Orgnr = $orgnr;
        }
        return $this;
    }
    /**
     * Get Dunsnr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDunsnr()
    {
        return isset($this->Dunsnr) ? $this->Dunsnr : null;
    }
    /**
     * Set Dunsnr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dunsnr
     * @return \StructType\Identifikasjon
     */
    public function setDunsnr($dunsnr = 0)
    {
        // validation for constraint: int
        if (!is_null($dunsnr) && !is_numeric($dunsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunsnr)), __LINE__);
        }
        if (is_null($dunsnr) || (is_array($dunsnr) && empty($dunsnr))) {
            unset($this->Dunsnr);
        } else {
            $this->Dunsnr = $dunsnr;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Identifikasjon
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
